package com.ejianc.foundation.orgcenter.bean;

import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 部门bean
 * 
 * @author guominga
 */
@TableName("ejc_idm_dept")
public class DeptEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "org_id")
	private Long orgId;// 公司Id

	@TableField(value = "code")
	private String code;// 部门编号

	@TableField(value = "name")
	private String name;// 部门名称

	@TableField(value = "short_name")
	private String shortName;// 部门简称

	@TableField(value = "manager")
	private String manager;// 负责人

	@TableField(value = "dept_head")
	private Long deptHead;// 部门负责人

	@TableField(value = "phone")
	private String phone; // 负责人电话

	@TableField(value = "note")
	private String note; // 部门描述

	@TableField(value = "state")
	private Integer state; // 1：启用 ， 0：停用

	@TableField(value = "sequence")
	private Integer sequence; // 排序号

	/**
	 * 部门类型：1、普通部门, 2-虚拟部门
	 */
	@TableField(value = "type")
	private Integer type;

	@TableField(value = "source_id")
	private String sourceId; // 来源组织id

	@TableField(value = "system_id")
	private String systemId; // 系统id

	@TableField(value = "source_org_id")
	private String sourceOrgId; // 来源组织id(同步数据使用）

	@TableField(value = "pid")
	private Long pid;// 上级部门idId

	@TableField(exist=false)
	private List<DeptEntity> children;

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getManager() {
		return manager;
	}

	public void setManager(String manager) {
		this.manager = manager;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getSourceOrgId() {
		return sourceOrgId;
	}

	public void setSourceOrgId(String sourceOrgId) {
		this.sourceOrgId = sourceOrgId;
	}

	public Long getPid() {
		return pid;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}

	public List<DeptEntity> getChildren() {
		return children;
	}

	public void setChildren(List<DeptEntity> children) {
		this.children = children;
	}

	public Long getDeptHead() {
		return deptHead;
	}

	public void setDeptHead(Long deptHead) {
		this.deptHead = deptHead;
	}
	
}
