package com.ejianc.foundation.permission.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cache.AppCacheManage;
import com.ejianc.foundation.permission.bean.ButtonEntity;
import com.ejianc.foundation.permission.service.IButtonService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.bean.RoleAppRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleAppRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleButtonRelationMapper;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class RoleAppRelationServiceImpl extends BaseServiceImpl<RoleAppRelationMapper, RoleAppRelationEntity> implements IRoleAppRelationService {
	// 所有按钮缓存
	private final static String BTN_KEY = "btn_key:";

	@Autowired
	private RoleAppRelationMapper mapper;
	@Autowired
	private RoleButtonRelationMapper buttonmapper;
	@Autowired
	private PermissionCacheManage permissionCacheManage;
	@Autowired
	private IButtonService buttonService;
	@Autowired
	private AppCacheManage appCacheManage;

	@Override
	public IPage<AppVO> queryPage(Map<String, Object> params, boolean isEs) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = mapper.countByProPerties(params);
		IPage<AppVO> page = new Page<AppVO>();
		if(count>0){
			List<AppVO> appVO = mapper.queryPageByProperties(params);
			//查询按钮权限
			for(AppVO vo : appVO){
				//当按钮权限开启时查询按钮详情
				if(vo.getBtnPower()==1){
					Map<String, Object> param = new HashMap<>();
					param.put("roleId", params.get("roleId"));
					param.put("appId", vo.getId());
					param.put("dr", 0);
					List<ButtonVO> btnvos = buttonmapper.queryProperties(param);
					if(btnvos != null && btnvos.size() > 0) {
						vo.setChildren(btnvos);
                    }else{
						vo.setChildren(null);
					}
				}else{
					vo.setChildren(null);
				}
			}
			page.setRecords(appVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(List<RoleAppRelationEntity> appVos) {
		for(RoleAppRelationEntity appVo:appVos) {
			if("app".equals(appVo.getDataType())) {
				//先删除应用
				mapper.deleteAuthApp(appVo.getRoleId(),appVo.getAppId());

				//删除redis对应的角色应用
				permissionCacheManage.removeRoleAppsCache(appVo.getRoleId(), appVo.getAppId());

				/** 清除 按钮缓存*/
				Map<String, Object> param = new HashMap<>();
				param.put("roleId", appVo.getRoleId());
				param.put("appId", appVo.getAppId());
				param.put("dr", 0);
				List<ButtonVO> btnvos = buttonmapper.queryProperties(param);
				if(ListUtil.isNotEmpty(btnvos)){
					for(ButtonVO btn:btnvos){
						permissionCacheManage.removeRoleAppsBtnCache(appVo.getRoleId(),btn.getPageCode()+btn.getCode());
					}
				}
				//删除该应用下的所有授权按钮
				buttonmapper.deleteAuthButtonByAppId(appVo.getRoleId(),appVo.getAppId());
			}else if("button".equals(appVo.getDataType())) {
				/** 清除 按钮缓存*/
				ButtonEntity btn = buttonService.selectById(appVo.getButtonId());
				permissionCacheManage.removeRoleAppsBtnCache(appVo.getRoleId(),btn.getPageCode()+btn.getCode());
				//直接删除其按钮
				buttonmapper.deleteAuthButton(appVo.getRoleId(), appVo.getButtonId());
			}
		}
		return CommonResponse.success("删除成功");
	}

	@Override
	public List<AppVO> queryAuthListByRoleId(Long roleId) {
		List<AppVO> resultList = mapper.queryAuthListByRoleId(roleId);
		return resultList;
	}

	@Override
	public void delByRoleIds(List<Long> roleIdList) {
		QueryWrapper<RoleAppRelationEntity> roleAppListQuery = new QueryWrapper<>();
		roleAppListQuery.in("role_id", roleIdList);
		roleAppListQuery.in("dr", BaseVO.DR_DELETED);

		List<RoleAppRelationEntity> list = super.list(roleAppListQuery);
		if(CollectionUtils.isNotEmpty(list)) {
			this.delete(list);
		}
	}

	@Override
	public CommonResponse<Boolean> checkBtnHasPermission(String pageCode, String uiKey) {
		/** 从缓存获取按钮是否注册到app上 */
		ButtonVO btn = appCacheManage.getBtnCache(pageCode,uiKey);
		if(btn!=null){
			/** 查询到按钮，即按权限处理 */
			List<Long> roleIds = permissionCacheManage.getUserRoleCache(InvocationInfoProxy.getUserid(), InvocationInfoProxy.getTenantid());
			if(ListUtil.isNotEmpty(roleIds)){
				for (Long role:roleIds){
					boolean exist = permissionCacheManage.isExistInRoleAppBtnCache(role,pageCode+uiKey);
					if(exist){
						return CommonResponse.success(true);
					}
				}
				return CommonResponse.success(false);
			}else {
				return CommonResponse.success(false);
			}
		}
		/** 未查询到按钮，即按有权限处理 */
		return CommonResponse.success(true);
	}

	@Override
	public IPage<AppVO> queryBookRolePage(Map<String, Object> params, boolean b) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
			long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
			params.put("startLine", startLine);
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = mapper.countBookRole(params);
		IPage<AppVO> page = new Page<AppVO>();
		if(count>0){
			List<AppVO> appVO = mapper.queryBookRolePage(params);
			//查询按钮权限
			for(AppVO vo : appVO){
				//当按钮权限开启时查询按钮详情
				if(vo.getBtnPower()==1){
					Map<String, Object> param = new HashMap<>();
					param.put("roleId", params.get("roleId"));
					param.put("appId", vo.getId());
					param.put("dr", 0);
					List<ButtonVO> btnvos = buttonmapper.queryProperties(param);
					if(btnvos != null && btnvos.size() > 0) {
						vo.setChildren(btnvos);
					}else{
						vo.setChildren(null);
					}
				}else{
					vo.setChildren(null);
				}
			}
			page.setRecords(appVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	public IPage<AppVO> queryBookAppPage(Map<String, Object> params, boolean b) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
			long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
			params.put("startLine", startLine);
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = mapper.countBookApp(params);
		IPage<AppVO> page = new Page<AppVO>();
		if(count>0){
			List<AppVO> appVO = mapper.queryBookAppPage(params);
			//查询按钮权限
			for(AppVO vo : appVO){
				//当按钮权限开启时查询按钮详情
				if(vo.getBtnPower()==1){
					Map<String, Object> param = new HashMap<>();
					param.put("roleId", params.get("roleId"));
					param.put("appId", vo.getId());
					param.put("dr", 0);
					List<ButtonVO> btnvos = buttonmapper.queryProperties(param);
					if(btnvos != null && btnvos.size() > 0) {
						vo.setChildren(btnvos);
					}else{
						vo.setChildren(null);
					}
				}else{
					vo.setChildren(null);
				}
			}
			page.setRecords(appVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}
}
