package com.ejianc.foundation.tenant.service;

import com.ejianc.foundation.tenant.bean.PasswordPolicyEntity;
import com.ejianc.foundation.tenant.vo.PasswordPolicyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IPasswordPolicyService extends IBaseService<PasswordPolicyEntity> {

	/**
	 * 根据租户ID查询密码策略
	 * 
	 * @param tenantId 租户ID
	 * @return
	 */
	PasswordPolicyVO findByTenantId(Long tenantId);

	/**
	 * 查询指定租户的默认密码
	 *
	 * @param tenantId
	 * @return
	 */
	String getUserDefaultPassword(Long tenantId);

	CommonResponse<String> save(PasswordPolicyVO passwordPolicyVO, boolean b);

}
