package com.ejianc.foundation.orgcenter.service;

import java.util.List;

import com.ejianc.foundation.orgcenter.bean.PostEntity;
import com.ejianc.foundation.orgcenter.vo.PostVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 岗位bean
 * 
 * @author guominga
 *
 */
public interface IPostService extends IBaseService<PostEntity> {

    /**
     * 根据岗位Id列表批量删除岗位
     *
     * @param ids
     */
    void delete(List<Long> ids);

    /**
     * 根据岗位主键Id查询对应为岗位信息
     *
     * @param id
     * @return
     */
    PostVO queryDetail(Long id)  throws Exception;

    /**
     * 保存或更新岗位信息
     *
     * @param postVo
     */
    void save(PostVO postVo) throws Exception;

    /**
     * 停启用岗位
     *
     * @param postVO
     */
    void changeState(PostVO postVO) throws Exception;

    /**
     * 根据主键ID查询实体
     * 
     * @param postId
     * @return
     */
    PostEntity selectById(Long postId);

    /**
     * 根据岗位主键ID列表查询对应的岗位信息列表
     *
     * @param postIds
     * @return
     */
    List<PostEntity> getAllByIds(List<Long> postIds);

    /**
     * 更改岗位类型
     *
     * @param postVO
     */
    void changeType(PostVO postVO);

    /**
     * 同步平台公共岗位档案
     */
    void insertPostListFromPlatform();


    Integer getCountByPostDictId(Long id);

    PostVO getByCode(String code);
}
