package com.ejianc.foundation.permission.service;

import java.util.List;

import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IRoleService extends IBaseService<RoleEntity> {

	CommonResponse<String> save(RoleVO roleVO, boolean b, boolean levelAuthOpen);

	CommonResponse<String> delete(List<Long> ids);

	RoleVO queryDetail(Long id);

	/**
	 * 刷新角色授权缓存
	 * 
	 */
	void refreshAuthCache();

	/**
	 * 查询当前登录人的所有角色列表
	 * 
	 * @param userId
	 * @param tenantId
	 * @return
	 */
	List<Long> queryRoleIdstByCurrentUserId(Long userId, Long tenantId, UserContext userContext);

	List<RoleVO> queryRoleByUserId(Long userId, Long tenantId);

}
