package com.ejianc.foundation.tenant.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.tenant.bean.TenantMenuEntity;
import com.ejianc.foundation.tenant.vo.TenantMenuVO;
import com.ejianc.foundation.workbench.vo.MenuItemVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

/**
 * 租户自定义菜单
 * 
 * @author generator
 * 
 */
@Mapper
public interface TenantMenuMapper extends BaseCrudMapper<TenantMenuEntity> {
    /**
     * 根据查询当前租户下菜单
     * @param tenantId
     * @return
     */
    public List<MenuItemVO> queryTenantProperties(@Param("tenantId") Long tenantId,@Param("searchText") String searchText,@Param("mobile") String mobile);

    /**
     * 查询所有菜单
     * @param tenantId
     * @return
     */
    public List<MenuItemVO> queryMenuAll(@Param("tenantId") Long tenantId,@Param("code") String code,@Param("name") String name);

	public List<TenantMenuVO> queryCurrentTenantMenuList(@Param("appIdStr") String appIdStr,@Param("tenantId") Long tenantId);

}
