package com.ejianc.foundation.utils.gdty.param;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONObject;

public class GdtyOrg extends GdtyBaseParam {

	private static final long serialVersionUID = 1L;

	private String orgCode;

	private String orgName;

	private String orgType;

	private String orgLevel;

	private String parentOrgCode;

	private String parentOrgName;

	private String beginTime;

	private String endTime;

	private List<GdtyOrg> children = new ArrayList<GdtyOrg>();

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getOrgType() {
		return orgType;
	}

	public void setOrgType(String orgType) {
		this.orgType = orgType;
	}

	public String getOrgLevel() {
		return orgLevel;
	}

	public void setOrgLevel(String orgLevel) {
		this.orgLevel = orgLevel;
	}

	public String getParentOrgCode() {
		return parentOrgCode;
	}

	public void setParentOrgCode(String parentOrgCode) {
		this.parentOrgCode = parentOrgCode;
	}

	public String getParentOrgName() {
		return parentOrgName;
	}

	public void setParentOrgName(String parentOrgName) {
		this.parentOrgName = parentOrgName;
	}

	public String getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(String beginTime) {
		this.beginTime = beginTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public List<GdtyOrg> getChildren() {
		return children;
	}

	public void setChildren(List<GdtyOrg> children) {
		this.children = children;
	}

	public GdtyOrg(String orgCode, String orgName, String orgType, String orgLevel, String parentOrgCode,
			String parentOrgName, String beginTime, String endTime) {
		this.orgCode = orgCode;
		this.orgName = orgName;
		this.orgType = orgType;
		this.orgLevel = orgLevel;
		this.parentOrgCode = parentOrgCode;
		this.parentOrgName = parentOrgName;
		this.beginTime = beginTime;
		this.endTime = endTime;
	}

	public static GdtyOrg packageGdtyOrg(JSONObject jsonObject) {
		String recordId = jsonObject.getString("RecordID"); // 唯一RecordId
		String ZORGIDX = jsonObject.getString("ZORGIDX"); // MDG组织编码
		String ZORGID = jsonObject.getString("ZORGID"); // 组织编码Code
		String ZORGNAME = jsonObject.getString("ZORGNAME"); // 组织名称
		String ZORGCATG = jsonObject.getString("ZORGCATG"); // 组织类型
		String ZORGLEV = jsonObject.getString("ZORGLEV"); // 组织层级
		String ZSPORGID = jsonObject.getString("ZSPORGID"); // 上级组织编码
		String ZSPORGNAM = jsonObject.getString("ZSPORGNAM"); // 上级组织名称
		String ZBEGDAT = jsonObject.getString("ZBEGDAT");// 开始日期
		String ZENDDAT = jsonObject.getString("ZENDDAT"); // 结束日期
		String ZSTATUS = jsonObject.getString("ZSTATUS"); // 冻结状态

		GdtyOrg gdtyOrg = new GdtyOrg(ZORGID, ZORGNAME, ZORGCATG, ZORGLEV, ZSPORGID, ZSPORGNAM, ZBEGDAT, ZENDDAT);
		gdtyOrg.setRecordId(recordId);
		gdtyOrg.setMasterDataCode(ZORGIDX);
		gdtyOrg.setZstatus(ZSTATUS);
		return gdtyOrg;
	}
}
