/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.dataCompare.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.dataCompare.entity.DataCompareDetailEntity;
import com.ejianc.foundation.dataCompare.mapper.DataCompareDetailMapper;
import com.ejianc.foundation.dataCompare.service.IDataCompareDetailService;
import com.ejianc.foundation.dataCompare.vo.DataCompareDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class DataCompareDetailServiceImpl
extends BaseServiceImpl<DataCompareDetailMapper, DataCompareDetailEntity>
implements IDataCompareDetailService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DataCompareDetailMapper mapper;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String appId = request.getParameter("appId");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<DataCompareDetailVO> dataList = new ArrayList<DataCompareDetailVO>();
        ArrayList<DataCompareDetailVO> successList = new ArrayList<DataCompareDetailVO>();
        ArrayList<DataCompareDetailVO> errorList = new ArrayList<DataCompareDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        HashMap map = new HashMap();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        ArrayList<String> selfDataIdList = new ArrayList<String>();
        ArrayList<String> exitList = new ArrayList<String>();
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                DataCompareDetailVO vo = new DataCompareDetailVO();
                vo.setSelfDataId((String)datas.get(0));
                vo.setSelfDataCode((String)datas.get(1));
                vo.setSelfDataName((String)datas.get(2));
                vo.setAbutmentDataId((String)datas.get(3));
                vo.setAbutmentDataCode((String)datas.get(4));
                vo.setAbutmentDataName((String)datas.get(5));
                vo.setNotes((String)datas.get(6));
                vo.setAppId(Long.valueOf(Long.parseLong(appId)));
                if (StringUtils.isBlank((CharSequence)vo.getSelfDataCode())) {
                    vo.setId(Long.valueOf(IdWorker.getId()));
                    vo.setErrorMsg("\u672c\u7cfb\u7edf\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)vo.getAbutmentDataCode())) {
                    vo.setId(Long.valueOf(IdWorker.getId()));
                    vo.setErrorMsg("\u5bf9\u63a5\u7cfb\u7edf\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (exitList.contains(vo.getSelfDataId())) {
                    vo.setErrorMsg("\u5bfc\u5165\u6570\u636e\u4e2d\u672c\u7cfb\u7edf\u6570\u636eid\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\uff01");
                    vo.setId(Long.valueOf(IdWorker.getId()));
                    errorList.add(vo);
                    continue;
                }
                exitList.add(vo.getSelfDataId());
                selfDataIdList.add(vo.getSelfDataId());
                dataList.add(vo);
            }
            QueryWrapper selfDataIdWrapper = new QueryWrapper();
            selfDataIdWrapper.eq((Object)"dr", (Object)0);
            selfDataIdWrapper.eq((Object)"app_id", (Object)appId);
            selfDataIdWrapper.in((Object)"self_data_id", selfDataIdList);
            List selfDataIdDatas = this.list((Wrapper)selfDataIdWrapper);
            ArrayList<String> selfDataIdExitList = new ArrayList<String>();
            if (selfDataIdDatas != null && selfDataIdDatas.size() > 0) {
                for (DataCompareDetailEntity selfDataIdData : selfDataIdDatas) {
                    selfDataIdExitList.add(selfDataIdData.getSelfDataId());
                }
            }
            for (DataCompareDetailVO vo : dataList) {
                if (selfDataIdExitList.contains(vo.getSelfDataId())) {
                    vo.setErrorMsg("\u672c\u7cfb\u7edf\u6570\u636e\u7f16\u7801\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728\uff01");
                    vo.setId(Long.valueOf(IdWorker.getId()));
                    errorList.add(vo);
                    continue;
                }
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

