package com.ejianc.foundation.utils.gdty.param;

import com.alibaba.fastjson.JSONObject;

public class GdtyEmpJob extends GdtyBaseParam {

	private static final long serialVersionUID = 1L;

	private String postCode;

	private String postName;

	private String employeeCode;

	private String beginTime;

	private String endTime;

	public String getPostCode() {
		return postCode;
	}

	public void setPostCode(String postCode) {
		this.postCode = postCode;
	}

	public String getPostName() {
		return postName;
	}

	public void setPostName(String postName) {
		this.postName = postName;
	}

	public String getEmployeeCode() {
		return employeeCode;
	}

	public void setEmployeeCode(String employeeCode) {
		this.employeeCode = employeeCode;
	}

	public String getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(String beginTime) {
		this.beginTime = beginTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public GdtyEmpJob(String postCode, String postName, String employeeCode, String beginTime, String endTime) {
		this.postCode = postCode;
		this.postName = postName;
		this.employeeCode = employeeCode;
		this.beginTime = beginTime;
		this.endTime = endTime;
	}
	
	public static GdtyEmpJob packageGdtyEmpJob(JSONObject jsonObject) {
		String recordId = jsonObject.getString("RecordID"); // 唯一RecordId
		String ZRLATID = jsonObject.getString("ZRLATID"); //MDG系统赋予的8位流水编码
		String ZBEGDAT = jsonObject.getString("ZBEGDAT");// 开始日期
		String ZENDDAT = jsonObject.getString("ZENDDAT"); // 结束日期
		String ZPERNR = jsonObject.getString("ZPERNR"); //员工编码
		String ZEPOSTID = jsonObject.getString("ZEPOSTID"); //岗位编码
		String ZEPOSTNAM = jsonObject.getString("ZEPOSTNAM"); //岗位名称
		String ZSTATUS = jsonObject.getString("ZSTATUS"); //冻结状态
		
		GdtyEmpJob gdtyEmpJob = new GdtyEmpJob(ZEPOSTID, ZEPOSTNAM, ZPERNR, ZBEGDAT, ZENDDAT);
		gdtyEmpJob.setRecordId(recordId);
		gdtyEmpJob.setMasterDataCode(ZRLATID);
		gdtyEmpJob.setZstatus(ZSTATUS);
		return gdtyEmpJob;
	}

}
