/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.bean.CollectAppEntity;
import com.ejianc.foundation.permission.mapper.CollectAppMapper;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.ICollectAppService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CollectAppServiceImpl
extends BaseServiceImpl<CollectAppMapper, CollectAppEntity>
implements ICollectAppService {
    @Value(value="${oms.tenantid}")
    private Long omsTenantid;
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private CollectAppMapper collectAppMapper;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IAppService appService;

    @Override
    public CommonResponse<List<AppVO>> queryListByUsrId() {
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        UserVO userVo = this.userService.selectById(userId);
        List<AppEntity> list = this.collectAppMapper.queryListByUsrId(userId, InvocationInfoProxy.getUserType(), tenantId);
        List<Long> userRoleIds = this.permissionCacheManage.getUserRoleCache(userId, tenantId);
        if (userRoleIds == null || userRoleIds.size() == 0) {
            userRoleIds = this.roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
        }
        HashMap<Long, Long> appIdMap = new HashMap<Long, Long>();
        if (userRoleIds != null && userRoleIds.size() > 0) {
            List<Long> appIds = null;
            for (Long roleId : userRoleIds) {
                appIds = this.permissionCacheManage.getRoleAppsCache(roleId);
                if (appIds == null || appIds.size() <= 0) continue;
                for (Long appId : appIds) {
                    appIdMap.put(appId, appId);
                }
            }
        }
        List<Long> omAppIds = null;
        omAppIds = 1 == userVo.getTypeId() ? ("999999".equals(tenantId.toString()) ? this.appService.queryAllOperateList() : this.appService.queryAllHasAuthOmsOprateList()) : ("999999".equals(tenantId.toString()) ? this.appService.queryAuthOperateList() : this.appService.queryAuthOperateOmsList());
        if (omAppIds != null) {
            for (Long omAppId : omAppIds) {
                if (appIdMap.containsKey(omAppId)) continue;
                appIdMap.put(omAppId, omAppId);
            }
        }
        ArrayList<Object> vos = new ArrayList<Object>();
        if (list != null && list.size() > 0) {
            for (AppEntity appEntity : list) {
                if (!appIdMap.containsKey(appEntity.getId())) continue;
                vos.add(BeanMapper.map((Object)((Object)appEntity), AppVO.class));
            }
        }
        return CommonResponse.success(vos);
    }

    @Override
    public CommonResponse<String> saveList(List<AppVO> vos) {
        ArrayList<CollectAppEntity> addEEntitys = new ArrayList<CollectAppEntity>();
        if (vos != null && vos.size() > 0) {
            Date currentDate = new Date();
            long currentTime = currentDate.getTime();
            int index = 1000;
            for (AppVO vo : vos) {
                if ("del".equals(vo.getRowState())) continue;
                CollectAppEntity entity = new CollectAppEntity();
                entity.setAppId(vo.getId());
                entity.setUserId(InvocationInfoProxy.getUserid());
                entity.setCreateTime(new Date(currentTime + (long)index));
                addEEntitys.add(entity);
                index += 1000;
            }
        }
        this.collectAppMapper.deleteCollectAppByUserId(InvocationInfoProxy.getUserid());
        if (addEEntitys != null && addEEntitys.size() > 0) {
            this.saveOrUpdateBatch(addEEntitys, addEEntitys.size(), false);
        }
        return CommonResponse.success();
    }

    @Override
    public void deleteCollectApp(String appId, Long userId) {
        this.collectAppMapper.deleteCollectApp(appId, userId);
    }
}

