/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.workbench.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cache.AppCacheManage;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.tenant.mapper.TenantMenuMapper;
import com.ejianc.foundation.tenant.service.impl.TenantMenuServiceImpl;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.MenuAsTree;
import com.ejianc.foundation.workbench.bean.MenuEntity;
import com.ejianc.foundation.workbench.mapper.MenuMapper;
import com.ejianc.foundation.workbench.service.IMenuService;
import com.ejianc.foundation.workbench.vo.MenuItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
extends BaseServiceImpl<MenuMapper, MenuEntity>
implements IMenuService {
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantMenuServiceImpl.class);
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private IUserService userService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IAppService appService;
    @Autowired
    private AppCacheManage appCacheManage;
    @Autowired
    private TenantMenuMapper tenantMenuMapper;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public MenuEntity getOneById(Long id) {
        return (MenuEntity)((Object)((MenuMapper)this.baseMapper).selectById(id));
    }

    @Override
    public List<MenuItemVO> queryMenuItemListByTenantId(Long tenantId, String systemId) {
        Long userId = InvocationInfoProxy.getUserid();
        List<MenuItemVO> entities = this.tenantMenuMapper.queryMenuAll(tenantId, systemId, userId, null, null);
        ArrayList<MenuItemVO> menuItemVos = new ArrayList<MenuItemVO>();
        if (entities != null && entities.size() > 0) {
            for (MenuItemVO entity : entities) {
                MenuItemVO menuItemVo = (MenuItemVO)BeanMapper.map((Object)entity, MenuItemVO.class);
                if (StringUtils.isNotBlank((CharSequence)menuItemVo.getIcon())) {
                    menuItemVo.setIcon("icon-" + menuItemVo.getIcon().split(":")[1]);
                }
                menuItemVos.add(menuItemVo);
            }
            return menuItemVos;
        }
        return null;
    }

    @Override
    public List<MenuItemVO> queryMenuListByCurrentUser(String systemId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long userId = InvocationInfoProxy.getUserid();
        UserVO userVo = this.userService.selectById(userId);
        List<Long> userRoleIds = this.permissionCacheManage.getUserRoleCache(userId, tenantId);
        if (userRoleIds == null || userRoleIds.size() == 0) {
            userRoleIds = this.roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
        }
        HashMap<Long, Long> appIdMap = new HashMap<Long, Long>();
        ArrayList<Long> appList = new ArrayList<Long>();
        if (userRoleIds != null && userRoleIds.size() > 0) {
            List<Long> appIds = null;
            for (Long roleId : userRoleIds) {
                appIds = this.permissionCacheManage.getRoleAppsCache(roleId);
                if (appIds == null || appIds.size() <= 0) continue;
                for (Long l : appIds) {
                    appIdMap.put(l, l);
                    appList.add(l);
                }
            }
        }
        List<Long> omAppIds = null;
        omAppIds = 1 == userVo.getTypeId() ? (this.OMS_TENANT.equals(tenantId.toString()) ? this.appService.queryAllOperateList() : this.appService.queryAllHasAuthOmsOprateList()) : (this.OMS_TENANT.equals(tenantId.toString()) ? this.appService.queryAuthOperateList() : this.appService.queryAuthOperateOmsList());
        if (omAppIds != null) {
            for (Long omAppId : omAppIds) {
                if (appIdMap.containsKey(omAppId)) continue;
                appIdMap.put(omAppId, omAppId);
                appList.add(omAppId);
            }
        }
        HashMap<Long, MenuItemVO> allMenuMap = new HashMap<Long, MenuItemVO>();
        ArrayList<MenuItemVO> childrens = new ArrayList<MenuItemVO>();
        List<MenuItemVO> menuItemList = this.queryMenuItemListByTenantId(tenantId, systemId);
        if (menuItemList != null && menuItemList.size() > 0) {
            for (MenuItemVO menuItemVo : menuItemList) {
                if (menuItemVo.getMobile() == 1) continue;
                allMenuMap.put(menuItemVo.getId(), menuItemVo);
                if (!appIdMap.containsKey(menuItemVo.getAppId())) continue;
                childrens.add(menuItemVo);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MenuItemVO menuItemVO : childrens) {
            String[] innerCodeArr = menuItemVO.getInnerCode().split("\\|");
            for (int i = 0; i < innerCodeArr.length; ++i) {
                if (hashMap.containsKey(innerCodeArr[i])) continue;
                hashMap.put(innerCodeArr[i], innerCodeArr[i]);
            }
        }
        ArrayList<MenuItemVO> resultVOList = new ArrayList<MenuItemVO>();
        for (MenuItemVO menuItemVo : menuItemList) {
            AppVO appVo;
            if (menuItemVo.getMobile() == 1 || !hashMap.containsKey(menuItemVo.getId().toString())) continue;
            if (menuItemVo.getAppId() != null && (appVo = this.appCacheManage.getAppsCache(menuItemVo.getTenantId(), menuItemVo.getAppId())) != null) {
                Object appIconSrc;
                menuItemVo.setAppPath(appVo.getPcUrl());
                menuItemVo.setOpenMode(appVo.getOpenMode());
                if (StringUtils.isNotEmpty((CharSequence)appVo.getAppAddPath())) {
                    menuItemVo.setAppAddPath(JSONObject.parseArray((String)appVo.getAppAddPath()));
                }
                if (StringUtils.isNotBlank((CharSequence)(appIconSrc = appVo.getAppIconSrc())) && ((String)appIconSrc).indexOf("http") == -1) {
                    appIconSrc = this.environmentTools.getBaseHost() + (String)appIconSrc;
                    appVo.setAppIconSrc((String)appIconSrc);
                }
                menuItemVo.setIcon(appVo.getAppIconSrc());
            }
            resultVOList.add(menuItemVo);
        }
        hashMap.clear();
        List<MenuItemVO> list = MenuAsTree.createTreeData(resultVOList);
        MenuItemVO collectMenu = new MenuItemVO();
        collectMenu.setId(Long.valueOf(999888L));
        collectMenu.setCode("collectApp");
        collectMenu.setName("\u6211\u7684\u6536\u85cf");
        collectMenu.setIcon("icon-shoucang");
        List<MenuItemVO> myCollectApps = this.tenantMenuMapper.queryMyCollectApps(tenantId, userId);
        if (myCollectApps != null && myCollectApps.size() > 0) {
            for (MenuItemVO myCollectApp : myCollectApps) {
                String appIconSrc;
                AppVO appVo;
                if (myCollectApp.getAppId() == null || !appIdMap.containsKey(myCollectApp.getAppId()) || (appVo = this.appCacheManage.getAppsCache(myCollectApp.getTenantId(), myCollectApp.getAppId())) == null) continue;
                myCollectApp.setAppPath(appVo.getPcUrl());
                myCollectApp.setOpenMode(appVo.getOpenMode());
                if (StringUtils.isNotEmpty((CharSequence)appVo.getAppAddPath())) {
                    myCollectApp.setAppAddPath(JSONObject.parseArray((String)appVo.getAppAddPath()));
                }
                if (StringUtils.isNotBlank((CharSequence)(appIconSrc = appVo.getAppIconSrc())) && appIconSrc.indexOf("http") == -1) {
                    appIconSrc = this.environmentTools.getBaseHost() + appIconSrc;
                    appVo.setAppIconSrc(appIconSrc);
                }
                myCollectApp.setIcon(appVo.getAppIconSrc());
            }
        }
        collectMenu.setChildren(myCollectApps);
        ArrayList<MenuItemVO> menuItemResults = new ArrayList<MenuItemVO>();
        menuItemResults.add(collectMenu);
        menuItemResults.addAll(list);
        return menuItemResults;
    }

    @Override
    public List<MenuItemVO> queryMobileMenuListByCurrentUser(String searchText) {
        List<MenuItemVO> list;
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long userId = InvocationInfoProxy.getUserid();
        UserVO userVo = this.userService.selectById(userId);
        List<Long> userRoleIds = this.permissionCacheManage.getUserRoleCache(userId, tenantId);
        if (userRoleIds == null || userRoleIds.size() == 0) {
            userRoleIds = this.roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
        }
        HashMap<Long, Long> appIdMap = new HashMap<Long, Long>();
        ArrayList<Long> appList = new ArrayList<Long>();
        if (userRoleIds != null && userRoleIds.size() > 0) {
            List<Long> appIds = null;
            for (Long roleId : userRoleIds) {
                appIds = this.permissionCacheManage.getRoleAppsCache(roleId);
                if (appIds == null || appIds.size() <= 0) continue;
                for (Long l : appIds) {
                    appIdMap.put(l, l);
                    appList.add(l);
                }
            }
        }
        List<Long> omAppIds = null;
        omAppIds = 1 == userVo.getTypeId() ? (this.OMS_TENANT.equals(tenantId.toString()) ? this.appService.queryAllOperateList() : this.appService.queryAllHasAuthOmsOprateList()) : (this.OMS_TENANT.equals(tenantId.toString()) ? this.appService.queryAuthOperateList() : this.appService.queryAuthOperateOmsList());
        if (omAppIds != null) {
            for (Long omAppId : omAppIds) {
                if (appIdMap.containsKey(omAppId)) continue;
                appIdMap.put(omAppId, omAppId);
                appList.add(omAppId);
            }
        }
        HashMap<Long, MenuItemVO> allMenuMap = new HashMap<Long, MenuItemVO>();
        ArrayList<MenuItemVO> childrens = new ArrayList<MenuItemVO>();
        List<MenuItemVO> menuItemList = this.queryMenuItemListByTenantId(tenantId, null);
        if (menuItemList != null && menuItemList.size() > 0) {
            for (MenuItemVO menuItemVo : menuItemList) {
                if (menuItemVo.getMobile() != 1) continue;
                allMenuMap.put(menuItemVo.getId(), menuItemVo);
                if (!appIdMap.containsKey(menuItemVo.getAppId())) continue;
                childrens.add(menuItemVo);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MenuItemVO menuItemVO : childrens) {
            String[] innerCodeArr = menuItemVO.getInnerCode().split("\\|");
            for (int i = 0; i < innerCodeArr.length; ++i) {
                if (hashMap.containsKey(innerCodeArr[i])) continue;
                hashMap.put(innerCodeArr[i], innerCodeArr[i]);
            }
        }
        ArrayList<MenuItemVO> resultVOList = new ArrayList<MenuItemVO>();
        for (MenuItemVO menuItemVo : menuItemList) {
            AppVO appVo;
            if (menuItemVo.getMobile() != 1 || !hashMap.containsKey(menuItemVo.getId().toString())) continue;
            if (menuItemVo.getAppId() != null && (appVo = this.appCacheManage.getAppsCache(menuItemVo.getTenantId(), menuItemVo.getAppId())) != null) {
                menuItemVo.setAppPath(appVo.getMobileUrl());
                String appIconSrc = appVo.getAppIconSrc();
                if (StringUtils.isNotBlank((CharSequence)appIconSrc) && appIconSrc.indexOf("http") == -1) {
                    appIconSrc = this.environmentTools.getBaseHost() + appIconSrc;
                    appVo.setAppIconSrc(appIconSrc);
                }
                menuItemVo.setIcon(appVo.getAppIconSrc());
            }
            if (StringUtils.isNotEmpty((CharSequence)searchText)) {
                if (!menuItemVo.getName().contains(searchText)) continue;
                resultVOList.add(menuItemVo);
                continue;
            }
            resultVOList.add(menuItemVo);
        }
        hashMap.clear();
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return MenuAsTree.createTreeData(resultVOList);
        }
        ArrayList<MenuItemVO> arrayList = new ArrayList<MenuItemVO>();
        HashMap<String, String> searchVOMap = new HashMap<String, String>();
        if (ListUtil.isNotEmpty(resultVOList)) {
            for (MenuItemVO menuItemVO : resultVOList) {
                if (!searchVOMap.containsKey(menuItemVO.getId() + "")) {
                    arrayList.add(menuItemVO);
                    searchVOMap.put(menuItemVO.getId() + "", menuItemVO.getId() + "");
                }
                String[] innerCodeArr = menuItemVO.getInnerCode().split("\\|");
                for (int i = 0; i < innerCodeArr.length; ++i) {
                    if (searchVOMap.containsKey(innerCodeArr[i])) continue;
                    arrayList.add((MenuItemVO)allMenuMap.get(Long.parseLong(innerCodeArr[i])));
                    searchVOMap.put(innerCodeArr[i], innerCodeArr[i]);
                }
            }
        }
        if (ListUtil.isNotEmpty(list = MenuAsTree.createTreeData(arrayList))) {
            list.removeIf(resVO -> ListUtil.isEmpty((List)resVO.getChildren()));
        }
        return list;
    }

    @Override
    public List<JSONObject> search(String searchText) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long userId = InvocationInfoProxy.getUserid();
        UserVO userVo = this.userService.selectById(userId);
        List<Long> userRoleIds = this.permissionCacheManage.getUserRoleCache(userId, tenantId);
        if (userRoleIds == null || userRoleIds.size() == 0) {
            userRoleIds = this.roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
        }
        HashMap<Long, Long> appIdMap = new HashMap<Long, Long>();
        if (userRoleIds != null && userRoleIds.size() > 0) {
            List<Long> appIds = null;
            for (Long roleId : userRoleIds) {
                appIds = this.permissionCacheManage.getRoleAppsCache(roleId);
                if (appIds == null || appIds.size() <= 0) continue;
                for (Long appId : appIds) {
                    appIdMap.put(appId, appId);
                }
            }
        }
        List<Long> omAppIds = null;
        omAppIds = 1 == userVo.getTypeId() ? (this.OMS_TENANT.equals(tenantId.toString()) ? this.appService.queryAllOperateList() : this.appService.queryAllHasAuthOmsOprateList()) : (this.OMS_TENANT.equals(tenantId.toString()) ? this.appService.queryAuthOperateList() : this.appService.queryAuthOperateOmsList());
        if (omAppIds != null) {
            for (Long omAppId : omAppIds) {
                if (appIdMap.containsKey(omAppId)) continue;
                appIdMap.put(omAppId, omAppId);
            }
        }
        List<MenuItemVO> menuItemVos = null;
        menuItemVos = this.OMS_TENANT.equals(tenantId + "") ? this.tenantMenuMapper.queryMenuAll(tenantId, null, userId, null, searchText) : this.tenantMenuMapper.queryTenantProperties(tenantId, searchText, null);
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        if (ListUtil.isNotEmpty(menuItemVos)) {
            int count = 1;
            for (MenuItemVO menuItemVo : menuItemVos) {
                if (!appIdMap.containsKey(menuItemVo.getAppId())) continue;
                AppVO appVo = this.appCacheManage.getAppsCache(menuItemVo.getTenantId(), menuItemVo.getAppId());
                if (appVo != null) {
                    menuItemVo.setAppPath(appVo.getPcUrl());
                    menuItemVo.setOpenMode(appVo.getOpenMode());
                    String appIconSrc = appVo.getAppIconSrc();
                    if (StringUtils.isNotBlank((CharSequence)appIconSrc)) {
                        if (appIconSrc.indexOf("http") == -1) {
                            appIconSrc = this.environmentTools.getBaseHost() + appIconSrc;
                            appVo.setAppIconSrc(appIconSrc);
                        }
                        menuItemVo.setIcon(appVo.getAppIconSrc());
                    }
                    if (appVo.getAppIconSrc() == null) {
                        menuItemVo.setIcon("/portal/themes/default/images/default-appicon.png");
                    }
                }
                JSONObject en = JSONObject.parseObject((String)JSONObject.toJSONString((Object)menuItemVo));
                en.put("showNameHtml", (Object)menuItemVo.getName().replace(searchText, "<span style='color:#F41A22;'>" + searchText + "</span>"));
                String[] pids = menuItemVo.getInnerCode().split("\\|");
                StringBuilder pathAllName = new StringBuilder();
                for (int i = 0; i < pids.length; ++i) {
                    MenuEntity parent = (MenuEntity)((Object)((MenuMapper)this.baseMapper).selectById((Serializable)((Object)pids[i])));
                    if (parent != null) {
                        pathAllName.append(parent.getName());
                    }
                    if (i >= pids.length - 1) continue;
                    pathAllName.append(">");
                }
                en.put("pathAllName", (Object)pathAllName);
                if (count >= 7) continue;
                res.add(en);
                ++count;
            }
        }
        return res;
    }
}

