package com.ejianc.foundation.tenant.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.tenant.bean.EnterpriseEntity;
import com.ejianc.foundation.tenant.vo.EnterpriseAndTenantVO;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface IEnterpriseService extends IBaseService<EnterpriseEntity> {
	
	/**
	 * 根据主键查询Bean
	 * 
	 * @param enterpriseId
	 * @return
	 */
	EnterpriseVO selectById(Long enterpriseId);

	/**
	 * 根据租户Id查询企业
	 * @param tenantId
	 */
	EnterpriseVO queryEnterpriseByTenantId(Long tenantId);

	/**
	 * 企业信息审批通过
	 * @param tenantId
	 */
	void approvalPassed(EnterpriseEntity entity);

	/**
	 * 根据创建人获取企业信息
	 * 
	 * @param userId
	 * @return
	 */
	List<EnterpriseEntity> queryEnterpriseByUserId(Long userId);

	/**
	 * 根据租户Id查询企业+租户信息（管理员姓名/公司名称/管理员手机号/注册时间）
	 * @param tenantId
	 */
	EnterpriseAndTenantVO queryEnterpriseAndTenantByTenantId(Long tenantId);

    
	/**
	 * 供方协同（生成企业信息、租户、超级管理员等信息）
	 *
	 * @param 
	 * @return
	 */
	CommonResponse<EnterpriseVO> supplierCollaboration(EnterpriseVO enterpriseVO);

    /**
     * 生成租户信息
     * 根据纳税人识别码获取企业档案：
		1、没有企业档案：
			存在人员信息：返回错误
			没有人员信息：生成企业、租户、人员、自定义档案
		2、有企业档案：
			1）、没有生成租户；手机号存在，返回错误；手机号不存在，生成租户、超级超级管理员信息；
			2）、有租户：直接返回租户信息+超级管理员信息
     */
	CommonResponse<TenantVO> createGfmhTenant(EnterpriseVO vo);

    /**
     * 生成租户信息
     * 根据纳税人识别码获取企业档案：
		1、没有企业档案：
			存在人员信息：返回错误
			没有人员信息：生成企业、租户、人员、自定义档案
		2、有企业档案：
			1）、没有生成租户；手机号存在，返回错误；手机号不存在，生成租户、超级超级管理员信息；
			2）、有租户：直接返回租户信息+超级管理员信息
     */
	CommonResponse<String> generateSupplierTenant(JSONObject vo);

	CommonResponse<String> updateSupplierUserPhoneAndName(JSONObject vo);

	/**
	 * 初始化租户、用户、组织等信息-----钉钉或企业微信 云市场 初始化信息调用
	 * @param vo
	 */
    void initData(EnterpriseVO vo);

    /**
     * 获取所有企业信息
     * 
     * @return
     */
	List<EnterpriseVO> getAllEnterpriseList();

	Long getAllUserNum();
	Long getUserThisYearNum();
	/**
	 * 获取最近即将到期的租户及其到期套餐和时间
	 * @param endDate
	 * @return
	 */
	List<JSONObject> getEnterpriseComEndTimeLast3Month(String endDate);

	/**
	 * 根据租户查询该租户：
	 * 服务开始时间
	 * 服务结束时间
	 * 套餐内应用数量
	 *
	 * @param tenantId
	 * @return {
	 * id:租户id，
	 * name：租户name，
	 * startTime：服务开始时间，
	 * endTime：服务结束时间，
	 * appNum:套餐内应用数量
	 * }
	 */
	JSONObject getEnterpriseComboInfo(Long tenantId);

	/**
	 * 大企业手动新增租户
	 *
	 * @return
	 */
	CommonResponse<EnterpriseVO>  saveAndSubmit(EnterpriseVO vo);

	void fixUserRelation();
}
