/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.usercenter.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.mapper.EmployeeMapper;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.password.verify.CharDigitPassVerifier;
import com.ejianc.foundation.password.verify.CharDigitSignPassVerifier;
import com.ejianc.foundation.password.verify.UpAndLowerCharDigitSignPassVerifier;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.tenant.bean.DefaultPwdEntity;
import com.ejianc.foundation.tenant.service.IDefaultpwdService;
import com.ejianc.foundation.tenant.service.IPasswordPolicyService;
import com.ejianc.foundation.tenant.vo.PasswordPolicyVO;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserManagerRelationAppEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.mapper.UserMapper;
import com.ejianc.foundation.usercenter.pm.encoder.UsernameSaltPasswordEncoder;
import com.ejianc.foundation.usercenter.service.IPwdHistoryService;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserManagerRelationAppService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordGeneratorUtils;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.PwdHistoryVO;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
extends BaseServiceImpl<UserMapper, UserEntity>
implements IUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IPasswordPolicyService passwordPolicyService;
    @Autowired
    private IDefaultpwdService iDefaultpwdService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPwdHistoryService pwdHistoryService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private EmployeeMapper employeeMapper;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IUserTenantRelationService userTenantRelationService;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IAppService appService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IUserManagerRelationAppService userManagerRelationAppService;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private PermissionCacheManage permissionCacheManage;

    @Override
    public UserVO selectById(Long userId) {
        UserEntity entity = (UserEntity)((Object)this.getById(userId));
        UserTenantRelationEntity relation = this.userTenantRelationService.getOne(userId, null);
        if (relation != null) {
            entity.setTenantId(relation.getTenantId());
            entity.setOrgId(relation.getOrgId());
            entity.setTypeId(relation.getTypeId());
        }
        UserVO userVo = (UserVO)BeanMapper.map((Object)((Object)entity), UserVO.class);
        if (relation != null) {
            userVo.setDeptId(relation.getDeptId());
            userVo.setPostId(relation.getPostId());
        }
        return userVo;
    }

    @Override
    public void updateUserPassword(Long userId, String password) {
        this.userMapper.updateUserPassword(userId, password);
    }

    @Override
    public UserVO queryLoginUserByUserCodeOrPhoneNumOrEMail(String condition) {
        UserVO userVo = null;
        QueryWrapper userCodeWrapper = new QueryWrapper();
        ((QueryWrapper)userCodeWrapper.eq((Object)"user_code", (Object)condition)).eq((Object)"dr", (Object)0);
        UserEntity userEntity = (UserEntity)((Object)this.getOne((Wrapper)userCodeWrapper));
        if (userEntity != null) {
            userVo = (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
            return userVo;
        }
        QueryWrapper userPhoneWrapper = new QueryWrapper();
        ((QueryWrapper)userPhoneWrapper.eq((Object)"user_mobile", (Object)condition)).eq((Object)"dr", (Object)0);
        userEntity = (UserEntity)((Object)this.getOne((Wrapper)userPhoneWrapper));
        if (userEntity != null) {
            userVo = (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
            return userVo;
        }
        QueryWrapper emailWrapper = new QueryWrapper();
        ((QueryWrapper)emailWrapper.eq((Object)"user_email", (Object)condition)).eq((Object)"dr", (Object)0);
        userEntity = (UserEntity)((Object)this.getOne((Wrapper)emailWrapper));
        if (userEntity != null) {
            userVo = (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
            return userVo;
        }
        return null;
    }

    @Override
    @Transactional
    public UserVO generateNewUser(EmployeeVO employeeVO) {
        UserEntity uniqueBean;
        if (StringUtils.isNotBlank((CharSequence)employeeVO.getUserCode())) {
            QueryWrapper userCodeWrapper = new QueryWrapper();
            ((QueryWrapper)userCodeWrapper.eq((Object)"user_code", (Object)employeeVO.getUserCode())).eq((Object)"dr", (Object)0);
            uniqueBean = (UserEntity)((Object)this.userMapper.selectOne((Wrapper)userCodeWrapper));
            if (uniqueBean != null) {
                throw new BusinessException("\u65b0\u589e\u4eba\u5458\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            }
        }
        QueryWrapper userPhoneWrapper = new QueryWrapper();
        ((QueryWrapper)userPhoneWrapper.eq((Object)"user_mobile", (Object)employeeVO.getMobilePhone())).eq((Object)"dr", (Object)0);
        uniqueBean = (UserEntity)((Object)this.userMapper.selectOne((Wrapper)userPhoneWrapper));
        if (uniqueBean != null) {
            if (uniqueBean.getTenantId() != null && uniqueBean.getTenantId() > 0L) {
                return null;
            }
            uniqueBean.setTenantId(employeeVO.getTenantId());
            uniqueBean.setOrgId(employeeVO.getOrgId());
            if (employeeVO.getTypeId() != null) {
                uniqueBean.setTypeId(employeeVO.getTypeId());
            } else {
                uniqueBean.setTypeId(2);
            }
            super.saveOrUpdate((Object)uniqueBean);
            return (UserVO)BeanMapper.map((Object)((Object)uniqueBean), UserVO.class);
        }
        UserVO userVO = new UserVO();
        userVO.setAvator(employeeVO.getPhotoPath());
        userVO.setSex(employeeVO.getSex().toString());
        userVO.setTenantId(InvocationInfoProxy.getTenantid());
        userVO.setUserName(employeeVO.getName());
        userVO.setUserCode(StringUtils.isNotBlank((CharSequence)employeeVO.getUserCode()) ? employeeVO.getUserCode() : "U" + IdWorker.getId());
        userVO.setUserMobile(employeeVO.getMobilePhone());
        userVO.setTenantId(employeeVO.getTenantId());
        userVO.setUserState(UserVO.USER_STATE_ACTIVE);
        userVO.setDr(BaseVO.DR_UNDELETE);
        if (employeeVO.getTypeId() != null) {
            userVO.setTypeId(employeeVO.getTypeId());
        } else {
            userVO.setTypeId(Integer.valueOf(2));
        }
        userVO.setOrgId(employeeVO.getOrgId());
        PasswordUtils.setSalt(userVO);
        this.userCheck(userVO);
        String password = this.passwordPolicyService.getUserDefaultPassword(InvocationInfoProxy.getTenantid());
        String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
        userVO.setPassword(shaPassword);
        userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
        userVO.setPwdStartTime(new Date());
        userVO.setTenantId(InvocationInfoProxy.getTenantid());
        UserEntity saveEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
        super.saveOrUpdate((Object)saveEntity);
        return (UserVO)BeanMapper.map((Object)((Object)saveEntity), UserVO.class);
    }

    @Override
    public void resetpwd(Long userId) {
        UserVO user = this.selectById(userId);
        if (null == user) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        String password = this.passwordPolicyService.getUserDefaultPassword(user.getTenantId());
        String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
        user.setPassword(shaPassword);
        user.setPassword(PasswordUtils.encodebyUserCode(user));
        user.setPwdStartTime(new Date());
        UserEntity saveEntity = (UserEntity)((Object)BeanMapper.map((Object)user, UserEntity.class));
        super.saveOrUpdate((Object)saveEntity);
    }

    @Override
    public String resetGeneratePwd(Long userId) {
        UserVO user = this.selectById(userId);
        if (null == user) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        String password = null;
        PasswordPolicyVO passwordPolicyVo = this.passwordPolicyService.findByTenantId(user.getTenantId());
        switch (passwordPolicyVo.getPwdComplexity()) {
            case 1: {
                password = PasswordGeneratorUtils.generate1(passwordPolicyVo.getMinLength());
                break;
            }
            case 2: {
                password = PasswordGeneratorUtils.generate2(passwordPolicyVo.getMinLength());
                break;
            }
            case 3: {
                password = PasswordGeneratorUtils.generate3(passwordPolicyVo.getMinLength());
                break;
            }
        }
        if (StringUtils.isBlank(password)) {
            throw new BusinessException("\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25\uff01");
        }
        String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
        user.setPassword(shaPassword);
        user.setPassword(PasswordUtils.encodebyUserCode(user));
        user.setPwdStartTime(new Date());
        UserEntity saveEntity = (UserEntity)((Object)BeanMapper.map((Object)user, UserEntity.class));
        super.saveOrUpdate((Object)saveEntity);
        return password;
    }

    private void userCheck(UserVO vo) {
        Pattern patternEmail;
        Matcher matcherEmail;
        Pattern patternMobile;
        Matcher matcherMobile;
        if (StringUtils.isNotBlank((CharSequence)vo.getUserMobile()) && !(matcherMobile = (patternMobile = Pattern.compile("^[1][3456789][0-9]{9}$", 2)).matcher(vo.getUserMobile())).matches()) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7528\u6237\u624b\u673a\u975e\u6cd5");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getUserEmail()) && !(matcherEmail = (patternEmail = Pattern.compile("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$", 2)).matcher(vo.getUserEmail())).matches()) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7528\u6237\u90ae\u7bb1\u975e\u6cd5");
        }
    }

    @Override
    public IPage<UserRefVO> pageList(Map<String, Object> params) {
        List<Object> voList = new ArrayList();
        Page page = new Page();
        if (params.get("pageNumber") != null) {
            Integer pn = Integer.parseInt(params.get("pageNumber").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        long total = this.userMapper.countRef(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        voList = this.userMapper.queryListRef(params);
        try {
            if (params.get("allProperty") != null && voList != null && voList.size() > 0) {
                ArrayList employeeIds = new ArrayList();
                voList.forEach(vo -> {
                    if ("\u96b6\u5c5e".equals(vo.getJobType())) {
                        employeeIds.add(vo.getEmployeeId());
                    }
                });
                if (employeeIds.size() > 0) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("jobType", 1);
                    param.put("employeeIds", employeeIds);
                    param.put("tenantId", InvocationInfoProxy.getTenantid());
                    List<EmployeeVO> mainList = this.employeeMapper.getList(param);
                    HashMap eMap = new HashMap();
                    mainList.forEach(vo -> eMap.put(vo.getId(), vo));
                    voList.forEach(vo -> {
                        EmployeeVO mainVO;
                        if ("\u96b6\u5c5e".equals(vo.getJobType()) && (mainVO = (EmployeeVO)eMap.get(vo.getEmployeeId())) != null) {
                            if (params.get("innerCode") != null) {
                                if (mainVO.getOrgInnerCode().contains(params.get("innerCode").toString())) {
                                    vo.setOrgId(mainVO.getOrgId());
                                    vo.setOrgName(mainVO.getShortName());
                                    vo.setJobType("\u76f4\u5c5e");
                                    vo.setPostId(mainVO.getPostId());
                                    vo.setPostName(mainVO.getPostName());
                                    vo.setDeptId(mainVO.getDeptId());
                                    vo.setDeptName(mainVO.getDeptName());
                                }
                            } else if (params.get("deptId") == null && params.get("innerCode") == null && params.get("deptId") == null) {
                                vo.setOrgId(mainVO.getOrgId());
                                vo.setOrgName(mainVO.getShortName());
                                vo.setJobType("\u76f4\u5c5e");
                                vo.setPostId(mainVO.getPostId());
                                vo.setPostName(mainVO.getPostName());
                                vo.setDeptId(mainVO.getDeptId());
                                vo.setDeptName(mainVO.getDeptName());
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.logger.info("--------------\u4eba\u5458\u53c2\u7167\u67e5\u8be2\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
        if ((this.environmentTools.getBaseHost().contains("pm.qdcm-group.com") || this.environmentTools.getBaseHost().contains("test01.qdparking.net")) && voList != null && voList.size() > 0) {
            voList.forEach(vo -> {
                String str;
                if (StringUtils.isNotBlank((CharSequence)vo.getUserMobile()) && vo.getUserMobile().length() > 7) {
                    str = vo.getUserMobile().substring(0, 3) + "****" + vo.getUserMobile().substring(7);
                    vo.setUserMobile(str);
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getMobilePhone()) && vo.getMobilePhone().length() > 7) {
                    str = vo.getMobilePhone().substring(0, 3) + "****" + vo.getMobilePhone().substring(7);
                    vo.setMobilePhone(str);
                }
            });
        }
        page.setRecords(voList);
        return page;
    }

    @Override
    public void updateUserState(Long userId, Integer state) {
        this.userMapper.updateUserState(userId, state);
    }

    @Override
    public List<UserVO> selectAllByIds(List<Long> userIds, Long tenantId) {
        return this.userMapper.selectAllByIds(userIds, tenantId);
    }

    @Override
    public IPage<UserRefVO> queryPage(Map<String, Object> queryParam, Integer pageIndex, Integer pageSize) {
        queryParam.put("pageIndex", pageIndex);
        queryParam.put("pageSize", pageSize);
        queryParam.put("tenantId", InvocationInfoProxy.getTenantid());
        Long userCount = this.userMapper.queryCount(queryParam);
        List<Object> userList = new ArrayList();
        if (userCount > 0L) {
            userList = this.userMapper.queryList(queryParam);
        }
        Page page = new Page();
        page.setRecords(userList);
        page.setSize(userCount.longValue());
        return page;
    }

    @Override
    public List<Map<String, Object>> getEmployeeList(Long orgId) {
        OrgVO orgVO = this.orgService.queryDetail(orgId);
        ArrayList<Map<String, Object>> dataMapList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("tenantId", orgVO.getTenantId());
        queryParam.put("innerCode", orgVO.getInnerCode());
        HashMap employeeMap = new HashMap();
        HashMap cacheMap = new HashMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", orgVO.getTenantId());
        params.put("innerCode", orgVO.getInnerCode());
        ArrayList<Long> empIds = new ArrayList<Long>();
        empIds.add(0L);
        List<EmployeeVO> employeeVOS = this.employeeMapper.getList(params);
        employeeVOS.stream().forEach(employeeVO -> {
            empIds.add(employeeVO.getId());
            employeeMap.put(employeeVO.getId() + "-" + employeeVO.getJobId(), employeeVO);
        });
        queryParam.put("employeeIds", empIds);
        queryParam.put("tenantId", orgVO.getTenantId());
        List<RoleUserRelationVO> roleUserList = this.roleUserRelationService.queryListByProperties(queryParam);
        roleUserList.stream().forEach(roleUser -> {
            EmployeeVO emp = (EmployeeVO)employeeMap.get(roleUser.getEmployeeId() + "-" + roleUser.getJobId());
            if (null != emp) {
                HashMap<String, String> dataMap = (HashMap<String, String>)cacheMap.get(roleUser.getEmployeeId() + "-" + roleUser.getJobId());
                if (null == dataMap) {
                    dataMap = new HashMap<String, String>();
                    dataMap.put("employeeId", (String)((Object)emp.getId()));
                    dataMap.put("roleId", (String)((Object)roleUser.getRoleId()));
                    dataMap.put("roleName", roleUser.getRoleName());
                    dataMap.put("userId", (String)((Object)emp.getUserId()));
                    dataMap.put("userName", emp.getName());
                    dataMap.put("jobId", (String)((Object)emp.getJobId()));
                    dataMap.put("postId", (String)((Object)emp.getPostId()));
                    dataMap.put("postName", emp.getPostName());
                    dataMap.put("isAdd", (String)((Object)Boolean.valueOf(false)));
                    dataMap.put("state", (String)((Object)emp.getState()));
                    dataMap.put("projectPost", emp.getProjectPost());
                    dataMap.put("jobType", emp.getJobType() == 1 ? "\u76f4\u5c5e" : "\u96b6\u5c5e");
                    dataMap.put("id", UUID.randomUUID().toString().replaceAll("-", ""));
                    dataMapList.add(dataMap);
                    cacheMap.put(roleUser.getEmployeeId() + "-" + roleUser.getJobId(), dataMap);
                } else {
                    dataMap.put("roleId", dataMap.get("roleId") + "," + roleUser.getRoleId());
                    dataMap.put("roleName", dataMap.get("roleName") + "," + roleUser.getRoleName());
                }
                UserEntity user = (UserEntity)((Object)((Object)super.getById((Serializable)emp.getUserId())));
                dataMap.put("avator", user.getAvator());
                dataMap.put("userMobile", user.getUserMobile());
                employeeVOS.remove(emp);
            }
        });
        if (CollectionUtils.isNotEmpty(employeeVOS)) {
            employeeVOS.stream().forEach(emp -> {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                UserEntity user = (UserEntity)((Object)((Object)super.getById((Serializable)emp.getUserId())));
                dataMap.put("avator", user.getAvator());
                dataMap.put("userMobile", user.getUserMobile());
                dataMap.put("employeeId", emp.getId());
                dataMap.put("userId", emp.getUserId());
                dataMap.put("userName", emp.getName());
                dataMap.put("jobId", emp.getJobId());
                dataMap.put("postId", emp.getPostId());
                dataMap.put("postName", emp.getPostName());
                dataMap.put("isAdd", false);
                dataMap.put("state", emp.getState());
                dataMap.put("jobType", emp.getJobType() == 1 ? "\u76f4\u5c5e" : "\u96b6\u5c5e");
                dataMap.put("id", UUID.randomUUID().toString().replaceAll("-", ""));
                dataMapList.add(dataMap);
            });
        }
        return dataMapList;
    }

    @Override
    public List<UserVO> queryUserByPostAndOrg(List<Long> postIds, List<Long> orgIds) {
        return ((UserMapper)this.baseMapper).queryUserByPostAndOrg(postIds, orgIds);
    }

    @Override
    public UserVO getUserByWxOpenId(String openId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"weixin_minprogram_id", (Object)openId);
        UserEntity userEntity = (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (userEntity != null) {
            return (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        }
        return null;
    }

    @Override
    public UserVO getUserByWeixineeId(String weixineeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"weixinee_id", (Object)weixineeId);
        UserEntity userEntity = (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (userEntity != null) {
            return (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        }
        return null;
    }

    @Override
    public List<UserEntity> getWXEEThirdUserByTenantId() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return ((UserMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void updateOpenId(Long userId, String openId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"weixin_minprogram_id", (Object)openId);
        List users = ((UserMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        UserEntity curUser = null;
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            for (UserEntity user : users) {
                if (!user.getId().equals(userId)) {
                    user.setWeixinMinprogramId(null);
                    continue;
                }
                curUser = user;
            }
        }
        if (null == curUser) {
            curUser = (UserEntity)((Object)((UserMapper)this.baseMapper).selectById(userId));
            curUser.setWeixinMinprogramId(openId);
            users.add(curUser);
        }
        super.saveOrUpdateBatch((Collection)users);
    }

    @Override
    @Transactional
    public void unbindingWechat(Long userid) {
        this.userMapper.unbindingWechat(userid);
    }

    @Override
    public void updateUserLastLoginTime(Long userid) {
        this.userMapper.updateUserLastLoginTime(userid);
    }

    @Override
    public CommonResponse<UserVO> save(UserVO userVo) {
        ArrayList<Long> attachIds;
        String id;
        this.userCheck(userVo);
        UserEntity userEntity = (UserEntity)((Object)this.getById(userVo.getId()));
        if (!userVo.getUserMobile().equals(userEntity.getUserMobile())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"user_mobile", (Object)userVo.getUserMobile());
            queryWrapper.ne((Object)"id", (Object)userVo.getId());
            List list = this.list((Wrapper)queryWrapper);
            if (list != null && list.size() > 0) {
                throw new BusinessException("\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528");
            }
        }
        userEntity.setUserEmail(userVo.getUserEmail());
        userEntity.setUserMobile(userVo.getUserMobile());
        userEntity.setUserName(userVo.getUserName());
        if (StringUtils.isNotBlank((CharSequence)userVo.getSex())) {
            userEntity.setSex(StringUtils.isNotBlank((CharSequence)userVo.getSex()) ? Integer.valueOf(userVo.getSex()) : null);
        }
        if (StringUtils.isNotBlank((CharSequence)userEntity.getAvator())) {
            if (StringUtils.isNotBlank((CharSequence)userVo.getAvator())) {
                if (!userEntity.getAvator().equals(userVo.getAvator())) {
                    if (StringUtils.isNotBlank((CharSequence)userEntity.getAvator()) && StringUtils.isNotBlank((CharSequence)(id = userEntity.getAvator().split("=")[1]))) {
                        this.attachmentApi.delete(id);
                    }
                    if (StringUtils.isNotBlank((CharSequence)userVo.getAvator()) && StringUtils.isNotBlank((CharSequence)(id = userVo.getAvator().split("=")[1]))) {
                        attachIds = new ArrayList();
                        attachIds.add(Long.parseLong(id));
                        this.attachmentApi.updateAttachRef(userEntity.getId(), attachIds);
                    }
                }
            } else if (StringUtils.isNotBlank((CharSequence)userEntity.getAvator()) && StringUtils.isNotBlank((CharSequence)(id = userEntity.getAvator().split("=")[1]))) {
                this.attachmentApi.delete(id);
            }
        } else if (StringUtils.isNotBlank((CharSequence)userVo.getAvator()) && StringUtils.isNotBlank((CharSequence)(id = userVo.getAvator().split("=")[1]))) {
            attachIds = new ArrayList<Long>();
            attachIds.add(Long.parseLong(id));
            this.attachmentApi.updateAttachRef(userEntity.getId(), attachIds);
        }
        userEntity.setAvator(userVo.getAvator());
        this.saveOrUpdate((Object)userEntity, false);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"user_id", (Object)userVo.getId());
        EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.employeeService.getOne((Wrapper)wrapper));
        if (employeeEntity != null) {
            employeeEntity.setPhotoPath(userVo.getAvator());
            employeeEntity.setName(userVo.getUserName());
            employeeEntity.setMobilePhone(userVo.getUserMobile());
            employeeEntity.setSex(userEntity.getSex());
            employeeEntity.setUserSignaturePath(userVo.getUserSignaturePath());
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(employeeEntity.getId(), null, "userSignature", null);
            if (attachListResp.isSuccess()) {
                List attachList = (List)attachListResp.getData();
                CommonResponse updateResp = null;
                if (attachList.isEmpty() && null != userVo.getUserSignatureFileId()) {
                    updateResp = this.attachmentApi.updateAttachRef(employeeEntity.getId(), Arrays.asList(userVo.getUserSignatureFileId()));
                } else {
                    StringBuilder delIds = new StringBuilder();
                    for (AttachmentVO file : attachList) {
                        if (file.getId().equals(userVo.getUserSignatureFileId())) continue;
                        delIds.append(file.getId()).append(",");
                    }
                    if (delIds.length() > 1) {
                        updateResp = this.attachmentApi.delete(delIds.substring(0, delIds.length() - 1));
                    }
                }
                if (null != updateResp && !updateResp.isSuccess()) {
                    this.logger.error("\u4fdd\u5b58/\u66f4\u65b0\u4eba\u5458\u7b7e\u540d\u4fe1\u606f\u5931\u8d25\uff0c\u66f4\u65b0\u5bf9\u5e94\u4eba\u5458\u7b7e\u540d\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
                }
            } else {
                this.logger.error("\u4fdd\u5b58/\u66f4\u65b0\u4eba\u5458\u7b7e\u540d\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u5bf9\u5e94\u4eba\u5458\u7b7e\u540d\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            this.employeeService.saveOrUpdate((Object)employeeEntity, false);
        }
        userVo = (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)userVo);
    }

    @Override
    public CommonResponse<String> modifyPwd(Map<String, Object> param) {
        if (param.get("oldPwd") == null) {
            throw new BusinessException("\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.get("newPwd") == null) {
            throw new BusinessException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String oldPwd = param.get("oldPwd").toString();
        String newPwd = param.get("newPwd").toString();
        Long userId = Long.parseLong(param.get("userId").toString());
        UserEntity userEntity = (UserEntity)((Object)this.getById(userId));
        UsernameSaltPasswordEncoder encoder = new UsernameSaltPasswordEncoder(userEntity.getUserCode(), userEntity.getSalt());
        String encryptedPassword = encoder.encode(oldPwd);
        if (!userEntity.getPassword().equals(encryptedPassword)) {
            throw new BusinessException("\u539f\u5bc6\u7801\u9519\u8bef");
        }
        JSONObject errorObject = new JSONObject();
        PasswordPolicyVO passwordPolicyVo = this.passwordPolicyService.findByTenantId(userEntity.getTenantId());
        switch (passwordPolicyVo.getPwdComplexity()) {
            case 1: {
                if (CharDigitPassVerifier.verify(newPwd)) break;
                errorObject.put("validatePasswordError", (Object)"\u5bc6\u7801\u9700\u8981\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u5408");
                break;
            }
            case 2: {
                if (CharDigitSignPassVerifier.verify(newPwd)) break;
                errorObject.put("validatePasswordError", (Object)"\u5bc6\u7801\u9700\u8981\u6570\u5b57\u3001\u5b57\u6bcd\u548c!@#$%^&*?\u7ec4\u5408");
                break;
            }
            case 3: {
                if (UpAndLowerCharDigitSignPassVerifier.verify(newPwd)) break;
                errorObject.put("validatePasswordError", (Object)"\u5bc6\u7801\u9700\u8981\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c!@#$%^&*?\u7ec4\u5408");
                break;
            }
            default: {
                errorObject.put("validatePasswordError", (Object)"\u5bc6\u7801\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
        if (errorObject.isEmpty()) {
            String newEncryptedPassword = encoder.encode(newPwd);
            this.updateUserPassword(userEntity.getId(), newEncryptedPassword);
            PwdHistoryVO pwdHistoryVO = new PwdHistoryVO();
            pwdHistoryVO.setUserId(userEntity.getId());
            pwdHistoryVO.setUsedPassword(encryptedPassword);
            pwdHistoryVO.setUsedPwdTime(new Date());
            this.pwdHistoryService.insert(pwdHistoryVO);
            return CommonResponse.success((String)"\u4fee\u6539\u5bc6\u7801\u6210\u529f");
        }
        return CommonResponse.error((String)errorObject.getString("validatePasswordError"));
    }

    @Override
    public UserVO querySuperAdminByTenantId(Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        ((QueryWrapper)queryWrapper.eq((Object)"type_id", (Object)1)).eq((Object)"dr", (Object)0);
        List entities = this.userTenantRelationService.list((Wrapper)queryWrapper);
        if (entities != null && entities.size() > 0) {
            UserVO useEntity = this.selectById(((UserTenantRelationEntity)((Object)entities.get(0))).getUserId());
            useEntity.setTenantId(((UserTenantRelationEntity)((Object)entities.get(0))).getTenantId());
            useEntity.setOrgId(((UserTenantRelationEntity)((Object)entities.get(0))).getOrgId());
            return (UserVO)BeanMapper.map((Object)useEntity, UserVO.class);
        }
        return null;
    }

    @Override
    public void updateWxEEId(Long userId, String wxeeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"weixinee_id", (Object)wxeeId)).eq((Object)"dr", (Object)0);
        List users = ((UserMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        UserEntity curUser = null;
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            for (UserEntity user : users) {
                if (!user.getId().equals(userId)) {
                    user.setWeixineeId(null);
                    continue;
                }
                curUser = user;
            }
        }
        if (null == curUser) {
            curUser = (UserEntity)((Object)((UserMapper)this.baseMapper).selectById(userId));
            curUser.setWeixineeId(wxeeId);
            users.add(curUser);
        }
        super.saveOrUpdateBatch((Collection)users);
    }

    @Override
    public void updateWeixinId(Long userId, String weixinId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"weixin_id", (Object)weixinId)).eq((Object)"dr", (Object)0);
        List users = ((UserMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        UserEntity curUser = null;
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            for (UserEntity user : users) {
                if (!user.getId().equals(userId)) {
                    user.setWeixineeId(null);
                    continue;
                }
                curUser = user;
            }
        }
        if (null == curUser) {
            curUser = (UserEntity)((Object)((UserMapper)this.baseMapper).selectById(userId));
            curUser.setWeixinId(weixinId);
            users.add(curUser);
        }
        super.saveOrUpdateBatch((Collection)users);
    }

    @Override
    public void updateDdId(Long userId, String ddId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"dingding_id", (Object)ddId)).eq((Object)"dr", (Object)0);
        List users = ((UserMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        UserEntity curUser = null;
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            for (UserEntity user : users) {
                if (!user.getId().equals(userId)) {
                    user.setDingdingId(null);
                    continue;
                }
                curUser = user;
            }
        }
        if (null == curUser) {
            curUser = (UserEntity)((Object)((UserMapper)this.baseMapper).selectById(userId));
            curUser.setDingdingId(ddId);
            users.add(curUser);
        }
        super.saveOrUpdateBatch((Collection)users);
    }

    @Override
    public UserVO getUserByWxIdOrMinProgramIdOrWxEEIdOrDdId(String openid, String reqFrom) {
        UserEntity userEntity;
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"dr", (Object)0)).and(wrap -> (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrap.eq((Object)"weixin_minprogram_id", (Object)openid)).or()).eq((Object)"weixin_id", (Object)openid)).or()).eq((Object)"weixinee_id", (Object)openid)).or()).eq((Object)"dingding_id", (Object)openid));
        if ("wxminApp".equals(reqFrom)) {
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"weixin_minprogram_id", (Object)openid)).eq((Object)"dr", (Object)0);
        }
        if ((userEntity = (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)queryWrapper))) != null) {
            return (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        }
        return null;
    }

    @Override
    public UserVO queryUserByIdOrSourceId(String userId) {
        UserEntity userEntity = (UserEntity)((Object)this.userMapper.selectById((Serializable)((Object)userId)));
        if (userEntity != null) {
            return (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)userId);
        userEntity = (UserEntity)((Object)this.userMapper.selectOne((Wrapper)queryWrapper));
        if (userEntity != null) {
            return (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        }
        return null;
    }

    @Override
    public UserVO queryUserBySourceId(String userId, Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"source_id", (Object)userId)).eq((Object)"tenant_id", (Object)tenantId)).eq((Object)"dr", (Object)0);
        UserEntity userEntity = (UserEntity)((Object)this.userMapper.selectOne((Wrapper)queryWrapper));
        if (userEntity != null) {
            return (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        }
        return null;
    }

    @Override
    public UserVO querySupplierUserInfoByWXCode(String code) {
        QueryWrapper thirdSystemWrapper = new QueryWrapper();
        thirdSystemWrapper.eq((Object)"tenant_id", (Object)"999999");
        ((QueryWrapper)thirdSystemWrapper.eq((Object)"code", (Object)"Weixin")).eq((Object)"dr", (Object)0);
        ThirdSystemEntity thirdSystemEntity = (ThirdSystemEntity)((Object)this.thirdSystemService.getOne((Wrapper)thirdSystemWrapper));
        UserVO userVo = null;
        if (thirdSystemEntity != null) {
            String configInfo = thirdSystemEntity.getConfigInfo();
            JSONObject configJson = JSON.parseObject((String)configInfo);
            String appid = configJson.getString("appid");
            String secret = configJson.getString("secret");
            String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + appid + "&secret=" + secret + "&code=" + code + "&grant_type=authorization_code";
            String userInfoResult = null;
            try {
                HashMap param = new HashMap();
                userInfoResult = ReferHttpClientUtils.get((String)url, param, new HashMap());
            }
            catch (IOException | GeneralSecurityException e) {
                e.printStackTrace();
            }
            this.logger.info("userInfoResult === " + userInfoResult);
            if (StringUtils.isNotBlank((CharSequence)userInfoResult)) {
                JSONObject userInfoJson = JSON.parseObject((String)userInfoResult);
                String weixinOpenid = userInfoJson.getString("openid");
                userVo = this.getUserByWxIdOrMinProgramIdOrWxEEIdOrDdId(weixinOpenid, null);
            }
        }
        return userVo;
    }

    @Override
    public UserVO queryUserByUserCode(String userCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"user_code", (Object)userCode)).eq((Object)"dr", (Object)0);
        UserEntity userEntity = (UserEntity)((Object)this.userMapper.selectOne((Wrapper)queryWrapper));
        if (userEntity != null) {
            UserVO userVO = (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
            UserTenantRelationEntity relation = this.userTenantRelationService.getOne(userEntity.getId(), null);
            if (relation != null) {
                userVO.setTenantId(relation.getTenantId());
                userVO.setOrgId(relation.getOrgId());
                userVO.setDeptId(relation.getDeptId());
                userVO.setPostId(relation.getPostId());
            }
            return userVO;
        }
        return null;
    }

    @Override
    public List<UserVO> queryUserByUserCodes(String[] userCodes) {
        List<Object> resp = new ArrayList<UserVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.in((Object)"user_code", (Object[])userCodes)).eq((Object)"dr", (Object)0);
        List users = this.userMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            resp = BeanMapper.mapList((Iterable)users, UserVO.class);
        }
        return resp;
    }

    @Override
    public void refreshReferUserCache() {
        List<UserEntity> userEntities = this.userMapper.queryAllUsers();
        if (userEntities != null && userEntities.size() > 0) {
            for (UserEntity entity : userEntities) {
                String cacheKey = "refer_cache_key:idm-employee:" + entity.getUserCode();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)entity.getId());
                jsonObject.put("userCode", (Object)entity.getUserCode());
                jsonObject.put("userName", (Object)entity.getUserName());
                jsonObject.put("userMobile", (Object)entity.getUserMobile());
                this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonObject.toString());
            }
        }
    }

    @Override
    public void updateTenantIdAndUserType(Integer userType, Long userId, long tenantId, Long orgId, Long deptId, Long postId) {
        this.userMapper.updateTenantIdAndUserType(userType, userId, tenantId, orgId);
        this.employeeMapper.updateTenantId(userId, tenantId, orgId, deptId, postId);
    }

    @Override
    public UserVO findByUserMobile(String phone) {
        UserVO resp = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"user_mobile", (Object)phone)).eq((Object)"dr", (Object)0);
        queryWrapper.last("limit 1");
        UserEntity userEntity = (UserEntity)((Object)super.getOne((Wrapper)queryWrapper));
        if (null != userEntity) {
            resp = (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        }
        return resp;
    }

    @Override
    public void sendMsg(String phone, String templateCode, String signName) {
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phone);
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put("templateCode", (Object)"SMS_195335074");
        } else {
            messageParam.put("templateCode", (Object)templateCode);
        }
        if (StringUtils.isNotBlank((CharSequence)signName)) {
            messageParam.put("signName", (Object)signName);
        }
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        try {
            String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
            this.logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a[{}]", (Object)phone, (Object)responseStr);
            CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (response.isSuccess()) {
                return;
            }
        }
        catch (ConnectTimeoutException e) {
            e.printStackTrace();
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
    }

    @Override
    public List<String> selectSourceIds(List<String> users, Long tenantId, String type) {
        return this.userMapper.selectSourceIds(users, tenantId, type);
    }

    @Override
    @Transactional
    public void initThirdAppUsers(String thirdUserId, String name, String mobile, String openUserId, Long tenantId, String roleCode) {
        UserVO userVO = this.queryUserBySourceId(thirdUserId, tenantId);
        if (userVO == null) {
            userVO = new UserVO();
            userVO.setUserCode(openUserId);
            userVO.setId(Long.valueOf(IdWorker.getId()));
            userVO.setUserName(name);
            userVO.setSourceId(thirdUserId);
            userVO.setUserMobile(mobile);
            userVO.setTenantId(tenantId);
            DefaultPwdEntity defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(tenantId);
            PasswordUtils.setSalt(userVO);
            String password = defaultPwdEntity.getDefaultpwd();
            String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
            userVO.setPassword(shaPassword);
            userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
            userVO.setPwdStartTime(new Date());
            userVO.setEmployeeId(userVO.getId());
            userVO.setUserState(UserVO.USER_STATE_ACTIVE);
            userVO.setTypeId(Integer.valueOf(2));
            userVO.setDr(BaseVO.DR_UNDELETE);
            OrgVO orgVO = this.orgService.findOrgByTenantId(tenantId);
            userVO.setOrgId(orgVO.getId());
            UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
            userTenantRelationEntity.setMainSpaceFlag(1);
            userTenantRelationEntity.setUserId(userVO.getId());
            userTenantRelationEntity.setTenantId(tenantId);
            userTenantRelationEntity.setTypeId(2);
            userTenantRelationEntity.setEmployeeId(userVO.getId());
            userTenantRelationEntity.setOrgId(orgVO.getId());
            userTenantRelationEntity.setState(1);
            UserEntity userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
            EmployeeVO employeeVO = new EmployeeVO();
            employeeVO.setId(userVO.getId());
            employeeVO.setUserId(userVO.getId());
            employeeVO.setName(userVO.getUserName());
            employeeVO.setCode(openUserId);
            employeeVO.setEmployeeType(Integer.valueOf(1));
            employeeVO.setState(Integer.valueOf(0));
            employeeVO.setSex(Integer.valueOf(1));
            if (net.logstash.logback.encoder.org.apache.commons.lang.StringUtils.isBlank((String)userEntity.getUserMobile())) {
                employeeVO.setMobilePhone(userEntity.getSourceId());
            } else {
                employeeVO.setMobilePhone(userEntity.getUserMobile());
            }
            employeeVO.setOrgName(orgVO.getName());
            employeeVO.setOrgId(orgVO.getId());
            employeeVO.setTenantId(tenantId);
            this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            this.employeeService.save(employeeVO, userEntity);
            this.saveOrUpdate((Object)userEntity);
            this.addUserApp(userVO.getId(), tenantId, orgVO.getId(), 2, roleCode);
        } else {
            userVO.setUserCode(openUserId);
            userVO.setUserState(UserVO.USER_STATE_ACTIVE);
            this.updateThirdAppUsers(userVO, UserVO.USER_STATE_ACTIVE);
        }
    }

    @Override
    @Transactional
    public void addUserApp(Long userId, Long tenantId, Long orgId, Integer typeId, String roleCode) {
        try {
            InvocationInfoProxy.setTenantid((Long)tenantId);
            ArrayList<UserManagerRelationAppEntity> userManagerRelationAppList = new ArrayList<UserManagerRelationAppEntity>();
            if (typeId == 3) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("tenant_id", tenantId);
                params.put("classify", "oms");
                List<AppVO> list = this.appService.queryList(params);
                for (AppVO vo : list) {
                    UserManagerRelationAppEntity userManagerRelationAppEntity = new UserManagerRelationAppEntity();
                    userManagerRelationAppEntity.setTenantId(tenantId);
                    userManagerRelationAppEntity.setUserId(userId);
                    userManagerRelationAppEntity.setAppId(vo.getId());
                    userManagerRelationAppList.add(userManagerRelationAppEntity);
                }
            }
            if (userManagerRelationAppList != null && userManagerRelationAppList.size() > 0) {
                this.userManagerRelationAppService.saveOrUpdateBatch(userManagerRelationAppList, userManagerRelationAppList.size(), false);
            }
            JobEntity jobEntity = this.jobService.getCurMainJob(userId);
            QueryWrapper roleWrapper = new QueryWrapper();
            roleWrapper.eq((Object)"dr", (Object)0);
            roleWrapper.eq((Object)"tenant_id", (Object)999999L);
            roleWrapper.eq((Object)"code", (Object)roleCode);
            RoleEntity roleOms = (RoleEntity)((Object)this.roleService.getOne((Wrapper)roleWrapper));
            QueryWrapper roleSourceWrapper = new QueryWrapper();
            roleSourceWrapper.eq((Object)"dr", (Object)0);
            roleSourceWrapper.eq((Object)"tenant_id", (Object)tenantId);
            roleSourceWrapper.eq((Object)"source_id", (Object)roleOms.getId());
            RoleEntity roleSourceOms = (RoleEntity)((Object)this.roleService.getOne((Wrapper)roleSourceWrapper));
            ArrayList<RoleUserRelationEntity> roleUserRelationList = new ArrayList<RoleUserRelationEntity>();
            RoleUserRelationEntity vo = new RoleUserRelationEntity();
            vo.setAuthOrgId(orgId);
            vo.setUserId(userId);
            vo.setRoleId(roleSourceOms.getId());
            vo.setJobId(jobEntity.getId());
            vo.setEmployeeId(userId);
            roleUserRelationList.add(vo);
            this.roleUserRelationService.saveRoleUser(roleUserRelationList);
        }
        catch (Exception e) {
            this.logger.info("\u7528\u6237\u5e94\u7528\u6388\u6743-------{}", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void updateThirdAppUsers(UserVO userVo, Integer state) {
        UserEntity userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVo, UserEntity.class));
        EmployeeVO employeeEntity = this.employeeService.queryEmployeeByUserId(userEntity.getId());
        if (employeeEntity != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"user_id", (Object)userVo.getId());
            wrapper.eq((Object)"tenant_id", (Object)userVo.getTenantId());
            wrapper.eq((Object)"dr", (Object)0);
            List oldList = this.userTenantRelationService.list((Wrapper)wrapper);
            UserTenantRelationEntity relationEntity = (UserTenantRelationEntity)((Object)oldList.get(0));
            if (relationEntity.getTypeId() != 1) {
                relationEntity.setState(state);
                userEntity.setUserState(state);
                employeeEntity.setState(state);
            }
            employeeEntity.setMobilePhone(userVo.getUserMobile());
            employeeEntity.setName(userEntity.getUserName());
            this.saveOrUpdate((Object)userEntity);
            this.userTenantRelationService.saveOrUpdate((Object)relationEntity, false);
            this.employeeService.saveOrUpdate(BeanMapper.map((Object)employeeEntity, EmployeeEntity.class), false);
        }
    }

    @Override
    public List<UserVO> queryMangerUserList(QueryParam param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("searchText", param.getSearchText());
        map.put("tenantId", InvocationInfoProxy.getTenantid());
        List<OrgVO> orgVOS = this.orgService.queryAppSubByPid(InvocationInfoProxy.getOrgId());
        map.put("orgIds", Strings.join((Iterable)orgVOS.stream().map(vo -> vo.getId().toString()).collect(Collectors.toList()), (String)","));
        return this.userMapper.queryMangerUserList(map);
    }

    @Override
    public Boolean queryUserHasAppPermission(Long appIdToCheck) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long userId = InvocationInfoProxy.getUserid();
        UserVO userVo = this.selectById(userId);
        List<Long> userRoleIds = this.permissionCacheManage.getUserRoleCache(userId, tenantId);
        if (userRoleIds == null || userRoleIds.size() == 0) {
            userRoleIds = this.roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
        }
        HashMap<Long, Long> appIdMap = new HashMap<Long, Long>();
        if (userRoleIds != null && userRoleIds.size() > 0) {
            List<Long> appIds = null;
            for (Long roleId : userRoleIds) {
                appIds = this.permissionCacheManage.getRoleAppsCache(roleId);
                if (appIds == null || appIds.size() <= 0) continue;
                for (Long appId : appIds) {
                    appIdMap.put(appId, appId);
                }
            }
        }
        List<Long> omAppIds = null;
        omAppIds = 1 == userVo.getTypeId() ? (this.OMS_TENANT.equals(tenantId.toString()) ? this.appService.queryAllOperateList() : this.appService.queryAllHasAuthOmsOprateList()) : (this.OMS_TENANT.equals(tenantId.toString()) ? this.appService.queryAuthOperateList() : this.appService.queryAuthOperateOmsList());
        if (omAppIds != null) {
            for (Long omAppId : omAppIds) {
                if (appIdMap.containsKey(omAppId)) continue;
                appIdMap.put(omAppId, omAppId);
            }
        }
        return appIdMap.get(appIdToCheck) != null;
    }

    @Override
    public UserVO dealAndDealUserBySourceId(String sourceId, Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"source_id", (Object)sourceId)).eq((Object)"dr", (Object)0);
        UserEntity userEntity = (UserEntity)((Object)this.userMapper.selectOne((Wrapper)queryWrapper));
        if (userEntity != null) {
            if (!tenantId.equals(userEntity.getTenantId())) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"user_id", (Object)userEntity.getId());
                wrapper.eq((Object)"tenant_id", (Object)tenantId);
                wrapper.eq((Object)"dr", (Object)0);
                UserTenantRelationEntity userTenant = (UserTenantRelationEntity)((Object)this.userTenantRelationService.getOne((Wrapper)wrapper));
                this.updateTenantIdAndUserType(userTenant.getTypeId(), userEntity.getId(), tenantId, userTenant.getOrgId(), userTenant.getDeptId(), userTenant.getPostId());
                this.userTenantRelationService.updateUserMainSpace(userEntity.getId(), tenantId.toString());
                userEntity = (UserEntity)((Object)this.getById(userEntity.getId()));
            }
            return (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
        }
        return null;
    }

    @Override
    public List<JSONObject> queryUserInfosForZds(Map<String, String> param) {
        return this.userMapper.queryUserInfosForZds(param);
    }
}

