package com.ejianc.foundation.oms.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.tomcat.util.buf.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.foundation.oms.mapper.ComboAppMapper;
import com.ejianc.foundation.oms.mapper.ComboDoorMapper;
import com.ejianc.foundation.oms.mapper.ComboMapper;
import com.ejianc.foundation.oms.mapper.ComboRoleMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.oms.bean.ComboEnterpriseEntity;
import com.ejianc.foundation.oms.bean.ComboEntity;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.service.IComboService;
import com.ejianc.foundation.oms.vo.ComboVO;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;

/**
 * 套餐分配
 * 
 * @author generator
 * 
 */
@Service
public class ComboServiceImpl extends BaseServiceImpl<ComboMapper, ComboEntity> implements IComboService{

	@Autowired
	private ComboAppMapper appMapper;
	@Autowired
	private ComboRoleMapper roleMapper;
	@Autowired
	private ComboDoorMapper doorMapper;
	@Autowired
	private IComboEnterpriseService comboEnterpriseService;
	
	@Override
	public void delete(List<ComboVO> vos) {
		//若该套餐已分配租户则不允许删除
		List<Long> comboIds = vos.stream().map(ComboVO::getId).collect(Collectors.toList());
		QueryWrapper<ComboEnterpriseEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", 0);
		queryWrapper.in("combo_id", comboIds);
		List<ComboEnterpriseEntity> comboEnterpriseEntity = comboEnterpriseService.list(queryWrapper);
		if(comboEnterpriseEntity!=null&&comboEnterpriseEntity.size()>0){
//			Map<Long,String> map = new HashMap<>();
//			List<String> msg = new ArrayList<>();
//			comboEnterpriseEntity.forEach(e -> {
//				map.put(e.getComboId(), e.getComboName());
//			});
//			for(Long comboId : map.keySet()){
//				msg.add(map.get(comboId));
//			}
			throw new BusinessException("套餐已被分配用户，不能删除");
		}
		
        this.removeByIds(comboIds,true);
        for(ComboVO vo : vos){
            appMapper.deleteAuthApp(vo.getId(), null);
            roleMapper.deleteAuthRole(vo.getId(), null);
            doorMapper.deleteAuthDoor(vo.getId(), null);
        }
	}
    
}
