package com.ejianc.foundation.sync.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.sync.service.ISdbjSyncService;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.HttpTookit8Ju;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.foundation.utils.WeixinRestUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Service
public class SdbjSyncServiceImpl implements ISdbjSyncService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOrgService orgService;
	
	@Autowired
	private IDeptService deptService;
	
	@Autowired
	private IEmployeeService employeeService;
	
	@Autowired
	private IUserService userService;

	@Autowired
	private IJobService jobService;

	@Autowired
	private IThirdSystemService thirdSystemService;

	@Autowired
	private IRoleUserRelationService roleUserRelationService;

	@Autowired
	private IUserTenantRelationService userTenantRelationService;

	@Override
	public void syncData(String begintime, String endtime, Boolean updateTime) {
		//创建一个固定数量的线程池
		ExecutorService threadPool = Executors.newFixedThreadPool(3);
		RequestAttributes context = RequestContextHolder.getRequestAttributes();
		/********组织************/
		// 水电八局测试环境
		// String orgUrl = "http://fssc.baju.com.cn:8002/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/orgAddQuery";
		// 水电八局生产环境
		String orgUrl = "http://10.60.231.40/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/orgAddQuery";
		Callable<JSONArray> orgDeptCallable = new DataSync(begintime, endtime, orgUrl, context);
		Future<JSONArray> orgDeptFuture = threadPool.submit(orgDeptCallable);

		/********人员/用户************/
		// 水电八局测试环境
		// String userUrl = "http://fssc.baju.com.cn:8002/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/personAddCommonQuery";
		// 水电八局生产环境
		String userUrl = "http://10.60.231.40/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/personAddCommonQuery";
		Callable<JSONArray> userCallable = new DataSync(begintime, endtime, userUrl, context);
		Future<JSONArray> userFuture = threadPool.submit(userCallable);

		/********兼职************/
		// 水电八局测试环境
		// String jobUrl = "http://fssc.baju.com.cn:8002/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/personParttimeQuery";
		// 水电八局生产环境
		String jobUrl = "http://10.60.231.40/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/personParttimeQuery";
		Callable<JSONArray> jobCallable = new DataSync(begintime, endtime, jobUrl, context);
		Future<JSONArray> jobFuture = threadPool.submit(jobCallable);

		JSONArray orgDeptData = null;
		JSONArray userData = null;
		JSONArray jobData = null;
		try {
			orgDeptData = orgDeptFuture.get();
			userData = userFuture.get();
			jobData = jobFuture.get();
		} catch (Exception e) {
			logger.error("获取同步数据失败：{}", e);
			this.sendMsg("获取同步信息接口报错",(begintime+"----"+endtime));
			throw new BusinessException("获取同步数据失败");
		} finally {
			threadPool.shutdown();
		}
		logger.info("处理组织数据-------");
		try {
			this.syncOrgAndDeptList(orgDeptData);
		}catch (Exception e){
			logger.error("处理组织数据失败：{}", e);
			this.sendMsg("处理组织数据报错",(begintime+"----"+endtime));
			throw new BusinessException("处理组织数据失败");
		}
		logger.info("处理人员数据-------");
		try {
			this.syncEmployeeAndUserList(userData);
		}catch (Exception e){
			logger.error("处理人员数据失败：{}", e);
			this.sendMsg("处理人员数据报错",(begintime+"----"+endtime));
			throw new BusinessException("处理人员数据失败");
		}
		logger.info("处理兼职数据-------");
		try {
			this.syncJobList(jobData);
		}catch (Exception e){
			logger.error("处理兼职数据失败：{}", e);
			this.sendMsg("处理兼职数据报错",(begintime+"----"+endtime));
			throw new BusinessException("处理兼职数据失败");
		}
		logger.info("数据处理结束(- v -)!-------");

		if(updateTime){
			ThirdSystemEntity thirdSystemVO = thirdSystemService.queryThirdSystemByCode("sdbjSyncDate");
			thirdSystemVO.setConfigInfo(endtime);
			thirdSystemService.saveOrUpdate(thirdSystemVO,false);
		}
	}

	@Override
	public void syncOrgAndDeptList(JSONArray orgDeptData){
		List<String> disabldOrgSourceIds = new ArrayList<>();
		List<OrgEntity> addEditOrgList = new ArrayList<>();
		List<String> sourceOrgIds = new ArrayList<>();

		List<String> disabldDeptSourceIds = new ArrayList<>();
		List<DeptEntity> addEditDeptList = new ArrayList<>();
		List<String> sourceDeptIds = new ArrayList<>();

		for (Object data : orgDeptData) {
			JSONObject jdata = (JSONObject) data;
			if ("UN".equals(jdata.getString("codesetid"))) {
				String flag = jdata.get("flag")!=null?jdata.getString("flag"):null;
				if("3".equals(flag)){
					String sourceId = jdata.get("unique_id")!=null?(jdata.getString("unique_id").replaceAll("-", "")):null;
					disabldOrgSourceIds.add(sourceId);
				}else{
					String code = jdata.get("b0110_0")!=null?jdata.getString("b0110_0"):null;
					String sourceId = jdata.get("unique_id")!=null?(jdata.getString("unique_id").replaceAll("-", "")):null;
					String name = jdata.get("codeitemdesc")!=null?jdata.getString("codeitemdesc"):null;
					String shortName = jdata.get("codeitemdesc")!=null?jdata.getString("codeitemdesc"):null;
					Integer orgType = null;
					// 公司类型
					// 八局-------1 部门，2 三级单位，3 二级单位,4 其他，5 总公司，6 总部，7
					// 直管项目,8 二级机
					// 益企联------1：集团 ， 2：分（子）公司，3：经理部，4：虚拟组织，5：项目部
					if (jdata.get("f0107") != null) {
						if ("5".equals(jdata.getString("f0107"))) {
							orgType = 1;
						} else if ("6".equals(jdata.getString("f0107"))) {
							orgType = 4;
						} else if ("3".equals(jdata.getString("f0107"))) {
							orgType = 2;
						} else if ("8".equals(jdata.getString("f0107"))) {
							orgType = 4;
						} else if ("7".equals(jdata.getString("f0107"))) {
							orgType = 2;
						} else if ("2".equals(jdata.getString("f0107"))) {
							orgType = 3;
						} else {
							orgType = 4;
						}
					}
					String sourceOrgParentId = null;
					if (jdata.get("parentid") != null) {
						sourceOrgParentId = jdata.getString("parentid").replaceAll("-", "");
					}
					// 组织
					OrgEntity org = new OrgEntity();
					org.setEnterpriseId(999999l);
					org.setTenantId(999999l);
					org.setCode(code);
					org.setSourceId(sourceId);
					org.setName(name);
					org.setShortName(shortName);
					org.setOrgType(orgType);
					org.setProjectCode(sourceOrgParentId);
					org.setId(IdWorker.getId());
					org.setSystemId("1247777316689256450");
					addEditOrgList.add(org);

					if(!sourceOrgIds.contains(sourceId)){
						sourceOrgIds.add(sourceId);
					}
					if(!sourceOrgIds.contains(sourceOrgParentId)){
						sourceOrgIds.add(sourceOrgParentId);
					}
				}
			} else if ("UM".equals(jdata.getString("codesetid"))) {
				String flag = jdata.get("flag")!=null?jdata.getString("flag"):null;
				if("3".equals(flag)){
					String sourceId = jdata.get("unique_id")!=null?(jdata.getString("unique_id").replaceAll("-", "")):null;
					disabldDeptSourceIds.add(sourceId);
				}else{
					String sourceId = jdata.get("unique_id")!=null?(jdata.getString("unique_id").replaceAll("-", "")):null;
					String code = jdata.get("b0110_0")!=null?jdata.getString("b0110_0"):null;
					String name = jdata.get("codeitemdesc")!=null?jdata.getString("codeitemdesc"):null;
					Integer sequence = jdata.get("a0000")!=null?Integer.valueOf(jdata.getString("a0000")):null;
					String orgId = jdata.getString("parentid").replaceAll("-", "");

					if(!sourceDeptIds.contains(sourceId)){
						sourceDeptIds.add(sourceId);
						sourceDeptIds.add(orgId);
					}
					if(!sourceOrgIds.contains(orgId)){
						sourceOrgIds.add(orgId);
					}
					DeptEntity deptEntity = new DeptEntity();
					deptEntity.setSourceOrgId(orgId);
					deptEntity.setSourceId(sourceId);
					deptEntity.setCode(code);
					deptEntity.setName(name);
					deptEntity.setSequence(sequence);
					deptEntity.setSystemId("1247777316689256450");
					addEditDeptList.add(deptEntity);
				}
			}
		}

		Map<String, OrgEntity> orgMap = new HashMap<>();
		if(sourceOrgIds!=null && sourceOrgIds.size()>0){
			QueryWrapper<OrgEntity> wrapper = new QueryWrapper();
			wrapper.in("source_id", sourceOrgIds);
			wrapper.eq("tenant_id", 999999l);
			List<OrgEntity> orgList = orgService.list(wrapper);
			if(orgList!=null && orgList.size()>0){
				for(OrgEntity entity : orgList){
					orgMap.put(entity.getSourceId(), entity);
				}
			}
		}

		logger.info("处理组织-----------------");
		//删除组织------停用
		if(disabldOrgSourceIds!=null && disabldOrgSourceIds.size()>0){
			UpdateWrapper<OrgEntity> wrapper = new UpdateWrapper<>();
			wrapper.in("source_id", disabldOrgSourceIds);
			wrapper.eq("tenant_id", 999999l);
			wrapper.set("state", 0);
			orgService.update(null, wrapper);
		}
		//修改或者新增组织
		if(addEditOrgList!=null && addEditOrgList.size()>0){
			List<OrgEntity> addList = new ArrayList<>();
			for(OrgEntity entity : addEditOrgList){
				OrgEntity oldEntity = orgMap.get(entity.getSourceId());
				OrgEntity parentEntity = orgMap.get(entity.getProjectCode());
				if(oldEntity!=null){
					//修改---
					oldEntity.setOrgType(entity.getOrgType());
					oldEntity.setState(1);
					if(oldEntity.getProjectState()==null){
						oldEntity.setProjectState(2);
					}
					oldEntity.setName(entity.getName());
					oldEntity.setShortName(entity.getShortName());
					oldEntity.setCode(entity.getCode());
					if(parentEntity!=null && !oldEntity.getParentId().equals(parentEntity.getId())){
						//存在上级组织，且上级组织发生变化
						String innerCode = parentEntity.getInnerCode() + "|" + oldEntity.getId();
						oldEntity.setInnerCode(innerCode);
						oldEntity.setParentId(parentEntity.getId());
					}
					addList.add(oldEntity);
				}else{
					Long id = IdWorker.getId();
					//新增----
					if(parentEntity!=null){
						//存在上级组织，且上级组织发生变化
						String innerCode = parentEntity.getInnerCode() + "|" + id;
						entity.setInnerCode(innerCode);
						entity.setParentId(parentEntity.getId());
					}else{
						entity.setInnerCode(id.toString());
					}
					entity.setId(id);
					entity.setState(1);
					entity.setProjectState(2);
					entity.setProjectCode(null);
					addList.add(entity);
					orgMap.put(entity.getSourceId(), entity);
				}
			}
			orgService.saveOrUpdateBatch(addList, addList.size(), false);
		}

		logger.info("处理部门-----------------");
		Map<String, DeptEntity> deptMap = new HashMap<>();
		if(sourceDeptIds!=null && sourceDeptIds.size()>0){
			QueryWrapper<DeptEntity> wrapper = new QueryWrapper();
			wrapper.eq("tenant_id", 999999l);
			wrapper.in("source_id", sourceDeptIds);
			List<DeptEntity> deptList = deptService.list(wrapper);
			if(deptList!=null && deptList.size()>0){
				for(DeptEntity entity : deptList){
					deptMap.put(entity.getSourceId(), entity);
				}
			}
		}
		//删除部门------停用
		if(disabldDeptSourceIds!=null && disabldDeptSourceIds.size()>0){
			UpdateWrapper<DeptEntity> wrapper = new UpdateWrapper<>();
			wrapper.in("source_id", disabldDeptSourceIds);
			wrapper.eq("tenant_id", 999999l);
			wrapper.set("state", 0);
			deptService.update(null, wrapper);
		}
		//修改或者新增部门
		if(addEditDeptList!=null && addEditDeptList.size()>0){
			List<DeptEntity> addList = new ArrayList<>();
			for(DeptEntity entity : addEditDeptList){
				DeptEntity oldEntity = deptMap.get(entity.getSourceId());
				Long orgId = null;
				Long parentId = null;
				if(deptMap.get(entity.getSourceOrgId())!=null){
					DeptEntity parentEntity = deptMap.get(entity.getSourceOrgId());
					orgId = parentEntity.getOrgId();
					parentId = parentEntity.getId();
				}else if(orgMap.get(entity.getSourceOrgId())!=null){
					OrgEntity parentEntity = orgMap.get(entity.getSourceOrgId());
					orgId = parentEntity.getId();
				}

				if(oldEntity!=null){
					//修改
					oldEntity.setName(entity.getName());
					oldEntity.setCode(entity.getCode());
					oldEntity.setSequence(entity.getSequence());
					oldEntity.setOrgId(orgId);
					oldEntity.setSourceOrgId(entity.getSourceOrgId());
					oldEntity.setPid(parentId);
					oldEntity.setState(1);
					addList.add(oldEntity);
				}else{
					//新增
					entity.setOrgId(orgId);
					entity.setState(1);
					entity.setPid(parentId);
					addList.add(entity);
				}
			}
			deptService.saveOrUpdateBatch(addList, addList.size(), false);
		}
	}

	@Override
	public void syncEmployeeAndUserList(JSONArray userData) {

		List<String> disabldUserSourceIds = new ArrayList<>();
		List<EmployeeEntity> addEditUserList = new ArrayList<>();
		List<String> sourceOrgIds = new ArrayList<>();
		List<String> sourceUserIds = new ArrayList<>();

		for (Object data : userData) {
			JSONObject jdata = (JSONObject) data;
			String flag = jdata.get("flag")!=null?jdata.getString("flag"):null;
			if("3".equals(flag)){
				String sourceId = jdata.get("unique_id")!=null?(jdata.getString("unique_id").replaceAll("-", "")):null;
				disabldUserSourceIds.add(sourceId);
			}else{
				String sourceId = jdata.get("unique_id")!=null?(jdata.getString("unique_id").replaceAll("-", "")):null;
				String userCode = jdata.get("e0127")!=null?jdata.getString("e0127"):null;
				String userName = jdata.get("a0101")!=null?jdata.getString("a0101"):null;
				Integer sex = jdata.get("a0107")!=null?("女".equals(jdata.getString("a0107")) ? 2 : 1):null;
				Date registTime = null;
				try {
					registTime = jdata.get("c0183")!=null?(new SimpleDateFormat("yyyy-MM-dd").parse(jdata.getString("c0183"))):null;
				}catch (Exception e){}
				String userMobile = jdata.get("c0104")!=null?jdata.getString("c0104"):null;
				String userEmail = jdata.get("c0102")!=null?jdata.getString("c0102"):null;
				String qqId = jdata.get("h01sm")!=null?jdata.getString("h01sm"):null;
				String sourceOrgId = jdata.get("orgid")!=null?jdata.getString("orgid").replaceAll("-", ""):null;
				String idcard = jdata.get("a0177")!=null?jdata.getString("a0177"):null;
				Date birthday = null;
				try {
					birthday = jdata.get("a0111")!=null?(new SimpleDateFormat("yyyy-MM-dd").parse(jdata.getString("a0111"))):null;
				}catch (Exception e){}
				String otherPhone = jdata.get("c010v")!=null?jdata.getString("c010v"):null;
				String postName = jdata.get("c010k")!=null?jdata.getString("c010k"):null;

				EmployeeEntity employeeEntity = new EmployeeEntity();
				Long id = IdWorker.getId();
				employeeEntity.setUserId(id);
				employeeEntity.setId(id);
				employeeEntity.setSourceId(sourceId);
				employeeEntity.setCode(userCode);
				employeeEntity.setName(userName);
				employeeEntity.setSex(sex);
				employeeEntity.setWorkTime(registTime);
				employeeEntity.setMobilePhone(userMobile);
				employeeEntity.setIdcard(idcard);
				employeeEntity.setBirthday(birthday);
				employeeEntity.setOtherPhone(otherPhone);

				employeeEntity.setSystemId("1247777316689256450");
				employeeEntity.setTenantId(999999l);
				employeeEntity.setPhotoPath(userEmail);//userEmail
				employeeEntity.setUserSignaturePath(qqId);//qqId
				employeeEntity.setNote(sourceOrgId);//sourceOrgId
				addEditUserList.add(employeeEntity);

				sourceUserIds.add(sourceId);
				sourceOrgIds.add(sourceOrgId);
			}

		}

		//删除用户------停用
		if(disabldUserSourceIds!=null && disabldUserSourceIds.size()>0){
			UpdateWrapper<UserEntity> wrapper = new UpdateWrapper<>();
			wrapper.in("source_id", disabldUserSourceIds);
			wrapper.eq("tenant_id", 999999l);
			wrapper.set("user_state", 0);
			userService.update(null, wrapper);

			QueryWrapper<UserEntity> qwrapper = new QueryWrapper();
			qwrapper.in("source_id", disabldUserSourceIds);
			qwrapper.eq("tenant_id", 999999l);
			List<UserEntity> userList = userService.list(qwrapper);
			if(userList!=null && userList.size()>0){
				List<Long> disabldUserIds = new ArrayList<>();
				for(UserEntity en : userList){
					disabldUserIds.add(en.getId());
				}

				UpdateWrapper<EmployeeEntity> ewrapper = new UpdateWrapper<>();
				ewrapper.in("user_id", disabldUserIds);
				ewrapper.eq("tenant_id", 999999l);
				ewrapper.set("state", 0);
				employeeService.update(null, ewrapper);

				UpdateWrapper<UserTenantRelationEntity> twrapper = new UpdateWrapper<>();
				twrapper.in("user_id", disabldUserIds);
				twrapper.eq("tenant_id", 999999l);
				twrapper.set("state", 0);
				userTenantRelationService.update(null, twrapper);
			}
		}

		Map<String, DeptEntity> deptMap = new HashMap<>();
		Map<String, OrgEntity> orgMap = new HashMap<>();
		if(sourceOrgIds!=null && sourceOrgIds.size()>0){
			QueryWrapper<OrgEntity> owrapper = new QueryWrapper();
			owrapper.in("source_id", sourceOrgIds);
			owrapper.eq("tenant_id", 999999l);
			List<OrgEntity> orgList = orgService.list(owrapper);
			if(orgList!=null && orgList.size()>0){
				for(OrgEntity entity : orgList){
					orgMap.put(entity.getSourceId(), entity);
				}
			}
			QueryWrapper<DeptEntity> wrapper = new QueryWrapper();
			wrapper.in("source_id", sourceOrgIds);
			wrapper.eq("tenant_id", 999999l);
			List<DeptEntity> deptList = deptService.list(wrapper);
			if(deptList!=null && deptList.size()>0){
				for(DeptEntity entity : deptList){
					deptMap.put(entity.getSourceId(), entity);
				}
			}
		}

		Map<String, UserEntity> userMap = new HashMap<>();
		Map<String, EmployeeEntity> employeeMap = new HashMap<>();
		Map<Long, UserTenantRelationEntity> userTenantMap = new HashMap<>();
		if(sourceUserIds!=null && sourceUserIds.size()>0){
			QueryWrapper<UserEntity> qwrapper = new QueryWrapper();
			qwrapper.in("source_id", sourceUserIds);
			qwrapper.eq("tenant_id", 999999l);
			List<UserEntity> userList = userService.list(qwrapper);
			List<Long> userIds = new ArrayList<>();
			if(userList!=null && userList.size()>0){
				for(UserEntity en : userList){
					userIds.add(en.getId());
					userMap.put(en.getSourceId(), en);
				}
				logger.info("查询出的用户数量：{}",userIds.size());

				QueryWrapper<EmployeeEntity> ewrapper = new QueryWrapper<>();
				ewrapper.in("user_id", userIds);
				ewrapper.eq("tenant_id", 999999l);
				List<EmployeeEntity> employeeList = employeeService.list(ewrapper);
				for(EmployeeEntity en : employeeList){
					employeeMap.put(en.getSourceId(), en);
				}
				logger.info("查询出的人员数量：{}",employeeList.size());

				QueryWrapper<UserTenantRelationEntity> twrapper = new QueryWrapper<>();
				twrapper.in("user_id", userIds);
				twrapper.eq("tenant_id", 999999l);
				List<UserTenantRelationEntity> userTenantRelationList = userTenantRelationService.list(twrapper);
				for(UserTenantRelationEntity en : userTenantRelationList){
					userTenantMap.put(en.getUserId(), en);
				}
				logger.info("查询出的关系数量：{}",userTenantRelationList.size());
			}

			List<UserEntity> addUserList = new ArrayList<>();
			List<EmployeeEntity> addEmployeeList = new ArrayList<>();
			List<UserTenantRelationEntity> addUserTenantList = new ArrayList<>();
			List<JobEntity> addJobList = new ArrayList<>();
			List<RoleUserRelationEntity> addRoleUserList = new ArrayList<>();
			List<Long> roleIds = new ArrayList<>();

			for(EmployeeEntity entity : addEditUserList){
				UserEntity oldentity = userMap.get(entity.getSourceId());
				String sourceOrgId = null;
				String sourceDeptId = null;
				Long deptId = null;
				Long orgId = null;
				String orgName = null;
				if(deptMap.get(entity.getNote())!=null){
					sourceDeptId = entity.getNote();
					deptId = deptMap.get(entity.getNote()).getId();
					orgId = deptMap.get(entity.getNote()).getOrgId();
				}else if(orgMap.get(entity.getNote())!=null){
					sourceOrgId = entity.getNote();
					orgId = orgMap.get(entity.getNote()).getId();
					orgName = orgMap.get(entity.getNote()).getName();
				}

				if(oldentity!=null){
					//修改
					EmployeeEntity oldEmployeeEntity = employeeMap.get(entity.getSourceId());
					UserTenantRelationEntity oldUserTenantRelationEntity = userTenantMap.get(oldentity.getId());

					//判断人员是否调动了
					Boolean move = false;
					if(((orgId!=null&&oldEmployeeEntity.getOrgId()==null)||
							(oldEmployeeEntity.getOrgId()!=null&&orgId==null)||
							(orgId!=null&&oldEmployeeEntity.getOrgId()!=null && !orgId.equals(oldEmployeeEntity.getOrgId())))){
						move = true;
					}

					//用户
					oldentity.setSourceOrgId(entity.getNote());
					oldentity.setUserName(entity.getName());
					oldentity.setWeixineeId(entity.getCode());
					oldentity.setSex(Integer.valueOf(entity.getSex()));
					oldentity.setRegistTime(entity.getWorkTime());
					oldentity.setUserMobile(entity.getMobilePhone());
					oldentity.setUserEmail(entity.getPhotoPath());
					oldentity.setSystemId(entity.getSystemId());
					oldentity.setOrgId(orgId);
					oldentity.setQqId(entity.getUserSignaturePath());
					addUserList.add(oldentity);

					//人员
					if(oldEmployeeEntity==null){
						oldEmployeeEntity = new EmployeeEntity();
						oldEmployeeEntity.setId(oldentity.getId());
						oldEmployeeEntity.setUserId(oldentity.getId());
					}
					oldEmployeeEntity.setSourceId(entity.getSourceId());
					oldEmployeeEntity.setCode(entity.getCode());
					oldEmployeeEntity.setName(entity.getName());
					oldEmployeeEntity.setSex(entity.getSex());
					oldEmployeeEntity.setWorkTime(entity.getWorkTime());
					oldEmployeeEntity.setMobilePhone(entity.getMobilePhone());
					oldEmployeeEntity.setIdcard(entity.getIdcard());
					oldEmployeeEntity.setBirthday(entity.getBirthday());
					oldEmployeeEntity.setOtherPhone(entity.getOtherPhone());
					oldEmployeeEntity.setOrgId(orgId);
					oldEmployeeEntity.setDeptId(deptId);
					oldEmployeeEntity.setSystemId(entity.getSystemId());
					addEmployeeList.add(oldEmployeeEntity);

					//用户组织关系表
					if(oldUserTenantRelationEntity==null){
						oldUserTenantRelationEntity = new UserTenantRelationEntity();
						oldUserTenantRelationEntity.setId(IdWorker.getId());
						oldUserTenantRelationEntity.setUserId(oldentity.getId());
						oldUserTenantRelationEntity.setEmployeeId(oldentity.getId());
						oldUserTenantRelationEntity.setMainSpaceFlag(1);//主空间
						oldUserTenantRelationEntity.setTypeId(2);//普通用户
						oldUserTenantRelationEntity.setState(1);//启用
					}
					oldUserTenantRelationEntity.setDeptId(deptId);
					oldUserTenantRelationEntity.setOrgId(orgId);
					oldUserTenantRelationEntity.setTenantId(oldentity.getTenantId());
					addUserTenantList.add(oldUserTenantRelationEntity);

					if(move){
						Long pkJobId = IdWorker.getId();
						//当用户的组织改变时，修改主职的信息(相当于调用)
						QueryWrapper<JobEntity> jobWrapper = new QueryWrapper<>();
						jobWrapper.eq("dr", 0);
						jobWrapper.eq("employee_id", oldEmployeeEntity.getId());
						jobWrapper.eq("property", 1);//主职
						jobWrapper.eq("cur_state", 0);//启用
						jobWrapper.eq("tenant_id", 999999l);
						JobEntity jobEntity = jobService.getOne(jobWrapper, false);
						//将原先的主职信息停用掉
						if(jobEntity!=null){
							jobEntity.setCurState(1);
							jobEntity.setJobEndTime(new Date());
							addJobList.add(jobEntity);

							//获取主职的角色权限，并删除及复制新的角色权限到用户下
							Map<String, Object> params = new HashMap<>();
							List<Long> jobIds = new ArrayList<>();
							jobIds.add(jobEntity.getId());
							params.put("jobIds", jobIds);
							params.put("tenantId", InvocationInfoProxy.getTenantid());
							List<RoleUserRelationVO> roleList = roleUserRelationService.queryListByProperties(params);
							if(roleList!=null&&roleList.size()>0){
								//说明该job下存在角色
								for(RoleUserRelationVO vo : roleList){
									roleIds.add(vo.getId());
									RoleUserRelationEntity add = new RoleUserRelationEntity();
									if(orgId!=null){
										add.setAuthOrgId(orgId);
										add.setEmployeeId(oldEmployeeEntity.getId());
										add.setJobId(pkJobId);
										add.setRoleId(vo.getRoleId());
										add.setUserId(oldentity.getId());
										addRoleUserList.add(add);
									}
								}
							}

						}
						//新增一条新的记录

						JobEntity jobNewEntity = new JobEntity();
						jobNewEntity.setSourceDeptId(sourceDeptId);
						jobNewEntity.setSourceOrgId(sourceOrgId);
						jobNewEntity.setId(pkJobId);
						jobNewEntity.setOrgId(orgId);
						jobNewEntity.setDeptId(deptId);
						jobNewEntity.setEmployeeId(oldEmployeeEntity.getId());
						jobNewEntity.setProperty(1);
						jobNewEntity.setJobStartTime(new Date());
						jobNewEntity.setCurState(0);
						jobNewEntity.setSystemId(entity.getSystemId());
						addJobList.add(jobNewEntity);
					}
					//处理主职信息
				}else{
					UserEntity userEntity = new UserEntity();
					userEntity.setId(entity.getUserId());
					userEntity.setOrgId(orgId);
					userEntity.setUserName(entity.getName());
					userEntity.setUserCode(entity.getCode());
					userEntity.setUserMobile(entity.getMobilePhone());
					userEntity.setTypeId(2); //普通用户
					userEntity.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
					userEntity.setDr(BaseVO.DR_UNDELETE);
					userEntity.setSex(entity.getSex());
					userEntity.setWeixineeId(userEntity.getUserCode());
					userEntity.setSystemId(entity.getSystemId());
					userEntity.setSourceId(entity.getSourceId());
					userEntity.setSourceOrgId(entity.getNote());
					//生成默认密码
					UserVO userVO = BeanMapper.map(userEntity, UserVO.class);
					PasswordUtils.setSalt(userVO);
					String shaPassword = PasswordUtils.encodePasswordUsingSHA("sdbj_ejc_2020");
					userEntity.setSalt(userVO.getSalt());
					userEntity.setPassword(shaPassword);
					userEntity.setPassword(PasswordUtils.encodebyUserCode(userVO));
					userEntity.setPwdStartTime(new Date());
					addUserList.add(userEntity);

					entity.setOrgId(orgId);
					entity.setDeptId(deptId);
					entity.setPhotoPath(null);//
					entity.setUserSignaturePath(null);//
					entity.setNote(null);//
					entity.setState(1);
					entity.setEmployeeType(1);//在职
					addEmployeeList.add(entity);


					//任职信息
					JobEntity job = new JobEntity();
					job.setSourceDeptId(sourceDeptId);
					job.setSourceOrgId(sourceOrgId);
					job.setOrgId(orgId);
					job.setDeptId(deptId);
					job.setEmployeeId(entity.getId());
					job.setProperty(1);
					job.setJobStartTime(new Date());
					job.setCurState(0);
					job.setSystemId(entity.getSystemId());
					addJobList.add(job);

					//生成用户租户关系表
					UserTenantRelationEntity userTenantEntity = new UserTenantRelationEntity();
					userTenantEntity.setUserId(userEntity.getId());
					userTenantEntity.setEmployeeId(entity.getId());
					userTenantEntity.setOrgId(entity.getOrgId());
					userTenantEntity.setTenantId(entity.getTenantId());
					userTenantEntity.setDeptId(entity.getDeptId());
					userTenantEntity.setMainSpaceFlag(1);//主空间
					userTenantEntity.setTypeId(2);//普通用户
					userTenantEntity.setState(1);//启用
					addUserTenantList.add(userTenantEntity);
				}
			}

			if(addUserList!=null && addUserList.size()>0){
				userService.saveOrUpdateBatch(addUserList, addUserList.size(), false);
			}
			if(addEmployeeList!=null && addEmployeeList.size()>0){
				employeeService.saveOrUpdateBatch(addEmployeeList, addEmployeeList.size(), false);
			}
			if(addUserTenantList!=null && addUserTenantList.size()>0){
				userTenantRelationService.saveOrUpdateBatch(addUserTenantList, addUserTenantList.size(), false);
			}
			if(addJobList!=null && addJobList.size()>0){
				jobService.saveOrUpdateBatch(addJobList, addJobList.size(), false);
			}
			if(roleIds!=null && roleIds.size()>0){
				roleUserRelationService.delete(roleIds);
			}
			if(addRoleUserList!=null && addRoleUserList.size()>0){
				roleUserRelationService.saveRoleUser(addRoleUserList);
			}
		}

	}

	@Override
	public void syncJobList(JSONArray jobData){

		List<String> delSourceJobIds = new ArrayList<>();
		List<JobEntity> delJobList = new ArrayList<>();

		List<String> sourceJobIds = new ArrayList<>();
		List<String> sourceOrgIds = new ArrayList<>();
		List<String> sourceUserIds = new ArrayList<>();
		List<String> sourceDeptIds = new ArrayList<>();

		List<JobEntity> addJobList = new ArrayList<>();

		for (Object data : jobData) {
			JSONObject jdata = (JSONObject) data;
			String flag = jdata.get("flag")!=null?jdata.getString("flag"):null;
			String sourceId = jdata.get("partid") != null?jdata.getString("partid").replaceAll("-", ""):null;
			String sourceEmployeeId = jdata.get("staffid") != null?jdata.getString("staffid").replaceAll("-", ""):null;
			String sourceDeptId = jdata.get("deptid") != null?jdata.getString("deptid").replaceAll("-", ""):null;
			String sourceOrgId = jdata.get("orgnm") != null?jdata.getString("orgnm").replaceAll("-", ""):null;
			Date jobStartTime = null;
			Date jobEndTime = null;
			if(jdata.get("sdate") != null){
				SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//注意月份是MM
				try {
					Date date = simpleDateFormat.parse(jdata.getString("sdate"));
					if (jdata.get("ryrm") != null && "1".equals(jdata.getString("ryrm"))) {
						// 免职为停用
						jobEndTime = date;
					}else{
						jobStartTime = date;
					}
				}catch (Exception e){}
			}

			JobEntity job = new JobEntity();
			job.setSourceId(sourceId);
			job.setSourceOrgId(sourceOrgId);
			job.setSourceDeptId(sourceDeptId);
			job.setSystemId(sourceEmployeeId);
			job.setJobStartTime(jobStartTime);
			job.setJobEndTime(jobEndTime);
			job.setProperty(0);
			job.setCurState(0);
			if("3".equals(flag)){
				delSourceJobIds.add(sourceId);
				delJobList.add(job);
			}else{
				if (jdata.get("ryrm") != null && "1".equals(jdata.getString("ryrm"))) {
					// 免职为停用
					delSourceJobIds.add(sourceId);
					delJobList.add(job);
				}else{
					addJobList.add(job);
				}
			}
			sourceJobIds.add(sourceId);
			sourceOrgIds.add(sourceOrgId);
			sourceUserIds.add(sourceEmployeeId);
			sourceDeptIds.add(sourceDeptId);
		}

		Map<String, EmployeeEntity> employeeMap = new HashMap<>();
		//人员信息
		if(sourceUserIds!=null && sourceUserIds.size()>0) {
			QueryWrapper<EmployeeEntity> qwrapper = new QueryWrapper();
			qwrapper.in("source_id", sourceUserIds);
			qwrapper.eq("tenant_id", 999999l);
			List<EmployeeEntity> userList = employeeService.list(qwrapper);
			for (EmployeeEntity entity : userList){
				employeeMap.put(entity.getSourceId(), entity);
			}
		}
		//组织信息
		Map<String, OrgEntity> orgMap = new HashMap<>();
		if(sourceOrgIds!=null && sourceOrgIds.size()>0) {
			QueryWrapper<OrgEntity> qwrapper = new QueryWrapper();
			qwrapper.in("source_id", sourceOrgIds);
			qwrapper.eq("tenant_id", 999999l);
			List<OrgEntity> userList = orgService.list(qwrapper);
			for (OrgEntity entity : userList){
				orgMap.put(entity.getSourceId(), entity);
			}
		}
		//部门信息
		Map<String, DeptEntity> deptMap = new HashMap<>();
		if(sourceDeptIds!=null && sourceDeptIds.size()>0) {
			QueryWrapper<DeptEntity> qwrapper = new QueryWrapper();
			qwrapper.in("source_id", sourceDeptIds);
			qwrapper.eq("tenant_id", 999999l);
			List<DeptEntity> deptList = deptService.list(qwrapper);
			for (DeptEntity entity : deptList){
				deptMap.put(entity.getSourceId(), entity);
			}
		}
		//任职信息
		Map<String, JobEntity> jobMap = new HashMap<>();
		if(sourceJobIds!=null && sourceJobIds.size()>0) {
			QueryWrapper<JobEntity> qwrapper = new QueryWrapper();
			qwrapper.in("source_id", sourceJobIds);
			qwrapper.eq("tenant_id", 999999l);
			List<JobEntity> jobList = jobService.list(qwrapper);
			for (JobEntity entity : jobList){
				jobMap.put(entity.getSourceId(), entity);
			}
		}

		List<JobEntity> dealJobList = new ArrayList<>();
		List<Long> delJobIds = new ArrayList<>();

		if(delJobList!=null && delJobList.size()>0){
			for(JobEntity entity : delJobList){
				JobEntity old = jobMap.get(entity.getSourceId());
				if(old!=null){
					if(entity.getJobEndTime()!=null){
						old.setJobEndTime(entity.getJobEndTime());
					}else{
						old.setJobEndTime(new Date());
					}
					old.setCurState(1);
					delJobIds.add(old.getId());
					dealJobList.add(old);
				}
			}
		}
		if(addJobList!=null && addJobList.size()>0) {
			for (JobEntity entity : addJobList) {
				JobEntity oldJob = jobMap.get(entity.getSourceId());
				OrgEntity org = orgMap.get(entity.getSourceOrgId());
				DeptEntity dept = deptMap.get(entity.getSourceDeptId());
				EmployeeEntity employee =employeeMap.get(entity.getSystemId());
				if(oldJob!=null){
					if(org!=null){
						oldJob.setOrgId(org.getId());
					}
					if(dept!=null){
						oldJob.setDeptId(dept.getId());
						oldJob.setOrgId(dept.getOrgId());
					}
					if(employee!=null){
						oldJob.setEmployeeId(employee.getId());
					}
					oldJob.setSourceOrgId(entity.getSourceOrgId());
					oldJob.setSourceDeptId(entity.getSourceDeptId());
					oldJob.setJobStartTime(entity.getJobStartTime());
					oldJob.setJobEndTime(entity.getJobEndTime());
					dealJobList.add(oldJob);
				}else{
					entity.setSystemId("1247777316689256450");
					if(org!=null){
						entity.setOrgId(org.getId());
					}
					if(dept!=null){
						entity.setDeptId(dept.getId());
						entity.setOrgId(dept.getOrgId());
					}
					if(employee!=null){
						entity.setEmployeeId(employee.getId());
					}
					dealJobList.add(entity);
				}
			}
		}
		if(dealJobList!=null && dealJobList.size()>0){
			jobService.saveOrUpdateBatch(dealJobList, dealJobList.size(), false);
		}
		if(delJobIds!=null && delJobIds.size()>0){
			roleUserRelationService.deleteByJobIds(delJobIds);
		}
	}

	class DataSync implements Callable<JSONArray> {

		private String begintime;
		private String endtime;
		private String url;
		private RequestAttributes context;

		public DataSync(String begintime, String endtime, String url, RequestAttributes context) {
			this.begintime = begintime;
			this.endtime = endtime;
			this.url = url;
			this.context = context;
		}

		@Override
		public JSONArray call() throws Exception {
			RequestContextHolder.setRequestAttributes(context);
			JSONArray datas = new JSONArray();
			boolean flag = true;
			int pageNumber = 1;
			while (flag) {
				JSONObject json = new JSONObject();
				json.put("input1", "");
				json.put("input2", pageNumber);
				json.put("begintime", begintime);
				json.put("endtime", endtime);
				String backData = HttpTookit8Ju.postByJson(url, json.toJSONString());
				JSONObject jsonResponse = JSON.parseObject(backData);
				JSONArray data = (JSONArray) jsonResponse.get("data");
				if (data != null && data.size() > 0) {
					datas.addAll(data);
					if (data.size() < 100) {
						flag = false;
					}
				} else {
					flag = false;
				}
				pageNumber++;
			}

			return datas;
		}

	}

	//给人员发送微信消息通知调用失败
	@Override
	public void sendMsg(String range, String time){

		ThirdSystemEntity thirdSystemVO = thirdSystemService.queryThirdSystemByCode("WeixinEE");
		String configInfo = thirdSystemVO.getConfigInfo();
		JSONObject zzyjConfig = JSONObject.parseObject(configInfo);
		String appid = zzyjConfig.getString("corp_appId");
		String secret = zzyjConfig.getString("corp_secret");
		String accessToken = thirdSystemService.getWeixineeAccessToken(appid, secret, true);

		logger.info("access_token = "+accessToken);

		String content = "水电八局同步失败,范围:["+range+"],时间:["+time+"]";

		JSONObject templateJson = new JSONObject();
		templateJson.put("agentid", appid);

		ThirdSystemEntity third = thirdSystemService.queryThirdSystemByCode("sdbjSyncWeixinEeId");
		String weixinEeId = third.getConfigInfo();

		templateJson.put("touser", weixinEeId);
		templateJson.put("msgtype", "text");
		templateJson.put("safe", 0); //是否保密发送 0：否， 1：是

		JSONObject contentJson = new JSONObject();
		contentJson.put("content", content);
		templateJson.put("text", contentJson);

		String templateContent = JSON.toJSONString(templateJson);
		logger.info("企业微信发送参数： accessToken={}, templateContent={}",accessToken, templateContent);
		String templateResult = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token="+accessToken+"&debug=1", templateContent);
		logger.info("企业微信发送结果：{}",templateResult);

		JSONObject httpResult = JSON.parseObject(templateResult);
		if(httpResult != null) {
			logger.info("weixin_response = "+JSON.toJSONString(httpResult));
		}
		if ("ok".equals(httpResult.get("errmsg"))) {
			logger.info("发送企业微信成功!");
		} else {
			logger.info("发送企业微信失败------------!");
		}
	}

}
