package com.ejianc.foundation.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.helpcenter.bean.ScGroupEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;

public class ScGroupAsTree {
	
	public static List<ScGroupEntity> createTreeData(List<ScGroupEntity> list) {
		List<ScGroupEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, ScGroupEntity> listMap = new HashMap<>();
		for(ScGroupEntity scGroupEntity:list) {
			listMap.put(scGroupEntity.getId().toString(), scGroupEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	ScGroupEntity scGroupEntity = list.get(i);
        	String parentId = (scGroupEntity.getParentId() != null && scGroupEntity.getParentId() > 0) ? scGroupEntity.getParentId().toString():"";
        	ScGroupEntity parent = listMap.get(parentId);
        	if(parent != null) {
        		List<ScGroupEntity> child = parent.getChildren();
        		if(child != null) {
        			child.add(scGroupEntity);
        		}else{
        			List<ScGroupEntity> children = new ArrayList<ScGroupEntity>();
        			children.add(scGroupEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(scGroupEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}
	
	public static List<OrgVO> createTreeDataVO(List<OrgVO> list) {
		List<OrgVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, OrgVO> listMap = new HashMap<>();
		for(OrgVO orgEntity:list) {
			listMap.put(orgEntity.getId().toString(), orgEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	OrgVO orgEntity = list.get(i);
        	String parentId = (orgEntity.getParentId() != null && orgEntity.getParentId() > 0) ? orgEntity.getParentId().toString():"";
        	OrgVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<OrgVO> child = parent.getChildren();
        		if(child != null) {
        			child.add(orgEntity);
        		}else{
        			List<OrgVO> children = new ArrayList<OrgVO>();
        			children.add(orgEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(orgEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
