package com.ejianc.foundation.workbench.element.visitor;

import com.ejianc.foundation.workbench.element.node.Cell;
import com.ejianc.foundation.workbench.element.node.Container;
import com.ejianc.foundation.workbench.element.node.Element;
import com.ejianc.foundation.workbench.element.node.WidgetBox;

import java.io.IOException;

public class ElementVisitor {

    private Appendable accumulation;

    private ContainerVisitor containerVisitor;
    private CellVisitor cellVisitor;
    private WidgetBoxVisitor widgetBoxVisitor;

    public ElementVisitor(Appendable accumulation) {
        this.accumulation = accumulation;

        containerVisitor = new ContainerVisitor();
        cellVisitor = new CellVisitor();
        widgetBoxVisitor = new WidgetBoxVisitor();
    }

    public void head(Element element) throws IOException {

        if (element instanceof Container) {
            containerVisitor.head((Container) element, accumulation);
        }

        if (element instanceof Cell) {
            cellVisitor.head((Cell) element, accumulation);

        }

        if (element instanceof WidgetBox) {
            widgetBoxVisitor.head((WidgetBox) element, accumulation);

        }
    }

    public void tail(Element element) throws IOException {
        if (element instanceof Container) {
            containerVisitor.tail((Container) element, accumulation);
        }

        if (element instanceof Cell) {
            cellVisitor.tail((Cell) element, accumulation);
        }

        if (element instanceof WidgetBox) {
            widgetBoxVisitor.tail((WidgetBox) element, accumulation);

        }

    }
}
