package com.ejianc.foundation.workbench.service;

import java.util.List;

import com.ejianc.foundation.workbench.bean.WidgetEntity;
import com.ejianc.foundation.workbench.vo.WidgetVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IWidgetService extends IBaseService<WidgetEntity> {

	/**
	 * 保存或更新小部件信息
	 *
	 * @param widgetVO
	 * @return
	 */
	WidgetVO save(WidgetVO widgetVO);

	/**
	 * 根据主键ID查询小部件信息
	 *
	 * @param id
	 * @return
	 */
	WidgetEntity getById(Long id);

	/**
	 * 根据widgetIds查询widgetList
	 * 
	 * @param widgetIds
	 * @return
	 */
	List<WidgetEntity> getWidgetByIds(String widgetIds);

	/**
	 * 查询列表
	 * 
	 * @param searchText
	 * @return
	 */
	List<WidgetEntity> queryWidgetList(String searchText, Long groupId);

    List<WidgetVO> queryListByGroupId(Long id);
}
