/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.oms.bean.TryoutEntity;
import com.ejianc.foundation.oms.mapper.TryoutMapper;
import com.ejianc.foundation.oms.service.ITryoutService;
import com.ejianc.foundation.oms.vo.TryoutVO;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.pm.encoder.UsernameSaltPasswordEncoder;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.PinYinUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.conn.ConnectTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TryoutServiceImpl
extends BaseServiceImpl<TryoutMapper, TryoutEntity>
implements ITryoutService {
    @Autowired
    private IUserService userService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public void saveTryout(TryoutVO tryoutVo) {
        TryoutEntity entity = (TryoutEntity)((Object)BeanMapper.map((Object)((Object)tryoutVo), TryoutEntity.class));
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
        }
        this.saveOrUpdate((Object)entity, false);
    }

    @Override
    public CommonResponse<String> assignUser(TryoutVO tryoutVO) {
        Long tenantId = 888888L;
        OrgVO orgVO = this.orgService.findOrgByTenantId(tenantId);
        Long orgId = orgVO.getId();
        UserVO userVO = new UserVO();
        userVO.setTenantId(tenantId);
        userVO.setOrgId(orgId);
        userVO.setUserName(tryoutVO.getUserName());
        String code = "sy_" + PinYinUtil.getEachFirstSpell(tryoutVO.getEnterpriseName().replace("\u6709\u9650", "").replace("\u516c\u53f8", "").replace("\u8d23\u4efb", ""));
        boolean flag = true;
        Integer i = 1;
        while (flag) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"user_code", (Object)code);
            List list = this.userService.list((Wrapper)queryWrapper);
            if (list != null && list.size() > 0) {
                Integer j;
                if (i == 1) {
                    code = code + i;
                } else {
                    j = i - 1;
                    code = code.replace(j.toString(), i.toString());
                }
                j = i;
                Integer n = i = Integer.valueOf(i + 1);
                continue;
            }
            flag = false;
            break;
        }
        userVO.setUserCode(code);
        PasswordUtils.setSalt(userVO);
        UsernameSaltPasswordEncoder encoder = new UsernameSaltPasswordEncoder(code, userVO.getSalt());
        String encryptedPassword = encoder.encode(code);
        userVO.setPassword(encryptedPassword);
        userVO.setUserState(Integer.valueOf(1));
        userVO.setTypeId(Integer.valueOf(2));
        userVO.setPwdStartTime(new Date());
        userVO.setRegistTime(new Date());
        UserEntity userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
        this.userService.saveOrUpdate((Object)userEntity, false);
        EmployeeVO employeeVO = new EmployeeVO();
        employeeVO.setName(userEntity.getUserName());
        employeeVO.setCode("SY-" + userEntity.getId());
        employeeVO.setEmployeeType(Integer.valueOf(1));
        employeeVO.setSex(Integer.valueOf(1));
        employeeVO.setMobilePhone(userEntity.getUserMobile());
        employeeVO.setOrgName(orgVO.getName());
        employeeVO.setOrgId(orgId);
        employeeVO.setTenantId(tenantId);
        employeeVO.setState(Integer.valueOf(1));
        employeeVO.setDr(BaseVO.DR_UNDELETE);
        employeeVO.setUserId(userEntity.getId());
        employeeVO.setId(userEntity.getId());
        employeeVO.setSequence(Integer.valueOf(1));
        employeeVO.setWorkTime(new Date());
        EmployeeEntity dbEntity = (EmployeeEntity)((Object)BeanMapper.map((Object)employeeVO, EmployeeEntity.class));
        this.employeeService.saveOrUpdate((Object)dbEntity, false);
        JobEntity jobVO = new JobEntity();
        jobVO.setProperty(JobVO.JOB_TYPE_MAIN);
        jobVO.setEmployeeId(employeeVO.getId());
        jobVO.setCurState(JobVO.STATE_ACTIVE);
        jobVO.setJobStartTime(employeeVO.getWorkTime());
        jobVO.setOrgId(employeeVO.getOrgId());
        jobVO.setDeptId(employeeVO.getDeptId());
        jobVO.setPostId(employeeVO.getPostId());
        jobVO.setDr(BaseVO.DR_UNDELETE);
        jobVO.setTenantId(employeeVO.getTenantId());
        this.jobService.saveOrUpdate((Object)jobVO, false);
        TryoutEntity tryoutEntity = (TryoutEntity)((Object)this.getById(tryoutVO.getId()));
        tryoutEntity.setUserCode(userEntity.getUserCode());
        tryoutEntity.setUserId(userEntity.getId());
        this.saveOrUpdate((Object)tryoutEntity, false);
        QueryWrapper roleWrapper = new QueryWrapper();
        roleWrapper.eq((Object)"dr", (Object)0);
        roleWrapper.eq((Object)"code", (Object)"SY-ROLE");
        roleWrapper.eq((Object)"tenant_id", (Object)tenantId);
        RoleEntity roleEntity = (RoleEntity)((Object)this.roleService.getOne((Wrapper)roleWrapper));
        if (roleEntity != null) {
            ArrayList<RoleUserRelationEntity> data = new ArrayList<RoleUserRelationEntity>();
            RoleUserRelationEntity roleUserRelation = new RoleUserRelationEntity();
            roleUserRelation.setAuthOrgId(orgId);
            roleUserRelation.setEmployeeId(employeeVO.getId());
            roleUserRelation.setJobId(jobVO.getId());
            roleUserRelation.setRoleId(roleEntity.getId());
            roleUserRelation.setUserId(userEntity.getId());
            roleUserRelation.setTenantId(tenantId);
            data.add(roleUserRelation);
            this.roleUserRelationService.saveRoleUser(data);
        }
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)tryoutVO.getPhone());
        messageParam.put("templateCode", (Object)"SMS_199774063");
        JSONObject params = new JSONObject();
        params.put("userName", (Object)code);
        params.put("userPassword", (Object)code);
        messageParam.put("params", (Object)params);
        String messageUrl = this.environmentTools.getBaseHost() + "ejc-message-web/no_auth/sms/sendMessage";
        try {
            String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
            CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (response.isSuccess()) {
                return CommonResponse.success((String)"\u5206\u914d\u8d26\u6237\u6210\u529f,\u5e76\u5df2\u53d1\u9001\u77ed\u4fe1");
            }
        }
        catch (ConnectTimeoutException e) {
            e.printStackTrace();
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u5206\u914d\u8d26\u6237\u6210\u529f");
    }

    @Override
    public CommonResponse<String> frozen(Long id) {
        TryoutEntity entity = (TryoutEntity)((Object)this.getById(id));
        entity.setTryoutState("1");
        this.saveOrUpdate((Object)entity, false);
        EmployeeVO vo = this.employeeService.queryEmployeeByUserId(entity.getUserId());
        vo.setState(Integer.valueOf(0));
        this.employeeService.enabledEmployeeState(vo);
        return CommonResponse.success((String)"\u51bb\u7ed3\u8d26\u6237\u6210\u529f");
    }

    @Override
    public CommonResponse<String> recovery(Long id) {
        TryoutEntity entity = (TryoutEntity)((Object)this.getById(id));
        entity.setTryoutState(null);
        this.saveOrUpdate((Object)entity, false);
        EmployeeVO vo = this.employeeService.queryEmployeeByUserId(entity.getUserId());
        vo.setState(Integer.valueOf(1));
        this.employeeService.enabledEmployeeState(vo);
        return CommonResponse.success((String)"\u6062\u590d\u8d26\u6237\u6210\u529f");
    }
}

