/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.operatelog.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.operatelog.service.IOperateLogService;
import com.ejianc.foundation.operatelog.vo.OperateLogVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperateLogServiceImpl
implements IOperateLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String ASC = "asc";
    private static final String INDEX_NAME = "ejclogspace";
    @Autowired(required=false)
    private RestHighLevelClient client;

    @Override
    public IPage<OperateLogVO> queryPageList(QueryParam queryParam) {
        IPage<OperateLogVO> page = new IPage<OperateLogVO>();
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)((String)entry.getKey()), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)param.getValue().toString()));
                continue;
            }
            if ("in".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)param.getValue().toString().split(",")));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).lte((Object)param.getValue().toString()));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (orderMap != null && !orderMap.isEmpty()) {
            GetIndexRequest request = new GetIndexRequest(new String[]{INDEX_NAME});
            try {
                GetIndexResponse response = this.client.indices().get(request, RequestOptions.DEFAULT);
                Map mappings = ((MappingMetaData)response.getMappings().get(INDEX_NAME)).getSourceAsMap();
                Map properties = (Map)mappings.get("properties");
                for (Map.Entry entry : orderMap.entrySet()) {
                    Map fieldMapping = (Map)properties.get(entry.getKey());
                    if ("text".equals(fieldMapping.get("type").toString())) {
                        sourceBuilder.sort(new FieldSortBuilder((String)entry.getKey() + ".keyword").order(ASC.equals(((String)entry.getValue()).toLowerCase()) ? SortOrder.ASC : SortOrder.DESC));
                        continue;
                    }
                    sourceBuilder.sort(new FieldSortBuilder((String)entry.getKey()).order(ASC.equals(((String)entry.getValue()).toLowerCase()) ? SortOrder.ASC : SortOrder.DESC));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        sourceBuilder.size(queryParam.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            page = this.queryPage(searchRequest);
        }
        catch (IOException e) {
            try {
                page = this.queryPage(searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return page;
    }

    @Override
    public Boolean checkAndCreateESIndex() {
        this.logger.info("\u5224\u65ad\u7d22\u5f15{}\u662f\u5426\u5b58\u5728.........", (Object)INDEX_NAME);
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{INDEX_NAME});
            boolean exist = this.client.indices().exists(request, RequestOptions.DEFAULT);
            if (!exist) {
                this.logger.info("\u7d22\u5f15{}\u4e0d\u5b58\u5728.........\u65b0\u5efa", (Object)INDEX_NAME);
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(INDEX_NAME);
                createIndexRequest.settings(Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 1));
                XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties");
                mapping.startObject("id").field("type", "text").endObject();
                mapping.startObject("content").field("type", "text").startObject("fields").startObject("keyword").field("type", "keyword").field("ignore_above", 1200).endObject().endObject().endObject();
                mapping.startObject("paramContent").field("type", "text").startObject("fields").startObject("keyword").field("type", "keyword").field("ignore_above", 1200).endObject().endObject().endObject();
                mapping.startObject("operateTime").field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                mapping.startObject("operateUser").field("type", "text").startObject("fields").startObject("keyword").field("type", "keyword").field("ignore_above", 1200).endObject().endObject().endObject();
                mapping.startObject("operateUserName").field("type", "text").startObject("fields").startObject("keyword").field("type", "keyword").field("ignore_above", 1200).endObject().endObject().endObject();
                mapping.endObject().endObject();
                createIndexRequest.mapping(mapping);
                createIndexRequest.alias(new Alias("API\u8c03\u7528\u65e5\u5fd7"));
                CreateIndexResponse response = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
                boolean acknowledged = response.isAcknowledged();
                if (!acknowledged) {
                    response = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
                    acknowledged = response.isAcknowledged();
                    if (!acknowledged) {
                        this.logger.info("\u521b\u5efa API\u8c03\u7528\u65e5\u5fd7 ES\u5e93\u5931\u8d25\uff01");
                        return false;
                    }
                    this.logger.info("\u7d22\u5f15{}\u4e0d\u5b58\u5728.........\u65b0\u5efa\u6210\u529f", (Object)INDEX_NAME);
                }
            } else {
                this.logger.info("\u7d22\u5f15{}\u5b58\u5728.........", (Object)INDEX_NAME);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<OperateLogVO> exportData(List<String> param) {
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"operateTime").from((Object)param.get(0)).to((Object)param.get(1)).includeLower(true).includeUpper(true));
        sourceBuilder.query((QueryBuilder)boolQuery);
        GetIndexRequest request = new GetIndexRequest(new String[]{INDEX_NAME});
        try {
            GetIndexResponse response = this.client.indices().get(request, RequestOptions.DEFAULT);
            Map mappings = ((MappingMetaData)response.getMappings().get(INDEX_NAME)).getSourceAsMap();
            Map properties = (Map)mappings.get("properties");
            Map fieldMapping = (Map)properties.get("operateTime");
            if ("text".equals(fieldMapping.get("type").toString())) {
                sourceBuilder.sort(new FieldSortBuilder("operateTime.keyword").order(SortOrder.DESC));
            } else {
                sourceBuilder.sort(new FieldSortBuilder("operateTime").order(SortOrder.DESC));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        List<Object> list = new ArrayList();
        try {
            list = this.queryList(searchRequest);
        }
        catch (IOException e) {
            try {
                list = this.queryList(searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u5bfc\u51fa\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return list;
    }

    private IPage<OperateLogVO> queryPage(SearchRequest searchRequest) throws IOException {
        Page page = new Page();
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            list.add(JSON.parseObject((String)sourceAsString, OperateLogVO.class));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }

    private List<OperateLogVO> queryList(SearchRequest searchRequest) throws IOException {
        ArrayList<OperateLogVO> list = new ArrayList<OperateLogVO>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            list.add((OperateLogVO)JSON.parseObject((String)sourceAsString, OperateLogVO.class));
        }
        return list;
    }
}

