/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.workbench.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.service.impl.TenantMenuServiceImpl;
import com.ejianc.foundation.workbench.bean.MenuCategoryEntity;
import com.ejianc.foundation.workbench.bean.MenuEntity;
import com.ejianc.foundation.workbench.mapper.MenuCategoryMapper;
import com.ejianc.foundation.workbench.service.IMenuCategoryService;
import com.ejianc.foundation.workbench.service.IMenuService;
import com.ejianc.foundation.workbench.vo.MenuCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuCategoryServiceImpl
extends BaseServiceImpl<MenuCategoryMapper, MenuCategoryEntity>
implements IMenuCategoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantMenuServiceImpl.class);
    private static final String MENU_CATEGORY_BILL_CODE = "IDM_MENU_CATEGORY";
    private static final String MENU_BILL_CODE = "IDM_MENU";
    @Autowired
    private MenuCategoryMapper menuCategoryMapper;
    @Autowired
    private IMenuService menuItemService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<MenuCategoryVO> copy(MenuCategoryVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getCopyId() == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u8981\u590d\u5236\u7684\u5206\u7c7b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        MenuCategoryEntity entity = (MenuCategoryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MenuCategoryEntity.class));
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isBlank((String)saveOrUpdateVO.getCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(MENU_CATEGORY_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        MenuCategoryVO vo = (MenuCategoryVO)BeanMapper.map((Object)((Object)entity), MenuCategoryVO.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"menu_category_id", (Object)saveOrUpdateVO.getCopyId());
        wrapper.eq((Object)"tenant_id", (Object)999999L);
        List<MenuEntity> menuList = this.menuItemService.list((Wrapper)wrapper);
        if (menuList != null && menuList.size() > 0) {
            menuList = this.createTreeData(menuList);
            HashMap<Long, String> innerCodeMap = new HashMap<Long, String>();
            this.dealInnerCode(menuList, innerCodeMap, null);
            ArrayList<MenuEntity> entitys = new ArrayList<MenuEntity>();
            this.dealMenu(entitys, menuList);
            CommonResponse menuResponse = this.billCodeApi.getCodeBatchByRuleCode(MENU_BILL_CODE, Long.valueOf(999999L), entitys.size());
            for (int i = 0; i < entitys.size(); ++i) {
                List codeResponse = (List)menuResponse.getData();
                MenuEntity en = (MenuEntity)((Object)entitys.get(i));
                en.setMenuCategoryId(entity.getId());
                en.setCode((String)codeResponse.get(i));
            }
            this.menuItemService.saveOrUpdateBatch(entitys, entitys.size(), false);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private void dealMenu(List<MenuEntity> result, List<MenuEntity> entitys) {
        for (MenuEntity entity : entitys) {
            result.add(entity);
            if (entity.getChildren() == null || entity.getChildren().size() <= 0) continue;
            this.dealMenu(result, entity.getChildren());
        }
    }

    private void dealInnerCode(List<MenuEntity> vos, Map<Long, String> innerCodeMap, Long pid) {
        for (MenuEntity vo : vos) {
            vo.setId(IdWorker.getId());
            vo.setParentId(pid);
            if (vo.getParentId() == null) {
                vo.setInnerCode(vo.getId().toString());
                innerCodeMap.put(vo.getId(), vo.getId().toString());
            } else {
                String parentInnerCode = innerCodeMap.get(vo.getParentId());
                if (StringUtils.isNotBlank((String)parentInnerCode)) {
                    String innercode = parentInnerCode + "|" + vo.getId().toString();
                    innerCodeMap.put(vo.getId(), innercode);
                } else {
                    innerCodeMap.put(vo.getId(), vo.getId().toString());
                }
            }
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.dealInnerCode(vo.getChildren(), innerCodeMap, vo.getId());
        }
    }

    public List<MenuEntity> createTreeData(List<MenuEntity> list) {
        ArrayList<MenuEntity> resp = new ArrayList<MenuEntity>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, MenuEntity> listMap = new HashMap<String, MenuEntity>();
        for (MenuEntity menuEntity : list) {
            listMap.put(menuEntity.getId().toString(), menuEntity);
        }
        for (int i = 0; i < list.size(); ++i) {
            MenuEntity menuEntity;
            menuEntity = list.get(i);
            String parentId = menuEntity.getParentId() != null && menuEntity.getParentId() > 0L ? menuEntity.getParentId().toString() : "";
            MenuEntity parent = (MenuEntity)((Object)listMap.get(parentId));
            if (parent != null) {
                List<MenuEntity> child = parent.getChildren();
                if (child != null) {
                    child.add(menuEntity);
                    continue;
                }
                ArrayList<MenuEntity> children = new ArrayList<MenuEntity>();
                children.add(menuEntity);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(menuEntity.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((MenuEntity)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

