package com.ejianc.foundation.workbench.mapper;

import com.ejianc.foundation.workbench.vo.LayoutOrgVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.workbench.bean.LayoutOrgRelationEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

import java.util.List;
import java.util.Map;

@Mapper
public interface LayoutOrgRelationMapper extends BaseCrudMapper<LayoutOrgRelationEntity> {

    /**
     * 查询匹配条件布局组织关系总数
     *
     * @param paramMap
     * @return
     */
    Long count(Map<String, Object> paramMap);

    /**
     * 查询布局组织列表
     *
     * @param paramMap
     * @return
     */
    List<LayoutOrgVO> page(Map<String, Object> paramMap);

    /**
     * 查询租户的所有组织级部门关系
     * 
     * @param tenantId
     * @return
     */
	List<LayoutOrgVO> queryListByTenantId(@Param("tenantId") Long tenantId);

	/**
	 * 根据主键删除数据
	 * 
	 * @param ids
	 */
	void deleteByIds(@Param("ids") String ids);

	/**
	 * 根据布局Id以及组织Id删除对应的布局关系
	 *
	 * @param layoutIds
	 * @param orgId
	 */
    void deleteByOrgIdAndLayoutIds(@Param(value = "layoutIds") List<Long> layoutIds,@Param(value = "orgId")  Long orgId);
}
