/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.oms.bean.ComboDoorEntity;
import com.ejianc.foundation.oms.mapper.ComboDoorMapper;
import com.ejianc.foundation.oms.service.IComboDoorService;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.vo.ComboDoorVO;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.foundation.workbench.bean.LayoutOrgRelationEntity;
import com.ejianc.foundation.workbench.service.ILayoutOrgRelationService;
import com.ejianc.foundation.workbench.service.ILayoutService;
import com.ejianc.foundation.workbench.vo.LayoutVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.BuilderException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComboDoorServiceImpl
extends BaseServiceImpl<ComboDoorMapper, ComboDoorEntity>
implements IComboDoorService {
    private static final String LAYOUT_BILL_CODE = "IDM_LAYOUT";
    @Autowired
    private ComboDoorMapper mapper;
    @Autowired
    private IComboEnterpriseService comboEnterpriseService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILayoutService layoutService;
    @Autowired
    private ILayoutOrgRelationService layoutOrgRelationService;
    @Autowired
    private IOrgService orgService;

    @Override
    public IPage<LayoutVO> queryPage(Map<String, Object> params, boolean isEs) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        Long count = this.mapper.countByProPerties(params);
        Page page = new Page();
        if (count > 0L) {
            List<LayoutVO> doorVO = this.mapper.queryPageByProperties(params);
            page.setRecords(doorVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<ComboDoorEntity> doorVOs) {
        for (ComboDoorEntity doorVO : doorVOs) {
            this.mapper.deleteAuthDoor(doorVO.getComboId(), doorVO.getDoorId());
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<String> saveComboDoor(ComboDoorVO comboDoorVO) {
        List<Long> tenantIds;
        if (comboDoorVO.getComboId() == null) return CommonResponse.error((String)"\u5957\u9910id\u4e0d\u80fd\u4e3a\u7a7a");
        List<LayoutVO> doorVO = comboDoorVO.getDoorVO();
        if (doorVO == null || doorVO.size() <= 0) return CommonResponse.error((String)"\u4fdd\u5b58\u95e8\u6237\u6570\u636e\u4e3a\u7a7a");
        ArrayList<ComboDoorEntity> comboDoorList = new ArrayList<ComboDoorEntity>();
        for (LayoutVO vo : doorVO) {
            ComboDoorEntity entity = new ComboDoorEntity();
            entity.setDoorId(vo.getId());
            entity.setComboId(comboDoorVO.getComboId());
            comboDoorList.add(entity);
        }
        if (comboDoorList.size() > 0) {
            this.saveOrUpdateBatch(comboDoorList, comboDoorList.size(), false);
        }
        if ((tenantIds = this.comboEnterpriseService.queryTenantIdBycomboId(comboDoorVO.getComboId())) == null || tenantIds.size() <= 0) return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String authTime = formatter.format(new Date());
        for (Long tenantId : tenantIds) {
            List<LayoutVO> layoutVOs = this.mapper.queryDoorByEnterpriseId(tenantId);
            if (layoutVOs == null || layoutVOs.size() == 0) {
                for (LayoutVO layoutVO : doorVO) {
                    OrgVO orgVo = this.orgService.findOrgByTenantId(tenantId);
                    EmployeeVO employeeVO = this.employeeService.querySuperEmployeeByTenantId(tenantId);
                    if (employeeVO == null) {
                        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u79df\u6237:" + tenantId + "\u7684\u8d85\u7ea7\u7ba1\u7406\u5458\u4fe1\u606f");
                    }
                    LayoutEntity entity = (LayoutEntity)((Object)BeanMapper.map((Object)layoutVO, LayoutEntity.class));
                    CommonResponse layoutResponse = this.billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, tenantId);
                    if (!layoutResponse.isSuccess()) {
                        throw new BuilderException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    entity.setCode((String)layoutResponse.getData());
                    entity.setSourceId(layoutVO.getId());
                    entity.setId(null);
                    entity.setCreateTime(null);
                    entity.setCreateUserCode(null);
                    entity.setUpdateTime(null);
                    entity.setUpdateUserCode(null);
                    entity.setTenantId(tenantId);
                    entity.setOrgId(orgVo.getId());
                    this.layoutService.saveOrUpdate((Object)entity, false);
                    LayoutOrgRelationEntity relationEntity = new LayoutOrgRelationEntity();
                    relationEntity.setAuthTime(authTime);
                    relationEntity.setAuthUserId(employeeVO.getUserId());
                    relationEntity.setLayoutId(entity.getId());
                    relationEntity.setOrgId(orgVo.getId());
                    relationEntity.setLimitFlag(2);
                    relationEntity.setTenantId(tenantId);
                    this.layoutOrgRelationService.saveOrUpdate((Object)relationEntity, false);
                }
                continue;
            }
            if (layoutVOs == null || layoutVOs.size() <= 0) continue;
            HashMap layoutMap = new HashMap();
            layoutVOs.forEach(e -> layoutMap.put(e.getSourceId(), e));
            for (LayoutVO layoutVO : doorVO) {
                if (layoutMap.get(layoutVO.getId()) != null) continue;
                OrgVO orgVo = this.orgService.findOrgByTenantId(tenantId);
                EmployeeVO employeeVO = this.employeeService.querySuperEmployeeByTenantId(tenantId);
                if (employeeVO == null) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u79df\u6237:" + tenantId + "\u7684\u8d85\u7ea7\u7ba1\u7406\u5458\u4fe1\u606f");
                }
                LayoutEntity entity = (LayoutEntity)((Object)BeanMapper.map((Object)layoutVO, LayoutEntity.class));
                CommonResponse layoutResponse = this.billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, tenantId);
                if (!layoutResponse.isSuccess()) {
                    throw new BuilderException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                entity.setCode((String)layoutResponse.getData());
                entity.setSourceId(layoutVO.getId());
                entity.setId(null);
                entity.setCreateTime(null);
                entity.setCreateUserCode(null);
                entity.setUpdateTime(null);
                entity.setUpdateUserCode(null);
                entity.setTenantId(tenantId);
                entity.setOrgId(orgVo.getId());
                this.layoutService.saveOrUpdate((Object)entity, false);
                LayoutOrgRelationEntity relationEntity = new LayoutOrgRelationEntity();
                relationEntity.setAuthTime(authTime);
                relationEntity.setAuthUserId(employeeVO.getUserId());
                relationEntity.setLayoutId(entity.getId());
                relationEntity.setOrgId(orgVo.getId());
                relationEntity.setLimitFlag(2);
                relationEntity.setTenantId(tenantId);
                this.layoutOrgRelationService.saveOrUpdate((Object)relationEntity, false);
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }
}

