package com.ejianc.foundation.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.vo.DeptVO;

public class DeptAsTree {
	
	public static List<DeptEntity> createTreeData(List<DeptEntity> list) {
		List<DeptEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, DeptEntity> listMap = new HashMap<>();
		for(DeptEntity DeptEntity:list) {
			listMap.put(DeptEntity.getId().toString(), DeptEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	DeptEntity DeptEntity = list.get(i);
        	String parentId = (DeptEntity.getPid() != null && DeptEntity.getPid() > 0) ? DeptEntity.getPid().toString():"";
        	DeptEntity parent = listMap.get(parentId);
        	if(parent != null) {
        		List<DeptEntity> child = parent.getChildren();
        		if(child != null) {
        			child.add(DeptEntity);
        		}else{
        			List<DeptEntity> children = new ArrayList<DeptEntity>();
        			children.add(DeptEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(DeptEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}
	
	public static List<DeptVO> createTreeDataVO(List<DeptVO> list) {
		List<DeptVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, DeptVO> listMap = new HashMap<>();
		for(DeptVO DeptEntity:list) {
			listMap.put(DeptEntity.getId().toString(), DeptEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	DeptVO DeptEntity = list.get(i);
        	String parentId = (DeptEntity.getPid() != null && DeptEntity.getPid() > 0) ? DeptEntity.getPid().toString():"";
        	DeptVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<DeptVO> child = parent.getChildren();
        		if(child != null) {
        			child.add(DeptEntity);
        		}else{
        			List<DeptVO> children = new ArrayList<DeptVO>();
        			children.add(DeptEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(DeptEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
