package com.ejianc.foundation.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.workbench.vo.MenuItemVO;

public class MenuAsTree {
	
	public static List<MenuItemVO> createTreeData(List<MenuItemVO> list) {
		List<MenuItemVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, MenuItemVO> listMap = new HashMap<>();
		for(MenuItemVO item:list) {
			listMap.put(item.getId().toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	MenuItemVO item = list.get(i);
        	String parentId = (item.getParentId() != null && item.getParentId() > 0) ? item.getParentId().toString():"";
        	MenuItemVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<MenuItemVO> child = parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<MenuItemVO> children = new ArrayList<MenuItemVO>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
