package com.ejianc.foundation.weixinpay.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.util.Date;

/**
 * 微信支付订单表
 * 
 */
@TableName("ejc_idm_weixinpay_order")
public class WeixinpayOrderEntity extends BaseEntity {

	private static final long serialVersionUID = 4965615188065927421L;

	@TableField(value = "mchid")
	private String mchid; // 直连商户号

	@TableField(value = "order_no")
	private String orderNo; // 订单号

	@TableField(value = "type")
	private String type; // 业务类型

	@TableField(value = "num")
	private Integer num; // 开通条数

	@TableField(value = "money")
	private Integer money;// 支付金额（分）

	@TableField(value = "state")
	private String state; // 支付状态（SUCCESS：支付成功,REFUND：转入退款,NOTPAY：未支付,CLOSED：已关闭,REVOKED：已撤销（付款码支付）,USERPAYING：用户支付中（付款码支付）,PAYERROR：支付失败(其他原因，如银行返回失败)）

	@TableField(value = "invoice_state")
	private String invoiceState; // 发票状态

	public String getMchid() {
		return mchid;
	}

	public void setMchid(String mchid) {
		this.mchid = mchid;
	}

	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getNum() {
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}

	public Integer getMoney() {
		return money;
	}

	public void setMoney(Integer money) {
		this.money = money;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getInvoiceState() {
		return invoiceState;
	}

	public void setInvoiceState(String invoiceState) {
		this.invoiceState = invoiceState;
	}

}
