package com.ejianc.foundation.tenant.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.mapper.TenantMapper;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class TenantServiceImpl extends BaseServiceImpl<TenantMapper, TenantEntity> implements ITenantService {
	
	@Autowired
	private TenantMapper tenantMapper;

	@Override
	public TenantVO selectById(Long tenantId) {
		TenantEntity entity = this.getById(tenantId);
		if(entity != null) {
			TenantVO tenantVo = BeanMapper.map(entity, TenantVO.class);
			return tenantVo;
		}
		return null;
	}

	@Override
	public List<TenantVO> queryCurrentUserSpace(Long userId) {
		List<TenantEntity> tenantEntities = tenantMapper.queryCurrentUserSpace(userId);
		if(tenantEntities != null && tenantEntities.size() > 0) {
			return BeanMapper.mapList(tenantEntities, TenantVO.class);
		}
		return null;
	}

	@Override
	public List<Long> getAllValidTenantId() {
		List<Long> tenantIds = tenantMapper.getAllValidTenantId();
		return tenantIds;
	}

}
