/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.utils.weixinpay;

import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Map;
import java.util.Random;
import okhttp3.HttpUrl;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPayApiV3Util {
    private static Logger logger = LoggerFactory.getLogger(WechatPayApiV3Util.class);
    private static final String WechatPaySerial = "https://api.mch.weixin.qq.com/v3/certificates";

    public static String getToken(String method, String url, String body, String merchantId, String certSerialNo, String privateKey) throws Exception {
        String signStr = "";
        HttpUrl httpurl = HttpUrl.parse((String)url);
        String nonceStr = WechatPayApiV3Util.getRandomString(32);
        long timestamp = System.currentTimeMillis() / 1000L;
        if (StringUtils.isEmpty((CharSequence)body)) {
            body = "";
        }
        String message = WechatPayApiV3Util.buildMessage(method, httpurl, timestamp, nonceStr, body);
        String signature = WechatPayApiV3Util.sign(message.getBytes("utf-8"), privateKey);
        signStr = "mchid=\"" + merchantId + "\",nonce_str=\"" + nonceStr + "\",timestamp=\"" + timestamp + "\",serial_no=\"" + certSerialNo + "\",signature=\"" + signature + "\"";
        return signStr;
    }

    public static String buildMessage(String method, HttpUrl url, long timestamp, String nonceStr, String body) {
        String canonicalUrl = url.encodedPath();
        if (url.encodedQuery() != null) {
            canonicalUrl = canonicalUrl + "?" + url.encodedQuery();
        }
        return method + "\n" + canonicalUrl + "\n" + timestamp + "\n" + nonceStr + "\n" + body + "\n";
    }

    public static String sign(byte[] message, String privateKey) throws Exception {
        Signature sign = Signature.getInstance("SHA256withRSA");
        sign.initSign(WechatPayApiV3Util.getPrivateKey(privateKey));
        sign.update(message);
        return Base64.encodeBase64String((byte[])sign.sign());
    }

    public static PrivateKey getPrivateKey(String content) throws IOException {
        try {
            String privateKey = content.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey)));
        }
        catch (NoSuchAlgorithmException e) {
            logger.info("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA\uff01------{}", (Throwable)e);
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA", e);
        }
        catch (InvalidKeySpecException e) {
            logger.info("\u65e0\u6548\u7684\u5bc6\u94a5\u683c\u5f0f\uff01------{}", (Throwable)e);
            throw new RuntimeException("\u65e0\u6548\u7684\u5bc6\u94a5\u683c\u5f0f");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate getCertificate() throws IOException {
        String APICLIENT_CERT = "pem/apiclient_cert.pem";
        InputStream fis = WechatPayApiV3Util.class.getClassLoader().getResourceAsStream(APICLIENT_CERT);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
            cert.checkValidity();
            X509Certificate x509Certificate = cert;
            return x509Certificate;
        }
        catch (CertificateExpiredException e) {
            logger.info("\u8bc1\u4e66\u5df2\u8fc7\u671f\uff01------{}", (Throwable)e);
            throw new RuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", e);
        }
        catch (CertificateNotYetValidException e) {
            logger.info("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548\uff01------{}", (Throwable)e);
            throw new RuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", e);
        }
        catch (CertificateException e) {
            logger.info("\u65e0\u6548\u7684\u8bc1\u4e66\u6587\u4ef6\uff01------{}", (Throwable)e);
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66\u6587\u4ef6", e);
        }
    }

    public static String getRandomString(int length) {
        SecureRandom random = new SecureRandom();
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            int number = random.nextInt(3);
            long result = 0L;
            switch (number) {
                case 0: {
                    result = Math.round(Math.random() * 25.0 + 65.0);
                    sb.append(String.valueOf((char)result));
                    continue block5;
                }
                case 1: {
                    result = Math.round(Math.random() * 25.0 + 97.0);
                    sb.append(String.valueOf((char)result));
                    continue block5;
                }
                case 2: {
                    sb.append(String.valueOf(new Random().nextInt(10)));
                }
            }
        }
        return sb.toString();
    }

    public static Map<String, Object> decryptFromResource(String resource, String apiV3Key, Integer type) {
        String msg = type == 1 ? "\u652f\u4ed8\u6210\u529f" : "\u9000\u6b3e\u6210\u529f";
        try {
            Map resourceMap = (Map)JSONObject.parseObject((String)resource, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            String ciphertext = (String)resourceMap.get("ciphertext");
            String nonce = (String)resourceMap.get("nonce");
            String associatedData = (String)resourceMap.get("associated_data");
            AesUtil aesUtil = new AesUtil(apiV3Key.getBytes(StandardCharsets.UTF_8));
            String resourceStr = aesUtil.decryptToString(associatedData.getBytes(StandardCharsets.UTF_8), nonce.getBytes(StandardCharsets.UTF_8), ciphertext);
            return (Map)JSONObject.parseObject((String)resourceStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            logger.info("\u56de\u8c03\u53c2\u6570\uff0c\u89e3\u5bc6\u5931\u8d25\uff01------{}", (Throwable)e);
            throw new RuntimeException("\u56de\u8c03\u53c2\u6570\uff0c\u89e3\u5bc6\u5931\u8d25\uff01");
        }
    }

    public static void main(String[] args) throws Exception {
        String method = "POST";
        JSONObject body = new JSONObject();
        body.put("mchid", (Object)"1519756431");
        body.put("out_trade_no", (Object)"H51217752501201407033dsd0001");
        body.put("appid", (Object)"wxa453c95adb68fcdc");
        body.put("description", (Object)"\u6d4b\u8bd5\u6d4b\u8bd5");
        body.put("notify_url", (Object)"https://weixin.qq.com/");
        JSONObject amount = new JSONObject();
        amount.put("total", (Object)1);
        amount.put("currency", (Object)"CNY");
        body.put("amount", (Object)amount);
        String url = "https://api.mch.weixin.qq.com/v3/pay/transactions/native";
        String mch_id = "1519756431";
        String token = WechatPayApiV3Util.getToken(method, url, body.toJSONString(), mch_id, "75831FE21DE9A7779EB4E63D8E6DBB3A9D7FF4ED", "D:\\WXCertUtil\\cert\\apiclient_key.pem");
        try {
            String result = ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header(Header.CONTENT_TYPE, "application/json")).header("ACCEPT", "application/json")).header("Authorization", "WECHATPAY2-SHA256-RSA2048 " + token)).body(body.toJSONString()).execute().body();
            if (result != null) {
                System.out.println("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u6210\u529f");
                System.out.println(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

