/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.tenant.bean.TenantMenuEntity;
import com.ejianc.foundation.tenant.mapper.TenantMenuMapper;
import com.ejianc.foundation.tenant.service.ITenantMenuService;
import com.ejianc.foundation.tenant.vo.TenantMenuVO;
import com.ejianc.foundation.workbench.vo.MenuItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="tenantMenuService")
public class TenantMenuServiceImpl
extends BaseServiceImpl<TenantMenuMapper, TenantMenuEntity>
implements ITenantMenuService {
    @Autowired
    private TenantMenuMapper tenantMenuMapper;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;

    @Override
    public List<MenuItemVO> queryTenantProperties(QueryParam param) {
        String code = null;
        String name = null;
        String mobile = null;
        Long tenantId = Long.parseLong(((Parameter)param.getParams().get("tenantId")).getValue().toString());
        if (param.getParams().get("code") != null) {
            code = String.valueOf(((Parameter)param.getParams().get("code")).getValue());
        }
        if (param.getParams().get("name") != null) {
            name = String.valueOf(((Parameter)param.getParams().get("name")).getValue());
        }
        if (param.getParams().get("mobile") != null) {
            mobile = String.valueOf(((Parameter)param.getParams().get("mobile")).getValue());
        }
        HashMap<Long, MenuItemVO> menuMap = new HashMap<Long, MenuItemVO>();
        List<MenuItemVO> menuList = this.queryMenuAll(tenantId, code, name);
        List<MenuItemVO> tenantList = this.tenantMenuMapper.queryTenantProperties(tenantId, null, mobile);
        for (MenuItemVO t : menuList) {
            for (MenuItemVO vo : tenantList) {
                if (!vo.getInnerCode().contains(t.getId() + "")) continue;
                menuMap.put(t.getId(), t);
            }
        }
        ArrayList<MenuItemVO> allList = new ArrayList<MenuItemVO>(menuMap.values());
        Collections.sort(allList, new Comparator<MenuItemVO>(){

            @Override
            public int compare(MenuItemVO arg0, MenuItemVO arg1) {
                return arg0.getSequence().compareTo(arg1.getSequence());
            }
        });
        return allList;
    }

    @Override
    public TenantMenuVO queryByMenuId(Long menuId) {
        TenantMenuVO vo = new TenantMenuVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"menu_id", (Object)menuId);
        List list = this.tenantMenuMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            TenantMenuEntity entity = (TenantMenuEntity)((Object)list.get(0));
            vo = (TenantMenuVO)BeanMapper.map((Object)((Object)entity), TenantMenuVO.class);
            return vo;
        }
        return vo;
    }

    public List<MenuItemVO> queryMenuAll(Long tenantId, String code, String name) {
        List<MenuItemVO> list = this.tenantMenuMapper.queryMenuAll(tenantId, null, null, code, name);
        return list;
    }

    @Override
    public List<TenantMenuVO> queryCurrentTenantMenuList(Long tenantId, String appIdStr) {
        List<TenantMenuVO> tenantMenuVos = this.tenantMenuMapper.queryCurrentTenantMenuList(appIdStr, tenantId);
        return tenantMenuVos;
    }
}

