package com.ejianc.foundation.orgcenter.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.mapper.DeptMapper;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;

@Service
public class DeptServiceImpl extends BaseServiceImpl<DeptMapper, DeptEntity> implements IDeptService {

	private static final String DEPT_BILL_CODE = "IDM_DEPT";
	
	@Autowired
	private IOrgService orgService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IJobService jobService;
	
	@Override
	public CommonResponse<String> save(DeptVO deptVo) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		
		DeptEntity entity = new DeptEntity();
		if(deptVo.getId()!=null && deptVo.getId() > 0){
			//修改
			DeptEntity oldEntity = super.getById(deptVo.getId());
			oldEntity.setManager(deptVo.getManager());
			oldEntity.setName(deptVo.getName());
			oldEntity.setShortName(deptVo.getShortName());
			oldEntity.setPhone(deptVo.getPhone());
			oldEntity.setSequence(deptVo.getSequence());
			oldEntity.setNote(deptVo.getNote());
			oldEntity.setOrgId(deptVo.getOrgId());
			oldEntity.setCode(deptVo.getCode());
			entity = BeanMapper.map(oldEntity, DeptEntity.class);
			this.saveOrUpdate(entity, false);
			return CommonResponse.success("修改成功");
		}else{
			//新增
			CommonResponse<String> deptResponse = billCodeApi.getCodeBatchByRuleCode(DEPT_BILL_CODE, tenantId);
			if(deptResponse.isSuccess()) {
				deptVo.setCode(deptResponse.getData());
			}else{
        		throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        	}
			deptVo.setDr(0);
			if("虚拟部门".equals(deptVo.getName())) {
				deptVo.setType(DeptVO.DEPT_TYPE_VIRTUAL);
			} else {
				deptVo.setType(DeptVO.DEPT_TYPE_NORMAL);
			}
			deptVo.setState(1);
			entity = BeanMapper.map(deptVo, DeptEntity.class);
			this.saveOrUpdate(entity, false);
			return CommonResponse.success("保存成功");
		}
	}

	@Override
	public CommonResponse<String> delete(List<Long> ids) {
		//查询该部门下有没有员工--查询任职信息表
		QueryWrapper<JobEntity> jobQuery = new QueryWrapper<>();
		jobQuery.in("dept_id", ids);
		jobQuery.eq("dr", BaseVO.DR_UNDELETE);
		List<JobEntity> jobList = jobService.list(jobQuery);
		if(jobList != null && jobList.size() > 0) {
			return CommonResponse.error("该部门下已有员工任职了，不允许删除");
		}else{
			super.removeByIds(ids);
			return CommonResponse.success("删除成功");
		}
	}

	@Override
	public JSONObject checkQuote(Long sourceOrgId, Long targetOrgId) {
		JSONObject json = new JSONObject();
		OrgVO orgVO = orgService.queryDetail(sourceOrgId);
		Map<String,Object> map = new HashMap<>();
		map.put("dr", BaseVO.DR_UNDELETE);
		map.put("tenant_id", InvocationInfoProxy.getTenantid());
		map.put("org_id", sourceOrgId);
		List<DeptEntity> sourceList = baseMapper.selectByMap(map);
		map.replace("org_id", targetOrgId);
		List<DeptEntity> targetList = baseMapper.selectByMap(map);
		//记录要引用的部门map，用于处理pid
		Map<String,DeptEntity> targetMap = new HashMap<>();
		if(sourceList!=null&&sourceList.size()>0){
			if(targetList!=null&&targetList.size()>0){
				targetList.stream().forEach((entity) -> {
					targetMap.put(entity.getName(), entity);
				});
				List<DeptEntity> addList = new ArrayList<>();
				String exitName = "";
				for(DeptEntity entity : sourceList){
					if(targetMap.get(entity.getName())!=null){
						exitName += ("["+ entity.getName() +"]");
					}else{
						addList.add(entity);
					}
				}
				json.put("code", "2");
				String msg = "[组织:"+orgVO.getName()+"]下有"+ sourceList.size() +"个部门可以引入,其中"+exitName+"与本组织部门重复的部门。"+
				"本次引入部门为";
				List<Long> deptIds = new ArrayList<>();
				for(DeptEntity entity : addList){
					msg += ("["+entity.getName()+"]");
					deptIds.add(entity.getId());
				}
                if(deptIds==null||deptIds.size()==0){
					msg += "空";
				}
				json.put("msg", msg);
				json.put("data", deptIds);
			}else{
				//目标组织下部门为空时直接将来源的部门校验通过
				json.put("code", "2");
				String msg = "[组织:"+orgVO.getName()+"]下有"+ sourceList.size() +"个部门可以引入,且不存在与本组织部门重复的部门。"+
				"本次引入部门为";
				List<Long> deptIds = new ArrayList<>();
				for(DeptEntity entity : sourceList){
					msg += ("["+entity.getName()+"]");
					deptIds.add(entity.getId());
				}
                json.put("msg", msg);
				json.put("data", deptIds);
			}
		}else{
			//来源组织下部门为空，不执行之后的引用操作
			json.put("code", "1");
			String msg = "[组织:"+orgVO.getName()+"]下没有部门可以引入到目标组织，请重新选择组织";
			json.put("msg", msg);
		}
		
		return json;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CommonResponse<String> quoteDept(Map<String, Object> params) {
		if(params.get("targetOrgId")!=null){
			if(params.get("deptIds")!=null){
				List<Long> deptIds = (List<Long>) params.get("deptIds");
				if(deptIds != null && deptIds.size() > 0) {
					List<DeptEntity> entitys = (List<DeptEntity>) this.listByIds(deptIds);
					Long tenantId = InvocationInfoProxy.getTenantid();
					//记录要引用的部门map，用于处理pid
					Map<Long,Long> corresponding = new HashMap<>();//新旧id对应关系
					for(DeptEntity entity : entitys){
						corresponding.put(entity.getId(), IdWorker.getId());
					}
					for(DeptEntity entity : entitys){
						CommonResponse<String> deptResponse = billCodeApi.getCodeBatchByRuleCode(DEPT_BILL_CODE, tenantId);
						if(deptResponse.isSuccess()) {
							entity.setCode(deptResponse.getData());
						}else{
			        		throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			        	}
						entity.setId(corresponding.get(entity.getId()));
						entity.setOrgId(Long.parseLong(params.get("targetOrgId").toString()));
						entity.setCreateTime(null);
						entity.setCreateUserCode(null);
						entity.setTenantId(InvocationInfoProxy.getTenantid());
						entity.setUpdateTime(null);
						entity.setUpdateUserCode(null);
						entity.setPid(corresponding.get(entity.getPid()));//父级若是不一起引用的话默认为根节点部门（拍平他）
					}
					this.saveBatch(entitys);
				}
			}else{
				return CommonResponse.error("引用部门不能为空");
			}
			
		}else{
			return CommonResponse.error("目标组织不能为空");
		}
		return CommonResponse.success("引入成功");
	}

	@Override
	public DeptEntity selectById(Long deptId) {
		return baseMapper.selectById(deptId);
	}

	@Override
	public List<DeptEntity> getAllByIds(List<Long> deptIds) {
		return baseMapper.selectBatchIds(deptIds);
	}

	@Override
	public List<DeptVO> queryDeptList(Map<String, Object> param) {
		return baseMapper.queryDeptList(param);
	}

	@Override
	public IPage<JSONObject> queryDeptUser(Integer pageNumber, Integer pageSize, String condition, Object o, String searchText) {
		JSONObject _con = JSONObject.parseObject(condition);

		Long deptId = _con.getLong("deptId");
		Long orgId = _con.getLong("orgId");

		long count = jobService.queryDeptUserCount(deptId,orgId,searchText);
		IPage<JSONObject> page = new Page<>(pageNumber,pageSize,0);
		if(count == 0){
			return page;
		}
		int startLine = (pageNumber-1)*pageSize;
		List<JSONObject> records = jobService.queryDeptUser(deptId,orgId,searchText,startLine,pageSize);
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

}
