package com.ejianc.foundation.orgcenter.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.mapper.JobMapper;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;

@Service("jobService")
public class JobServiceImpl extends BaseServiceImpl<JobMapper, JobEntity> implements IJobService {
	
	@Autowired
	private JobMapper jobMapper;

    @Autowired
    private IRoleUserRelationService roleUserRelationService;

    @Override
    public JobEntity getCurMainJob(Long employeeId) {
        QueryWrapper<JobEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        queryWrapper.eq("employee_id", employeeId);
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.eq("property", JobVO.JOB_TYPE_MAIN);
        queryWrapper.eq("cur_state", JobVO.STATE_ACTIVE);
        return baseMapper.selectOne(queryWrapper);
    }

    /**
     * 根据人员主键Id获取到人员所属租户主职工作记录
     *
     * @param employeeId
     * @param tenantId
     * @return
     */
    @Override
    public JobEntity getMainJob(Long employeeId, Long tenantId) {
        QueryWrapper<JobEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        queryWrapper.eq("employee_id", employeeId);
        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("property", JobVO.JOB_TYPE_MAIN);
        return baseMapper.selectOne(queryWrapper);
    }

    @Override
    public JobEntity getById(Long id) {
        return super.getById(id);
    }

    @Override
    public List<JobEntity> getEmployeesMainJob(List<Long> employeeIds, boolean isAll) {
        QueryWrapper<JobEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        queryWrapper.in("employee_id", employeeIds);
        queryWrapper.eq("property", JobVO.JOB_TYPE_MAIN);
        if(!isAll) {
            queryWrapper.eq("cur_state", JobVO.STATE_ACTIVE);
        }
        return baseMapper.selectList(queryWrapper);
    }

	@Override
	public List<JobVO> queryAllJobByEmployeeId(Long emplmoyeeId,Long tenantId) {
		 QueryWrapper<JobEntity> queryWrapper = new QueryWrapper<>();
         queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
         queryWrapper.eq("employee_id", emplmoyeeId);
         queryWrapper.eq("cur_state", JobVO.STATE_ACTIVE);
         queryWrapper.eq("tenant_id", tenantId);

         List<JobEntity> jobEntities = baseMapper.selectList(queryWrapper);
         if(jobEntities != null && jobEntities.size() > 0) {
        	 return BeanMapper.mapList(jobEntities, JobVO.class);
         }
		return null;
	}

	@Override
	public List<JobVO> queryPartJobsByEmployeeId(Long employeeId,Long tenantId) {
		 QueryWrapper<JobEntity> queryWrapper = new QueryWrapper<>();
         queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
         queryWrapper.eq("employee_id", employeeId);
         queryWrapper.eq("cur_state", JobVO.STATE_ACTIVE);
         queryWrapper.eq("tenant_id", tenantId);
         queryWrapper.eq("property", JobVO.JOB_TYPE_PARTTIME);

         List<JobEntity> jobEntities = baseMapper.selectList(queryWrapper);
         if(jobEntities != null && jobEntities.size() > 0) {
        	 return BeanMapper.mapList(jobEntities, JobVO.class);
         }
		return null;
	}

    /**
     * 查询 组织下的人员
     *
     * @param orgId
     * @param tenantId
     * @return
     */
    @Override
    public List<JobVO> queryJobsByOrgId(Long orgId) {
        QueryWrapper<JobEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        queryWrapper.eq("org_id", orgId);
        queryWrapper.eq("cur_state", JobVO.STATE_ACTIVE);

        List<JobEntity> jobEntities = baseMapper.selectList(queryWrapper);
        if(jobEntities != null && jobEntities.size() > 0) {
            return BeanMapper.mapList(jobEntities, JobVO.class);
        }
        return null;
    }

    @Override
    public void updateStateByEmpId(Long employeeId, Integer curState) {
        if(JobVO.STATE_INACTIVE.equals(curState)) {
            //查询对应的任职记录列表
            QueryWrapper<JobEntity> jobQuery = new QueryWrapper<>();
            jobQuery.eq("employee_id", employeeId);
            jobQuery.eq("tenant_id", InvocationInfoProxy.getTenantid());
            //停用时，只查询当前启用状态的兼职任职记录
            jobQuery.eq("cur_state", JobVO.STATE_ACTIVE);
            jobQuery.eq("property", JobVO.JOB_TYPE_PARTTIME);

            List<JobEntity> jobList = super.list(jobQuery);
            List<Long> jobIds = new ArrayList<>();

            if(CollectionUtils.isNotEmpty(jobList)) {
                //人员停用逻辑
                jobList.forEach(job -> {
                    jobIds.add(job.getId());
                    //设置职位为注销状态
                    job.setCurState(JobVO.STATE_INACTIVE);
                    //设置工作记录结束时间
                    job.setJobEndTime(new Timestamp(System.currentTimeMillis()));
                });

                //将兼职任职记录的授权信息删除掉
                if(CollectionUtils.isNotEmpty(jobIds)) {
                    //查询用户授权表
                    QueryParam roleUserQueryParam = new QueryParam();
                    roleUserQueryParam.getParams().put("employeeId", new Parameter(QueryParam.EQ, employeeId));
                    roleUserQueryParam.getParams().put("jobId", new Parameter(QueryParam.IN, jobIds));

                    List<RoleUserRelationEntity> roleUserRelations = roleUserRelationService.queryList(roleUserQueryParam, false);
                    //删除该工作记录对应的角色人员关系
                    if(CollectionUtils.isNotEmpty(roleUserRelations)) {
                        roleUserRelationService.delete(roleUserRelations.stream().map(r -> r.getId()).collect(Collectors.toList()));
                    }
                }

                super.saveOrUpdateBatch(jobList, jobList.size(), false);
            }
        }
    }

    /**
     * 根据人员ID删除所有的任职信息
     * 
     * @param employeeId
     */
	@Override
	public void deleteAllByEmployeeId(Long employeeId) {
		jobMapper.deleteAllByEmployeeId(employeeId);
	}

	@Override
	public void deleteAllPartJobByEmployeeId(Long employeeId) {
		jobMapper.deleteAllPartJobByEmployeeId(employeeId);
	}

	@Override
	public void updateDeptHeadNoByDeptId(Long deptId) {
		jobMapper.updateDeptHeadNoByDeptId(deptId);
	}

    @Override
    public Long queryDeptUserCount(Long deptId, Long orgId, String searchText) {
        return jobMapper.queryDeptUserCount(deptId,orgId,InvocationInfoProxy.getTenantid(), searchText);
    }

    @Override
    public List<JSONObject> queryDeptUser(Long deptId, Long orgId, String searchText, int startLine, Integer pageSize) {
        return jobMapper.queryDeptUser(deptId,orgId,InvocationInfoProxy.getTenantid(), searchText,startLine,pageSize);
    }

}
