package com.ejianc.foundation.permission.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.bean.CollectAppEntity;
import com.ejianc.foundation.permission.mapper.CollectAppMapper;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.ICollectAppService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class CollectAppServiceImpl extends BaseServiceImpl<CollectAppMapper, CollectAppEntity> implements ICollectAppService {
	
	@Value("${oms.tenantid}")
	private Long omsTenantid;

	@Autowired
	private PermissionCacheManage permissionCacheManage;
	@Autowired
	private CollectAppMapper collectAppMapper;
	@Autowired
	private IRoleService roleService;
	@Autowired
	private IUserService userService;
	@Autowired
	private IAppService appService;

	@Override
	public CommonResponse<List<AppVO>> queryListByUsrId() {
		Long userId = InvocationInfoProxy.getUserid();
		Long tenantId = InvocationInfoProxy.getTenantid();
		// 查询当前登录人是否是管理员或者超级管理员
		UserVO userVo = userService.selectById(userId);
		List<AppEntity> list = collectAppMapper.queryListByUsrId(userId, InvocationInfoProxy.getUserType(), tenantId);
		
		// 查出该用户的所有角色
		
		List<Long> userRoleIds = permissionCacheManage.getUserRoleCache(userId,tenantId);
		if (userRoleIds == null || userRoleIds.size() == 0) {
			userRoleIds = roleService.queryRoleIdstByCurrentUserId(userId, tenantId, null);
		}
		// 根据角色list查出其所有权限
		Map<Long, Long> appIdMap = new HashMap<>();
		if (userRoleIds != null && userRoleIds.size() > 0) {
			List<Long> appIds = null;
			for (Long roleId : userRoleIds) {
				appIds = permissionCacheManage.getRoleAppsCache(roleId);
				if (appIds != null && appIds.size() > 0) {
					for (Long appId : appIds) {
						appIdMap.put(appId, appId);
					}
				}
			}
		}
		// 判断是否为管理员
		List<Long> omAppIds = null;
		if (1 == userVo.getTypeId()) { // 超级管理员，则查出所有的运营类角色
			if ("999999".equals(tenantId.toString())) {
				omAppIds = appService.queryAllOperateList();
			} else {
				//查出所有套餐购买(没有停用/到期)的应用权限
				omAppIds = appService.queryAllHasAuthOmsOprateList();
			}
		} else { // 普通管理员，则查出具有权限的运营类角色
			if ("999999".equals(tenantId.toString())) {
				omAppIds = appService.queryAuthOperateList();
			} else {
				omAppIds = appService.queryAuthOperateOmsList();
			}
		}
		if (omAppIds != null) {
			for (Long omAppId : omAppIds) {
				if (!appIdMap.containsKey(omAppId)) {
					appIdMap.put(omAppId, omAppId);
				}
			}
		}
				
		List<AppVO> vos = new ArrayList<>();
		if(list != null && list.size() > 0) {
			for(AppEntity appEntity : list) {
				if(appIdMap.containsKey(appEntity.getId())) {
					vos.add(BeanMapper.map(appEntity, AppVO.class));
				}
			}
		}
		
		return  CommonResponse.success(vos);
	}

	@Override
	public CommonResponse<String> saveList(List<AppVO> vos) {
		List<CollectAppEntity> addEEntitys = new ArrayList<>();
		if(vos!=null && vos.size()>0){
			Date currentDate = new Date();
	        long currentTime = currentDate.getTime();
	        int index = 1000;
			for(AppVO vo : vos){
				if(!"del".equals(vo.getRowState())){
					CollectAppEntity entity = new CollectAppEntity();
					entity.setAppId(vo.getId());
					entity.setUserId(InvocationInfoProxy.getUserid());
					entity.setCreateTime(new Date(currentTime + index));
					addEEntitys.add(entity);
					index = index + 1000;
				}
			}
		}
		collectAppMapper.deleteCollectAppByUserId(InvocationInfoProxy.getUserid());
		if(addEEntitys!=null && addEEntitys.size()>0){
			this.saveOrUpdateBatch(addEEntitys, addEEntitys.size(), false);
		}
		return  CommonResponse.success();
	}

	@Override
	public void deleteCollectApp(String appId, Long userId) {
		collectAppMapper.deleteCollectApp(appId, userId);
	}
}
