package com.ejianc.foundation.usercenter.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;

import java.io.InputStream;
import java.util.List;

public interface IAliyunApiService {


    /**
     * 校验照片是否包含可用人脸，通过，返回true，不通过返回false
     *
     * @param inputStream 输入流
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    CommonResponse<Boolean> checkFaceQualityStream(InputStream inputStream,byte[] imgBytes,Integer requestTimes);


    /**
     * 人脸照片活体检查
     * 通过，返回true，不通过返回false
     * @param imgUrl
     * @return
     */
     CommonResponse<Boolean> liveCheck(String imgUrl,Integer requestTimes);


    /**
     * 对比两张图片是否是同一个人
     * 是，返回true，不是返回false
     * 支持URL与Base64编码字符串混合输入。
     * 例如：输入imgUrlA和imgBase64B的值，不输入imgUrlB和imgBase64A的值,合法。
     * @param imgUrlA
     * @param imgUrlB
     * @param imgBase64A
     * @param imgBase64B
     * @return
     */
     CommonResponse<Boolean> compareFace(String imgUrlA,String imgUrlB,String imgBase64A,String imgBase64B,Integer requestTimes);

    /**
     * 对比两张图片是否是同一个人
     * 是，返回true，不是返回false
     * 支持URL与Base64编码字符串混合输入。
     * 例如：输入imgUrlA和imgBase64B的值，不输入imgUrlB和imgBase64A的值,合法。
     * @param imgUrlA
     * @param imgUrlB
     * @param imgBase64A
     * @param imgBase64B
     * @return
     */
     CommonResponse<Boolean> compareFace(InputStream imgUrlA,InputStream imgUrlB,String imgBase64A,String imgBase64B,byte[] imgStrA,byte[] imgStrB,Integer requestTimes);


    /**
     * 对比两张图片是否是同一个人 支持戴口罩进行识别
     *
     * 仅支持Base64编码字符串输入。
     *
     * @param imgBase64A
     * @param imgBase64B
     * @return 是，返回true，不是返回false
     */
     CommonResponse<Boolean> compareFaceWithMask(String imgBase64A,String imgBase64B,Integer requestTimes);


    /**
     * ！！！！！！！！！！！
     * 创建人脸数据库，此接口仅用于公有云平台管理调用，业务请勿调用！！！！！！！！！！
     * ！！！！！！！！！！！
     * @param name
     * @return
     */
     CommonResponse<Boolean> createFaceDb(String name);


    /**
     * ！！！！！！！！！！！
     * 删除人脸数据库，此接口仅用于公有云平台管理调用，业务请勿调用！！！！！！！！！！
     * ！！！！！！！！！！！
     * @param name
     * @return
     */
     CommonResponse<Boolean> deleteFaceDb(String name);


    /**
     * 创建人脸数据库用户
     * @param userId
     * @param userName
     * @return
     */
     CommonResponse<Boolean> createFaceDbUser(Long userId,String userName);

    /**
     * 更新人脸数据库用户
     * @param userId
     * @param userName
     * @return
     */
     CommonResponse<Boolean> updateFaceDbUser(Long userId,String userName);

    /**
     * 删除人脸数据库用户
     * @param userId
     * @return
     */
     CommonResponse<Boolean> deleteFaceDbUser(Long userId);


    /**
     * 查询人脸数据库用户是否存在
     * true 已存在，false不存在
     * @param userId
     * @return
     */
     CommonResponse<Boolean> getFaceDbUser(Long userId,Integer requestTimes);


    /**
     * 根据照片，查询符合照片的员工id
     *
     * @param inputStream
     * @return userId
     */
    CommonResponse<List<Long>> getUserByFaceStream(InputStream inputStream,byte[] imgBytes,Integer requestTimes);



    /**
     * 添加人脸数据到指定用户
     *
     * @param userId
     * @param imageUrl
     * @return
     */
     CommonResponse<Boolean> addFaceToUser(Long userId,InputStream imageUrl,byte[] imgBytes,Integer requestTimes);


    /**
     * 身份证件 信息识别
     * true 翻拍，false 直拍
     * @param imageUrl
     * @param side face：人像面  back：国徽面
     * @return side 是 back 才返回startDate，endDate，issue
     *
     * {
     *     name:姓名,
     *     gender:性别：男、女,
     *     nationality:民族:汉,
     *     birthDate:出生19901122,
     *     address:住址,
     *     idNumber:身份证号,
     *
     *     startDate:起始有效期20200102,
     *     endDate:截止有效期20290102,
     *     issue:颁发机关：xxx公安局
     * }
     */
     CommonResponse<JSONObject> recognizeIdentityCardInfo(InputStream imageUrl, String side,byte[] imgBytes,Integer requestTimes);

    CommonResponse<List<String>> recognizePdfInfo(String pdfUrl,Integer requestTimes);
}
