package com.ejianc.foundation.workbench.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 布局表
 * 
 * @author Dio.zhu
 *
 */
@TableName("ejc_idm_layout")
public class LayoutEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "parent_id")
	private Long parentId;

	@TableField(value = "user_id")
	private Long userId;

	@TableField(value = "code")
	private String code;// 布局编号

	@TableField(value = "name")
	private String name;// 布局名称

	@TableField(value = "setting")
	private String setting;// 布局内容-用于页面渲染

	@TableField(value = "enabled")
	private Integer enabled; // 启停标识（1：启用，0：停用）

	@TableField(value = "sequence")
	private Integer sequence; // 排序

	@TableField(value = "source_id")
	private Long sourceId;// 记录用户租户初始化套餐时来源的门户id

	@TableField(value = "org_id")
	private Long orgId;// 组织id

	/**
	 * 是否自定义布局：0-否，1-是
	 */
	@TableField(value = "design_type")
	private String designType;

	/**
	 * 非自定义布局链接
	 */
	@TableField(value = "template_url")
	private String templateUrl;

	/**
	 * 布局类型：1-PC端布局，2-移动端布局
	 */
	@TableField(value = "type")
	private String type;

	@TableField(value = "refresh_flag")
	private String refreshFlag;

	@TableField(exist = false)
	private String orgName;

	@TableField(value = "system_id")
	private Long systemId;

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSetting() {
		return setting;
	}

	public void setSetting(String setting) {
		this.setting = setting;
	}

	public Integer getEnabled() {
		return enabled;
	}

	public void setEnabled(Integer enabled) {
		this.enabled = enabled;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getDesignType() {
		return designType;
	}

	public void setDesignType(String designType) {
		this.designType = designType;
	}

	public String getTemplateUrl() {
		return templateUrl;
	}

	public void setTemplateUrl(String templateUrl) {
		this.templateUrl = templateUrl;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getRefreshFlag() {
		return refreshFlag;
	}

	public void setRefreshFlag(String refreshFlag) {
		this.refreshFlag = refreshFlag;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getSystemId() {
		return systemId;
	}

	public void setSystemId(Long systemId) {
		this.systemId = systemId;
	}

}
