package com.ejianc.foundation.workbench.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.workbench.bean.MenuEntity;
import com.ejianc.foundation.workbench.vo.MenuItemVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IMenuService extends IBaseService<MenuEntity> {

    /**
     * 根据主键Id查询对应的菜单信息
     *
     * @param id
     * @return
     */
    MenuEntity getOneById(Long id);
    
	List<MenuEntity> queryList(Map<String, Object> condition);

    /**
     * 查询该租户下所有的菜单列表
     * 
     * @param tenantId
     * @param systemId
     * @return
     */
	List<MenuItemVO> queryMenuItemListByTenantId(Long tenantId, String systemId);

	/**
	 * 查询当前用户的菜单列表
	 * 
	 * @return
	 */
	List<MenuItemVO> queryMenuListByCurrentUser(String systemId);

	/**
	 * 查询当前用户的移动菜单列表
	 *
	 * @return
	 */
	List<MenuItemVO> queryMobileMenuListByCurrentUser(String searchText);
	/**
	 * 查询当前用户的菜单列表
	 *
	 * @return
	 */
	List<JSONObject> search(String searchText);

}
