package com.ejianc.business.income.consts;

public enum ProjectSurveyEnum {
    /**
     * 日期
     */
    ALLDATE("all","全部"),
    THISMON("thisMon","本月"),
    NEAR3MON("near3Mon","近三月"),
    NEAR6MON("near6Mon","近6个月"),
    THISYEAR("thisYear","今年"),
    LASTYEAR("lastYear","去年"),
    NEAR4YEAR("near4Year","近四年"),
    /**
     * 项目状态
     */
    RANGE_ALL("all","全部"),
    RANGE_NO_START("noStart","未开工"),
    RANGE_BUILDING("building","在建"),
    RANGE_FINISH("finish","已完工"),
    /*
     * 项目类型
     * */
    PROJECT_TYPE_ALL("all","全部"),
    PROJECT_TYPE_SELF("self","自营"),
    PROJECT_TYPE_UNION("union","联营");

    private String code;

    private String description;
    //构造方法
    private ProjectSurveyEnum(String code, String description ){
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
