package com.ejianc.business.income.dto;

import com.ejianc.business.income.vo.ContractClauseVo;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ContractDto extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 项目
     */
    private Long projectId;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private Integer contractStatus;

    /**
     * 发包单位
     */
    private Long customerId;

    /**
     * 承包单位,
     */
    private Long contractorUnit;

    /**
     * 经营方式：1-自营，2-联营
     */
    private Integer type;

    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    private BigDecimal manageChargeRate;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 合同计价形式，档案
     */
    private Long contractValuationType;

    /**
     * 合同计价形式名称
     */
    private String contractValuationTypeName;

    /**
     * 签约日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 开工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 竣工日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 总工期
     */
    private Integer term;

    /**
     * 合同是否浮动单价 0-否，1-是
     */
    private Integer floatFlag;
    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 备注
     */
    private String memo;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 初始版本金额（含税）
     */
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额
     */
    private BigDecimal baseMoney;

    /**
     * 变更前金额（含税）
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更前金额
     */
    private BigDecimal beforeChangeMny;

    /**
     * 变更中金额（含税）
     */
    private BigDecimal changingTaxMny;

    /**
     * 变更中金额
     */
    private BigDecimal changingMny;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    /**
     * 变更单号
     */
    private String changeCode;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 发包单位名称
     */
    private String customerName;

    /**
     * 承包单位名称
     */
    private String contractorUnitName;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 累计产值报量
     */
    private BigDecimal sumProductionTaxMny;

    /**
     * 累计产值报量
     */
    private BigDecimal sumProductionMny;

    /**
     * 累计甲方报量（含税）
     */
    private BigDecimal sumQuoteTaxMny;

    /**
     * 累计甲方报量
     */
    private BigDecimal sumQuoteMny;

    /**
     * 累计收款
     */
    private BigDecimal sumCollectMny;

    /**
     * 累计开票（含税）
     */
    private BigDecimal sumInvoicingTaxMny;

    /**
     * 累计开票
     */
    private BigDecimal sumInvoicingMny;

    private String contractStatusName;
    private String billStateName;
    /**
     * 累计变更洽商
     */
    private BigDecimal sumClaimMny;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 项目负责人
     */
    private Long projectManager;

    /**
     * 项目负责人名称
     */
    private String projectManagerName;

    /**
     * 项目所属人
     */
    private String projectOwner;

    /**
     * 对方单位负责人
     */
    private String otherPartyManager;

    /**
     * 对方单位负责人联系方式
     */
    private String otherPartyManagerPhone;

    /**
     * 合同类型
     */
    private Long contractType;

    /**
     * 合同类型名称
     */
    private String contractTypeName;
    /**
     * 创建时间 字符
     */
    private String createTimeStr;

    /**
     * 签约时间 字符 临时字段
     */
    private String signDateStr;

    /**
     * 项目详细地址
     */
    private String address;

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getProjectManager() {
        return projectManager;
    }
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getProjectOwner() {
        return projectOwner;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }

    public String getOtherPartyManager() {
        return otherPartyManager;
    }

    public void setOtherPartyManager(String otherPartyManager) {
        this.otherPartyManager = otherPartyManager;
    }

    public String getOtherPartyManagerPhone() {
        return otherPartyManagerPhone;
    }

    public void setOtherPartyManagerPhone(String otherPartyManagerPhone) {
        this.otherPartyManagerPhone = otherPartyManagerPhone;
    }

    public Long getContractType() {
        return contractType;
    }
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public void setCreateTimeStr(String createTimeStr) {
        this.createTimeStr = createTimeStr;
    }

    public String getSignDateStr() {
        return signDateStr;
    }

    public void setSignDateStr(String signDateStr) {
        this.signDateStr = signDateStr;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    private List<ContractDetailVo> checkList = new ArrayList<>();
    private List<ContractClauseVo> clauseList = new ArrayList<>();

    public String getContractStatusName() {
        return contractStatusName;
    }

    public void setContractStatusName(String contractStatusName) {
        this.contractStatusName = contractStatusName;
    }

    public Long getProjectId() {
        return projectId;
    }
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
    public Long getCustomerId() {
        return customerId;
    }
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public Long getContractorUnit() {
        return contractorUnit;
    }
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public String getContractValuationTypeName() {
        return contractValuationTypeName;
    }

    public void setContractValuationTypeName(String contractValuationTypeName) {
        this.contractValuationTypeName = contractValuationTypeName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public Integer getFloatFlag() {
        return floatFlag;
    }

    public void setFloatFlag(Integer floatFlag) {
        this.floatFlag = floatFlag;
    }

    public Long getEmployeeId() {
        return employeeId;
    }
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }

    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    public List<ContractDetailVo> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<ContractDetailVo> checkList) {
        this.checkList = checkList;
    }

    public List<ContractClauseVo> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractClauseVo> clauseList) {
        this.clauseList = clauseList;
    }
}
