package com.ejianc.business.income.history;

import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class QuoteHistoryVo extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同主键
     */
    private Long contractId;
    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;
    /**
     * 累计甲方报量（含税）
     */
    private BigDecimal sumQuoteTaxMny;
    /**
     *  累计应收款（不含本期）
     */
    private BigDecimal sumShouldReceive;
    /**
     * 累计结算比例
     */
    private BigDecimal sumQuoteRate;
    private List<QuoteVo> quoteRecord = new ArrayList<>();

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private Integer contractStatus;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public BigDecimal getSumQuoteRate() {
        return sumQuoteRate;
    }

    public void setSumQuoteRate(BigDecimal sumQuoteRate) {
        this.sumQuoteRate = sumQuoteRate;
    }

    public BigDecimal getSumShouldReceive() {
        return sumShouldReceive;
    }

    public void setSumShouldReceive(BigDecimal sumShouldReceive) {
        this.sumShouldReceive = sumShouldReceive;
    }

    public List<QuoteVo> getQuoteRecord() {
        return quoteRecord;
    }

    public void setQuoteRecord(List<QuoteVo> quoteRecord) {
        this.quoteRecord = quoteRecord;
    }
}
