package com.ejianc.business.income.vo.comparator;

import com.ejianc.business.income.vo.report.ReportMonthVo;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;

public class MonthComparatorVo implements Comparator<ReportMonthVo> {
    @Override
    public int compare(ReportMonthVo c1, ReportMonthVo c2) {
        Integer preArrs = Integer.parseInt(c1.getCountMonth().replaceAll("-", ""));
        Integer sufArrs = Integer.parseInt(c2.getCountMonth().replaceAll("-", ""));
        if (preArrs > sufArrs) {
            return -1;
        } else if (preArrs < sufArrs) {
            return 1;
        }else{
            try {
                SimpleDateFormat sdf  =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date preDate=sdf.parse(c1.getCreateTime());
                Date sufDate=sdf.parse(c2.getCreateTime());
                if (preDate.getTime() > sufDate.getTime()) {
                    return -1;
                } else if (preDate.getTime() < sufDate.getTime()) {
                    return 1;
                }
            } catch (ParseException e1) {
                e1.printStackTrace();
            }
        }
        return 0;
    }
}
