package com.ejianc.business.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * <p>
 * 施工合同变更表
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public class ChangeVo extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private Integer contractStatus;

    /**
     * 发包单位
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 承包单位
     */
    @TableField("contractor_unit")
    private Long contractorUnit;

    /**
     * 经营方式：1-自营，2-联营
     */
    @TableField("type")
    private Integer type;
    /**
     * 质保金
     */
    @TableField("quality_assurance_mny")
    private BigDecimal qualityAssuranceMny;
    /**
     * 质保金到期日期
     */
    @TableField("quality_assurance_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualityAssuranceEndDate;
    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    @TableField("manage_charge_rate")
    private BigDecimal manageChargeRate;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同计价形式，档案
     */
    @TableField("contract_valuation_type")
    private Long contractValuationType;

    /**
     * 签约日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 开工日期
     */
    @TableField("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 竣工日期
     */
    @TableField("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 总工期
     */
    @TableField("term")
    private Integer term;

    /**
     * 合同是否浮动单价 0-否，1-是
     */
    private Integer floatFlag;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 初始版本金额（含税）
     */
    @TableField("base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 变更前金额（含税）
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 变更（编制）时间
     */
    @TableField("change_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeTime;

    /**
     * 生效时间
     */
    @TableField("used_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date usedTime;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 发包单位名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 承包单位名称
     */
    @TableField("contractor_unit_name")
    private String contractorUnitName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 变更前合同名称
     */
    @TableField("before_contract_name")
    private String beforeContractName;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;
    private List<ChangeDetailVo> checkList = new ArrayList<>();
    private List<ChangeClauseVo> clauseList = new ArrayList<>();
    //历史版本编号
    private String historyBillCode;
    //本次变更比例
    private BigDecimal scale;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    /**
     * 变更原因
     */
    private String changeReason;


    /**
     * 项目负责人
     */
    private Long projectManager;

    /**
     * 项目负责人名称
     */
    private String projectManagerName;

    /**
     * 项目所属人
     */
    private String projectOwner;

    /**
     * 对方单位负责人
     */
    private String otherPartyManager;

    /**
     * 对方单位负责人联系方式
     */
    private String otherPartyManagerPhone;

    /**
     * 合同类型
     */
    private Long contractType;

    /**
     * 合同类型名称
     */
    private String contractTypeName;

    /**
     * 本次变更金额
     */
    private BigDecimal bChangeMny;

    private Integer supplementFlag; // 补充协议1是0否
    private BigDecimal contractTempMny; // 合同暂列金
    private BigDecimal estimatePrice; // 暂估价
    private String accountNum; // 银行账号
    private String accountBank; // 开户行
    private BigDecimal buildingPayScale; // 在建支付比例
    private BigDecimal finishedPayScale; // 完工支付比例
    private BigDecimal auditPayScale; // 审计支付比例
    private BigDecimal qualityPayScale; // 质保到期比例

    private String qualityPeriod; // 质保期
    private BigDecimal prepayScale; // 预付款比例

    private String projectCode;

    private BigDecimal tenderProfitMny; // 投资利润额
    private BigDecimal tenderProfitRate; // 投资利润率

    /**
     * 计划完成合同额
     */
    private BigDecimal planFinishContractMny;

    /**
     * 投标成本金额
     */
    private BigDecimal tenderCostMny;


    public BigDecimal getPlanFinishContractMny() {
        return planFinishContractMny;
    }

    public void setPlanFinishContractMny(BigDecimal planFinishContractMny) {
        this.planFinishContractMny = planFinishContractMny;
    }

    public BigDecimal getTenderCostMny() {
        return tenderCostMny;
    }

    public void setTenderCostMny(BigDecimal tenderCostMny) {
        this.tenderCostMny = tenderCostMny;
    }


    public BigDecimal getTenderProfitMny() {
        return tenderProfitMny;
    }

    public void setTenderProfitMny(BigDecimal tenderProfitMny) {
        this.tenderProfitMny = tenderProfitMny;
    }

    public BigDecimal getTenderProfitRate() {
        return tenderProfitRate;
    }

    public void setTenderProfitRate(BigDecimal tenderProfitRate) {
        this.tenderProfitRate = tenderProfitRate;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getQualityPeriod() {
        return qualityPeriod;
    }

    public void setQualityPeriod(String qualityPeriod) {
        this.qualityPeriod = qualityPeriod;
    }

    public BigDecimal getPrepayScale() {
        return prepayScale;
    }

    public void setPrepayScale(BigDecimal prepayScale) {
        this.prepayScale = prepayScale;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public BigDecimal getContractTempMny() {
        return contractTempMny;
    }

    public void setContractTempMny(BigDecimal contractTempMny) {
        this.contractTempMny = contractTempMny;
    }

    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getBuildingPayScale() {
        return buildingPayScale;
    }

    public void setBuildingPayScale(BigDecimal buildingPayScale) {
        this.buildingPayScale = buildingPayScale;
    }

    public BigDecimal getFinishedPayScale() {
        return finishedPayScale;
    }

    public void setFinishedPayScale(BigDecimal finishedPayScale) {
        this.finishedPayScale = finishedPayScale;
    }

    public BigDecimal getAuditPayScale() {
        return auditPayScale;
    }

    public void setAuditPayScale(BigDecimal auditPayScale) {
        this.auditPayScale = auditPayScale;
    }

    public BigDecimal getQualityPayScale() {
        return qualityPayScale;
    }

    public void setQualityPayScale(BigDecimal qualityPayScale) {
        this.qualityPayScale = qualityPayScale;
    }

    public BigDecimal getbChangeMny() {
        return bChangeMny;
    }

    public void setbChangeMny(BigDecimal bChangeMny) {
        this.bChangeMny = bChangeMny;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getProjectManager() {
        return projectManager;
    }
    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getProjectOwner() {
        return projectOwner;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }

    public String getOtherPartyManager() {
        return otherPartyManager;
    }

    public void setOtherPartyManager(String otherPartyManager) {
        this.otherPartyManager = otherPartyManager;
    }

    public String getOtherPartyManagerPhone() {
        return otherPartyManagerPhone;
    }

    public void setOtherPartyManagerPhone(String otherPartyManagerPhone) {
        this.otherPartyManagerPhone = otherPartyManagerPhone;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public String getHistoryBillCode() {
        return historyBillCode;
    }

    public BigDecimal getQualityAssuranceMny() {
        return qualityAssuranceMny;
    }

    public void setQualityAssuranceMny(BigDecimal qualityAssuranceMny) {
        this.qualityAssuranceMny = qualityAssuranceMny;
    }

    public Date getQualityAssuranceEndDate() {
        return qualityAssuranceEndDate;
    }

    public void setQualityAssuranceEndDate(Date qualityAssuranceEndDate) {
        this.qualityAssuranceEndDate = qualityAssuranceEndDate;
    }

    public void setHistoryBillCode(String historyBillCode) {
        this.historyBillCode = historyBillCode;
    }

    public BigDecimal getScale() {
        return scale;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    public List<ChangeDetailVo> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<ChangeDetailVo> checkList) {
        this.checkList = checkList;
    }

    public List<ChangeClauseVo> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ChangeClauseVo> clauseList) {
        this.clauseList = clauseList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getContractorUnit() {
        return contractorUnit;
    }
    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }

    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public Integer getFloatFlag() {
        return floatFlag;
    }

    public void setFloatFlag(Integer floatFlag) {
        this.floatFlag = floatFlag;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

}
