package com.ejianc.business.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.finance.vo.ReceiveQuteDetailVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 甲方报量
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public class QuoteVo extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 报量时间
     */
    @TableField("quote_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date quoteDate;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 本期结算金额（含税）
     */
    @TableField("quote_tax_mny")
    private BigDecimal quoteTaxMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 本期结算金额（不含税）
     */
    @TableField("quote_mny")
    private BigDecimal quoteMny;

    /**
     * 累计结算金额
     */
    @TableField("sum_quote_mny")
    private BigDecimal sumQuoteMny;

    /**
     * 累计结算金额
     */
    @TableField("sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 合同金额(含税)
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;
    /**
     * 累计结算比例
     */
    @TableField("sum_quote_rate")
    private BigDecimal sumQuoteRate;
    private String billStateName;
    private Integer contractVersion;
    private BigDecimal shouldReceive; // 本期应收款
    private BigDecimal sumShouldReceive; // 累计应收款（不含本期）
    private BigDecimal sumShouldReceiveHaveThis; // 累计应收款(含本期)



    private BigDecimal sumQuoteMnyHaveThis; // 累计结算金额(含本期)
    private BigDecimal sumQuoteTaxMnyHaveThis; // 累计结算金额(含本期)
    private BigDecimal sumQuoteRateHaveThis; // 累计结算比例(含本期)
    private BigDecimal totalReceiveTaxMny; // 含本期累计收款金额
    private BigDecimal totalContractReceiveTaxMny; // 合同含本期累计收款金额
    private String memo;
    private BigDecimal diffMny;
    private Boolean rollback;
    private List<QuoteDetailVo> checkList = new ArrayList<>();
    private List<QuoteClaimVo> claimList = new ArrayList<>();
    private List<QuoteOtherVo> otherList = new ArrayList<>();
    private List<ReceiveVO> receiveVOList= new ArrayList<>();
    public BigDecimal getSumQuoteMnyHaveThis() {
        return sumQuoteMnyHaveThis;
    }

    public void setSumQuoteMnyHaveThis(BigDecimal sumQuoteMnyHaveThis) {
        this.sumQuoteMnyHaveThis = sumQuoteMnyHaveThis;
    }

    public BigDecimal getSumQuoteTaxMnyHaveThis() {
        return sumQuoteTaxMnyHaveThis;
    }

    public void setSumQuoteTaxMnyHaveThis(BigDecimal sumQuoteTaxMnyHaveThis) {
        this.sumQuoteTaxMnyHaveThis = sumQuoteTaxMnyHaveThis;
    }

    public BigDecimal getSumQuoteRateHaveThis() {
        return sumQuoteRateHaveThis;
    }

    public void setSumQuoteRateHaveThis(BigDecimal sumQuoteRateHaveThis) {
        this.sumQuoteRateHaveThis = sumQuoteRateHaveThis;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getShouldReceive() {
        return shouldReceive;
    }

    public void setShouldReceive(BigDecimal shouldReceive) {
        this.shouldReceive = shouldReceive;
    }

    public BigDecimal getSumShouldReceive() {
        return sumShouldReceive;
    }

    public void setSumShouldReceive(BigDecimal sumShouldReceive) {
        this.sumShouldReceive = sumShouldReceive;
    }

    public BigDecimal getSumShouldReceiveHaveThis() {
        return sumShouldReceiveHaveThis;
    }

    public void setSumShouldReceiveHaveThis(BigDecimal sumShouldReceiveHaveThis) {
        this.sumShouldReceiveHaveThis = sumShouldReceiveHaveThis;
    }

    public BigDecimal getSumQuoteRate() {
        return sumQuoteRate;
    }

    public void setSumQuoteRate(BigDecimal sumQuoteRate) {
        this.sumQuoteRate = sumQuoteRate;
    }

    public List<QuoteDetailVo> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<QuoteDetailVo> checkList) {
        this.checkList = checkList;
    }

    public List<QuoteClaimVo> getClaimList() {
        return claimList;
    }

    public void setClaimList(List<QuoteClaimVo> claimList) {
        this.claimList = claimList;
    }

    public List<QuoteOtherVo> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<QuoteOtherVo> otherList) {
        this.otherList = otherList;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "income-contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getQuoteDate() {
        return quoteDate;
    }

    public void setQuoteDate(Date quoteDate) {
        this.quoteDate = quoteDate;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getQuoteMny() {
        return quoteMny;
    }

    public void setQuoteMny(BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getTotalReceiveTaxMny() {
        return totalReceiveTaxMny;
    }

    public void setTotalReceiveTaxMny(BigDecimal totalReceiveTaxMny) {
        this.totalReceiveTaxMny = totalReceiveTaxMny;
    }

    public BigDecimal getTotalContractReceiveTaxMny() {
        return totalContractReceiveTaxMny;
    }

    public void setTotalContractReceiveTaxMny(BigDecimal totalContractReceiveTaxMny) {
        this.totalContractReceiveTaxMny = totalContractReceiveTaxMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ReceiveVO> getReceiveVOList() {
        return receiveVOList;
    }

    public void setReceiveVOList(List<ReceiveVO> receiveVOList) {
        this.receiveVOList = receiveVOList;
    }

    public BigDecimal getDiffMny() {
        return diffMny;
    }

    public void setDiffMny(BigDecimal diffMny) {
        this.diffMny = diffMny;
    }

    public Boolean getRollback() {
        return rollback;
    }

    public void setRollback(Boolean rollback) {
        this.rollback = rollback;
    }
}
