package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionClaimEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionClaimService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.utils.DateUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("production")
public class ProductionBpmService implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionClaimService productionClaimService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //回写主表
        ProductionEntity productionEntity = productionService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(productionEntity.getContractId());
        //本期完成产值（含税）
        BigDecimal finishTaxMny = productionEntity.getFinishTaxMny() == null ? BigDecimal.ZERO : productionEntity.getFinishTaxMny();
        //累计产值报量（含税）
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        //累加
        contractEntity.setSumProductionTaxMny(finishTaxMny.add(sumProductionTaxMny));

        //本期完成产值（不含税）
        BigDecimal finishMny = productionEntity.getFinishMny() == null ? BigDecimal.ZERO : productionEntity.getFinishMny();
        //累计产值报量（不含税）
        BigDecimal sumProductionMny = contractEntity.getSumProductionMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionMny();
        //累计产值报量（不含税）
        contractEntity.setSumProductionMny(finishMny.add(sumProductionMny));

        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("productionId", new Parameter(QueryParam.EQ, productionEntity.getId()));
        List<ProductionClaimEntity> claimList = productionClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            Map<Long, BigDecimal> idTaxMap = new HashMap<>();
            for (ProductionClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
                idTaxMap.put(pce.getClaimId(), pce.getClaimOccurTaxMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumProductionMny((ce.getSumProductionMny() == null ? BigDecimal.ZERO : ce.getSumProductionMny())
                        .add(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
                ce.setSumProductionTaxMny((ce.getSumProductionTaxMny() == null ? BigDecimal.ZERO : ce.getSumProductionTaxMny())
                        .add(idTaxMap.get(ce.getId()) == null ? BigDecimal.ZERO : idTaxMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
        return CommonResponse.success();
    }

    // 审批通过回退
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ProductionEntity entity = productionService.selectById(billId);
        LambdaQueryWrapper<ProductionEntity> lamb = new LambdaQueryWrapper();
        lamb.eq(ProductionEntity::getContractId, entity.getContractId());
        lamb.last("and date_format(production_date,'%Y-%m')>'" + DateUtil.getYearAndMonth(entity.getProductionDate())+ "'");
        List<ProductionEntity> list = productionService.list(lamb);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("存在比当前产值统计月份更晚的产值统计，不可跨期弃审！");
        }

        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            callBackProduction(billId,state,billTypeCode);
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
    // 撤回回写
    private void callBackProduction(Long billId, Integer state, String billTypeCode){

        //回写主表
        ProductionEntity productionEntity = productionService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(productionEntity.getContractId());
        //本期完成产值（含税）
        BigDecimal finishTaxMny = productionEntity.getFinishTaxMny() == null ? BigDecimal.ZERO : productionEntity.getFinishTaxMny();
        //累计产值报量（含税）
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        //累减
        contractEntity.setSumProductionTaxMny(sumProductionTaxMny.subtract(finishTaxMny));

        //本期完成产值（不含税）
        BigDecimal finishMny = productionEntity.getFinishMny() == null ? BigDecimal.ZERO : productionEntity.getFinishMny();
        //累计产值报量（不含税）
        BigDecimal sumProductionMny = contractEntity.getSumProductionMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionMny();
        //累计产值报量（不含税）
        contractEntity.setSumProductionMny(sumProductionMny.subtract(finishMny));

        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("productionId", new Parameter(QueryParam.EQ, productionEntity.getId()));
        List<ProductionClaimEntity> claimList = productionClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            Map<Long, BigDecimal> idTaxMap = new HashMap<>();
            for (ProductionClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
                idTaxMap.put(pce.getClaimId(), pce.getClaimOccurTaxMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumProductionMny((ce.getSumProductionMny() == null ? BigDecimal.ZERO : ce.getSumProductionMny())
                        .subtract(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
                ce.setSumProductionTaxMny((ce.getSumProductionTaxMny() == null ? BigDecimal.ZERO : ce.getSumProductionTaxMny())
                        .subtract(idTaxMap.get(ce.getId()) == null ? BigDecimal.ZERO : idTaxMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
    }

}
