package com.ejianc.business.income.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.FinishEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IFinishService;
import com.ejianc.business.income.vo.FinishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 竣工结算
 *
 * @author generator
 */
@RestController
@RequestMapping("/finish")
public class FinishController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IFinishService service;


    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IContractService contractService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinishVO> saveOrUpdate(@RequestBody FinishVO saveorUpdateVO) {
        return service.saveOrUpdateFinish(saveorUpdateVO, false);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinishVO> queryDetail(Long id) {
        FinishEntity entity = service.selectById(id);
        FinishVO vo = BeanMapper.map(entity, FinishVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinishVO> vos) {
        List<Long> ids = vos.stream().map(FinishVO::getId).collect(Collectors.toList());

        LambdaQueryWrapper<FinishEntity> lambda = Wrappers.lambdaQuery();
        lambda.in(FinishEntity::getId, ids);
        List<FinishEntity> finishEntities = service.list(lambda);
        if (CollectionUtils.isNotEmpty(finishEntities)) {
            List<Long> contractIds = finishEntities.stream().map(FinishEntity::getContractId).collect(Collectors.toList());
            //更新合同是否竣工结算标志，合同做完竣工结算则做产值和报量参照不到
            LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(ContractEntity::getIsFinish, 0);
            updateWrapper.in(ContractEntity::getId, contractIds);
            contractService.update(updateWrapper);
        }

        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FinishVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<FinishEntity> page = service.queryPage(param, false);
        IPage<FinishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinishVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<FinishEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<FinishVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), FinishVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });

        }
        beans.put("records", list);
        ExcelExport.getInstance().export("finish-export.xlsx", beans, response);
    }

}
