/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.ProjectInOutVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contract"})
public class ContractController {
    private static volatile HttpServletRequest request;
    private static final String imageUrl = "https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/999999/202102/1356430587925999617.png";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IQuoteService quoteService;
    @Value(value="${common.env.base-host}")
    public String BASE_HOST;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVo> saveOrUpdate(@RequestBody ContractVo contractVo) {
        CommonResponse<ContractVo> response = this.contractService.saveOrUpdate(contractVo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVo> queryDetail(@RequestParam Long id) {
        ContractVo purchaseContractVo = this.contractService.queryDetail(id);
        return CommonResponse.success((Object)purchaseContractVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVo> vos) {
        this.contractService.deleteContract(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.contractService.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.contractService.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVo.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/sumMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> sumMny(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.contractService.queryList(param, false);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal sumBaseMoney = BigDecimal.ZERO;
        BigDecimal sumContractMny = BigDecimal.ZERO;
        for (ContractEntity entity : list) {
            if (entity.getBaseTaxMoney() != null) {
                sumBaseMoney = sumBaseMoney.add(entity.getBaseTaxMoney());
            }
            if (entity.getContractTaxMny() == null) continue;
            sumContractMny = sumContractMny.add(entity.getContractTaxMny());
        }
        map.put("sumBaseMoney", sumBaseMoney);
        map.put("sumContractMny", sumContractMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u6c47\u603b\u91d1\u989d\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/queryRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractEntity>> queryRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getParams().put("is_finish", new Parameter("eq", (Object)0));
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            boolean flag;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("isFinishFlag") && !(flag = Boolean.valueOf(conditionMap.get("isFinishFlag").toString()).booleanValue())) {
                queryParam.getParams().remove("is_finish");
            }
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
        queryParam.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.contractService.queryPage(queryParam, false));
    }

    @PostMapping(value={"changeState"})
    public CommonResponse<String> changeState(@RequestBody ContractVo contractVo) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)contractVo.getId());
        updateWrapper.set(ContractEntity::getContractStatus, (Object)contractVo.getContractStatus());
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.contractService.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVo.class);
            list.forEach(vo -> {
                if (null != vo.getContractStatus()) {
                    if (1 == vo.getContractStatus()) {
                        vo.setContractStatusName("\u672a\u7b7e\u8ba2");
                    } else if (2 == vo.getContractStatus()) {
                        vo.setContractStatusName("\u5c65\u7ea6\u4e2d");
                    } else if (3 == vo.getContractStatus()) {
                        vo.setContractStatusName("\u5df2\u5c01\u8d26");
                    }
                } else {
                    vo.setContractStatusName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryFinanceHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractEntity> queryFinanceHistory(@RequestParam Long id) {
        ContractEntity vo = this.contractService.queryFinanceHistory(id);
        return CommonResponse.success((Object)((Object)vo));
    }

    @RequestMapping(value={"/queryTaxHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceOpenRecordVO> queryTaxHistory(@RequestParam Long id) {
        InvoiceOpenRecordVO vo = this.contractService.queryTaxHistory(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/contractDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVo> contractDetail(@RequestParam Long id) {
        ContractVo vo = this.contractService.contractDetail(id);
        return CommonResponse.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/getAnnuallyCountData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getAnnuallyCountData(@RequestParam Integer type, @RequestParam(value="orgId", required=false) Long orgId, HttpServletRequest req) {
        List<Object> projectIds;
        QueryParam queryParam;
        Calendar calendar;
        BigDecimal totalOpen;
        BigDecimal totalReceiveTax;
        BigDecimal totalOut;
        BigDecimal totalReceiveIn;
        BigDecimal quote;
        BigDecimal claim;
        BigDecimal product;
        block21: {
            List<Object> newIds;
            block20: {
                product = new BigDecimal("0.00");
                claim = new BigDecimal("0.00");
                quote = new BigDecimal("0.00");
                totalReceiveIn = new BigDecimal("0.00");
                totalOut = new BigDecimal("0.00");
                totalReceiveTax = new BigDecimal("0.00");
                totalOpen = new BigDecimal("0.00");
                request = req;
                calendar = Calendar.getInstance();
                queryParam = new QueryParam();
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
                queryParam.getParams().put("productionDate", new Parameter("between", (Object)(calendar.get(1) + "-01-01," + calendar.get(1) + "-12-31")));
                newIds = new ArrayList();
                if (orgId != null) {
                    queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                    CommonResponse listCommonResponse = this.iProjectApi.queryChildrenProjectByOrgId(orgId);
                    if (listCommonResponse.isSuccess()) {
                        List list = (List)listCommonResponse.getData();
                        newIds = list.stream().map(BaseVO::getId).collect(Collectors.toList());
                    }
                }
                projectIds = new ArrayList();
                if (type == 1) break block20;
                CommonResponse commonResponse = this.iProjectApi.getProjectIdsByProperties(type.intValue());
                if (commonResponse.isSuccess()) {
                    projectIds = (List)commonResponse.getData();
                    if (!ListUtil.isNotEmpty(projectIds)) {
                        JSONObject back = new JSONObject();
                        back.put("product", (Object)product);
                        back.put("claim", (Object)claim);
                        back.put("quote", (Object)quote);
                        back.put("totalReceiveIn", (Object)totalReceiveIn);
                        back.put("totalOut", (Object)totalOut);
                        back.put("totalReceiveTax", (Object)totalReceiveTax);
                        back.put("totalOpen", (Object)totalOpen);
                        return CommonResponse.success((Object)back);
                    }
                    if (orgId != null) {
                        projectIds = projectIds.stream().filter(newIds::contains).collect(Collectors.toList());
                    }
                    if (ListUtil.isNotEmpty(projectIds)) {
                        queryParam.getParams().put("projectId", new Parameter("in", projectIds));
                    }
                }
                break block21;
            }
            projectIds = newIds;
        }
        List productionEntities = this.productionService.queryList(queryParam, false);
        queryParam.getParams().remove("productionDate");
        queryParam.getParams().put("occurDate", new Parameter("between", (Object)(calendar.get(1) + "-01-01," + calendar.get(1) + "-12-31")));
        List claimEntities = this.claimService.queryList(queryParam, false);
        queryParam.getParams().remove("occurDate");
        queryParam.getParams().put("quoteDate", new Parameter("between", (Object)(calendar.get(1) + "-01-01," + calendar.get(1) + "-12-31")));
        List quoteEntities = this.quoteService.queryList(queryParam, false);
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        PostDataCallable receiveAndOut = new PostDataCallable(this.BASE_HOST + "ejc-finance-web/api/receive/getAnnuallyCountData", projectIds);
        Future<JSONObject> receiveAndOutFuture = threadPool.submit(receiveAndOut);
        PostDataCallable receiveAndOpen = new PostDataCallable(this.BASE_HOST + "ejc-tax-web/api/tax/getAnnuallyCountData", projectIds);
        Future<JSONObject> receiveAndOpenFuture = threadPool.submit(receiveAndOpen);
        try {
            JSONObject data;
            JSONObject c1 = receiveAndOutFuture.get();
            if (c1.getInteger("code") == 0) {
                data = c1.getJSONObject("data");
                totalReceiveIn = totalReceiveIn.add(data.getBigDecimal("totalReceive"));
                totalOut = totalOut.add(data.getBigDecimal("totalOut"));
            }
            if ((c1 = receiveAndOpenFuture.get()).getInteger("code") == 0) {
                data = c1.getJSONObject("data");
                totalReceiveTax = totalReceiveTax.add(data.getBigDecimal("totalReceive"));
                totalOpen = totalOpen.add(data.getBigDecimal("totalOpen"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            threadPool.shutdown();
        }
        if (ListUtil.isNotEmpty((List)productionEntities)) {
            for (BaseEntity p : productionEntities) {
                if (p.getFinishTaxMny() == null) continue;
                product = product.add(p.getFinishTaxMny());
            }
        }
        if (ListUtil.isNotEmpty((List)claimEntities)) {
            for (BaseEntity p : claimEntities) {
                if (p.getReplyMny() == null) continue;
                claim = claim.add(p.getReplyMny());
            }
        }
        if (ListUtil.isNotEmpty((List)quoteEntities)) {
            for (BaseEntity p : quoteEntities) {
                if (p.getQuoteTaxMny() == null) continue;
                quote = quote.add(p.getQuoteTaxMny());
            }
        }
        JSONObject back = new JSONObject();
        product = product.divide(new BigDecimal("10000")).setScale(2, 4);
        claim = claim.divide(new BigDecimal("10000")).setScale(2, 4);
        quote = quote.divide(new BigDecimal("10000")).setScale(2, 4);
        totalOut = totalOut.divide(new BigDecimal("10000")).setScale(2, 4);
        totalReceiveIn = totalReceiveIn.divide(new BigDecimal("10000")).setScale(2, 4);
        totalReceiveTax = totalReceiveTax.divide(new BigDecimal("10000")).setScale(2, 4);
        totalOpen = totalOpen.divide(new BigDecimal("10000")).setScale(2, 4);
        back.put("product", (Object)product);
        back.put("claim", (Object)claim);
        back.put("quote", (Object)quote);
        back.put("totalReceiveIn", (Object)totalReceiveIn);
        back.put("totalOut", (Object)totalOut);
        back.put("totalReceiveTax", (Object)totalReceiveTax);
        back.put("totalOpen", (Object)totalOpen);
        return CommonResponse.success((Object)back);
    }

    @RequestMapping(value={"/queryProjectInfoList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONArray> queryProjectInfoList(@RequestParam(defaultValue="10") Integer num) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("signDate", "asc");
        CommonResponse projectIdsResp = this.iProjectApi.queryProjectList(num.intValue());
        if (!projectIdsResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u5217\u8868\u5931\u8d25");
        }
        List voList = (List)projectIdsResp.getData();
        JSONArray backArray = new JSONArray();
        if (ListUtil.isNotEmpty((List)voList)) {
            voList.forEach(vo -> {
                JSONObject object = new JSONObject();
                CommonResponse response = this.attachmentApi.queryListBySourceId(vo.getId(), "BT200519000000002", "projectImages", "asc");
                if (response.isSuccess() && ListUtil.isNotEmpty((List)((List)response.getData()))) {
                    if (((AttachmentVO)((List)response.getData()).get(0)).getTruePath() != null) {
                        object.put("imageUrl", (Object)((AttachmentVO)((List)response.getData()).get(0)).getTruePath());
                    } else {
                        object.put("imageUrl", (Object)imageUrl);
                    }
                } else {
                    object.put("imageUrl", (Object)imageUrl);
                }
                object.put("projectName", (Object)vo.getName());
                object.put("area", (Object)(vo.getArea() == null ? "" : vo.getArea()));
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)vo.getId()));
                List contractEntities = this.contractService.queryList(queryParam, false);
                if (ListUtil.isNotEmpty((List)contractEntities)) {
                    Date endDate;
                    Date startDate;
                    object.put("customerName", (Object)(((ContractEntity)((Object)((Object)contractEntities.get(0)))).getCustomerName() == null ? "" : ((ContractEntity)((Object)((Object)contractEntities.get(0)))).getCustomerName()));
                    ArrayList<ContractEntity> comparingStartDateEntities = new ArrayList<ContractEntity>();
                    ArrayList<ContractEntity> comparingEndDateEntities = new ArrayList<ContractEntity>();
                    contractEntities.forEach(c -> {
                        if (c.getStartDate() != null) {
                            comparingStartDateEntities.add((ContractEntity)((Object)((Object)c)));
                        }
                        if (c.getEndDate() != null) {
                            comparingEndDateEntities.add((ContractEntity)((Object)((Object)c)));
                        }
                    });
                    comparingStartDateEntities.sort(Comparator.comparing(ContractEntity::getStartDate));
                    Date date = startDate = comparingStartDateEntities.size() > 0 ? ((ContractEntity)((Object)((Object)comparingStartDateEntities.get(0)))).getStartDate() : null;
                    if (startDate != null) {
                        object.put("startDate", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)startDate));
                    } else {
                        object.put("startDate", (Object)"\u672a\u77e5");
                    }
                    comparingEndDateEntities.sort(Comparator.comparing(ContractEntity::getEndDate).reversed());
                    Date date2 = endDate = comparingEndDateEntities.size() > 0 ? ((ContractEntity)((Object)((Object)comparingEndDateEntities.get(0)))).getEndDate() : null;
                    if (endDate != null) {
                        object.put("endDate", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)endDate));
                    } else {
                        object.put("endDate", (Object)"\u672a\u77e5");
                    }
                    if (startDate != null && endDate != null) {
                        object.put("days", (Object)DateUtil.daysBetween((Date)startDate, (Date)endDate));
                    } else {
                        object.put("days", (Object)"\u672a\u77e5");
                    }
                    BigDecimal money = new BigDecimal("0.00");
                    for (ContractEntity entity : contractEntities) {
                        if (entity.getContractTaxMny() == null) continue;
                        money = money.add(entity.getContractTaxMny());
                    }
                    money = money.setScale(2, 4);
                    object.put("money", (Object)money);
                    if (endDate != null) {
                        int remainDays = DateUtil.daysBetween((Date)new Date(), (Date)endDate);
                        if (remainDays < 0) {
                            remainDays = 0;
                        }
                        object.put("remainDays", (Object)remainDays);
                    } else {
                        object.put("remainDays", (Object)"\u672a\u77e5");
                    }
                } else {
                    if (vo.getPlannedCommencementDate() != null) {
                        object.put("startDate", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getPlannedCommencementDate()));
                    } else {
                        object.put("startDate", (Object)"\u672a\u77e5");
                    }
                    if (vo.getPlannedFinishDate() != null) {
                        object.put("endDate", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getPlannedFinishDate()));
                    } else {
                        object.put("endDate", (Object)"\u672a\u77e5");
                    }
                    if (vo.getPlannedCommencementDate() != null && vo.getPlannedFinishDate() != null) {
                        object.put("days", (Object)DateUtil.daysBetween((Date)vo.getPlannedCommencementDate(), (Date)vo.getPlannedFinishDate()));
                    } else {
                        object.put("days", (Object)"0");
                    }
                    object.put("money", (Object)"0.00");
                    if (vo.getPlannedFinishDate() != null) {
                        int remainDays = DateUtil.daysBetween((Date)new Date(), (Date)vo.getPlannedFinishDate());
                        if (remainDays < 0) {
                            remainDays = 0;
                        }
                        object.put("remainDays", (Object)remainDays);
                    } else {
                        object.put("remainDays", (Object)"0");
                    }
                    object.put("customerName", (Object)(vo.getPubUnitName() == null ? "" : vo.getPubUnitName()));
                }
                backArray.add((Object)object);
            });
        }
        return CommonResponse.success((Object)backArray);
    }

    @PostMapping(value={"analysisContract"})
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        Map<String, Object> result;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((Collection)((List)param.get("projectIds")))) {
            queryParam.getParams().put("projectId", new Parameter("in", param.get("projectIds")));
        }
        String dataStr = null != (result = this.contractService.countContractAmount(queryParam)) && null != result.get("curAmount") ? result.get("curAmount").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);
        return CommonResponse.success((Object)total.divide(new BigDecimal(10000), 2, 4));
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<A> aList = new ArrayList<A>();
        class A {
            private Date date;

            A() {
            }

            public Date getDate() {
                return this.date;
            }

            public void setDate(Date date) {
                this.date = date;
            }
        }
        A a = new A();
        a.setDate(sdf.parse("2010-02-20 12:12:21"));
        aList.add(a);
        a = new A();
        a.setDate(sdf.parse("2000-02-20 12:12:21"));
        aList.add(a);
        a = new A();
        a.setDate(sdf.parse("2012-02-20 12:12:21"));
        aList.add(a);
        a = new A();
        a.setDate(sdf.parse("2015-02-20 12:12:21"));
        aList.add(a);
        a = new A();
        a.setDate(sdf.parse("2013-02-20 12:12:21"));
        aList.add(a);
        aList.sort(Comparator.comparing(A::getDate));
        System.out.println(aList.get(0));
        aList.sort(Comparator.comparing(A::getDate).reversed());
        System.out.println();
        BigDecimal decimal = new BigDecimal("0.00");
        decimal.add(new BigDecimal("2.00"));
        System.out.println(decimal);
    }

    @RequestMapping(value={"/capitalCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> capitalCount(@RequestParam(defaultValue="1") Integer range) {
        return this.contractService.capitalCount(range, ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/getproject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map>> getproject() {
        return this.contractService.getproject(((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/getprogress"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> getprogress(@RequestParam(value="projectId") Long projectId) {
        return this.contractService.getprogress(projectId);
    }

    @RequestMapping(value={"/costCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map>> costCount(@RequestParam(defaultValue="1") Integer range) {
        return this.contractService.costCount(range, ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/projectCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> projectCount(@RequestParam(defaultValue="thisyear") String range, @RequestParam(value="name", required=false) String name, @RequestParam(value="orgIdFlag", required=false) Integer orgIdFlag) {
        Long orgId = null;
        if (orgIdFlag == null) {
            orgId = InvocationInfoProxy.getOrgId();
        } else {
            Long tenantid = InvocationInfoProxy.getTenantid();
            CommonResponse orgByTenantId = this.orgApi.findOrgByTenantId(tenantid);
            orgId = ((OrgVO)orgByTenantId.getData()).getId();
        }
        return this.contractService.projectCount(range, name, ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/proPageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> proPageList(@RequestBody(required=false) Map<String, Object> params) {
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("supplement_flag", new Parameter("eq", (Object)0));
        JSONObject resp = new JSONObject();
        params.put("orgIds", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        IPage<ProjectInOutVO> page = this.contractService.proPageList(params);
        resp.put("data", page);
        return CommonResponse.success((Object)resp);
    }

    class PostDataCallable
    implements Callable<JSONObject> {
        private String url;
        private Object data;

        public PostDataCallable(String url, Object data) {
            this.data = data;
            this.url = url;
        }

        @Override
        public JSONObject call() throws Exception {
            String responseStr = ReferHttpClientUtils.postByJson((String)this.url, (String)JSON.toJSONString((Object)this.data), (HttpServletRequest)request);
            System.out.println(responseStr);
            return JSONObject.parseObject((String)responseStr);
        }
    }
}

