/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/api/contract/"})
public class ContractApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IClaimService claimServicel;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;

    @RequestMapping(value={"updateCollectMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateCollectMny(@RequestParam(value="contractId") Long contractId, @RequestParam(value="collectMny") BigDecimal collectMny, @RequestParam(value="type") Boolean type) {
        this.contractService.updateCollectMny(contractId, collectMny, type);
        return CommonResponse.success((String)"\u66f4\u65b0\u7d2f\u8ba1\u6536\u6b3e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"updateInvoicingMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateInvoicingMny(@RequestParam(value="contractId") Long contractId, @RequestParam(value="invoicingTaxMny") BigDecimal invoicingTaxMny, @RequestParam(value="invoicingMny") BigDecimal invoicingMny, @RequestParam(value="type") Boolean type) {
        this.contractService.updateInvoicingMny(contractId, invoicingTaxMny, invoicingMny, type);
        return CommonResponse.success((String)"\u66f4\u65b0\u7d2f\u8ba1\u5f00\u7968\u6210\u529f\uff01");
    }

    @RequestMapping(value={"searchContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVo> searchContract(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76ee\u4e3b\u952e\u67e5\u8be2\u6700\u65b0\u521b\u5efa\u7684\u5408\u540c\u6210\u529f\uff01", (Object)this.contractService.searchContract(projectId));
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVo> queryDetail(@RequestParam(value="contractId") Long contractId) {
        return CommonResponse.success((String)"\u6839\u636e\u5408\u540c\u4e3b\u952e\u67e5\u8be2\u5408\u540c\u8be6\u60c5\u6210\u529f\uff01", (Object)this.contractService.contractDetail(contractId));
    }

    @RequestMapping(value={"searchContractByTenantIds"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ContractVo>> searchContractByTenantIds(@RequestParam(value="tenantIds") List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.contractService.list((Wrapper)lambda);
        return CommonResponse.success((String)"\u636e\u79df\u6237\u4e3b\u952e\u67e5\u8be2\u751f\u6548\u7684\u5408\u540c\u5217\u8868\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)list, ContractVo.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"incomeCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> countIncomeContract(HttpServletRequest request, @RequestParam(value="projectRange") int projectRange, @RequestParam(value="orgId", required=false) Long orgId) {
        JSONObject data = new JSONObject();
        ArrayList<Long> orgIds = new ArrayList();
        List<Object> newIds = new ArrayList();
        if (orgId != null) {
            orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.projectApi.queryChildrenProjectByOrgId(orgId);
            if (listCommonResponse.isSuccess()) {
                List list = (List)listCommonResponse.getData();
                newIds = list.stream().map(BaseVO::getId).collect(Collectors.toList());
            }
        }
        ArrayList<Long> projectIds = new ArrayList();
        if (projectRange != 1) {
            CommonResponse projectIdsResp = this.projectApi.getProjectIdsByProperties(projectRange);
            if (!projectIdsResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u6761\u4ef6 projectRange-{} \u67e5\u8be2\u9879\u76eeId\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)projectRange, (Object)projectIdsResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u5339\u914d\u7684\u9879\u76ee\u4fe1\u606f\u5931\u8d25\u3002");
            }
            projectIds = (List)projectIdsResp.getData();
            if (orgId != null) {
                projectIds = projectIds.stream().filter(newIds::contains).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(projectIds)) {
                data.put("incomeContractAmtCount", (Object)0);
                data.put("claimAmtCount", (Object)0);
                data.put("productionCount", (Object)0);
                data.put("quoteCount", (Object)0);
                data.put("receiveCount", (Object)0);
                data.put("invoiceOpenCount", (Object)0);
                return CommonResponse.success((Object)data);
            }
        } else {
            projectIds = newIds;
        }
        String authority = request.getHeader("authority");
        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        IncomeCountCallable incomeCountCallable = new IncomeCountCallable(InvocationInfoProxy.getTenantid(), projectIds, RequestContextHolder.getRequestAttributes(), authority, orgIds);
        Future<BigDecimal> countIncomeAmt = threadPool.submit(incomeCountCallable);
        ClaimAmtCountCallable claimAmtCountCallable = new ClaimAmtCountCallable(InvocationInfoProxy.getTenantid(), projectIds, RequestContextHolder.getRequestAttributes(), authority, orgIds);
        Future<Object> claimAmtCount = threadPool.submit(claimAmtCountCallable);
        ProductionCountCallable productionCountCallable = new ProductionCountCallable(InvocationInfoProxy.getTenantid(), projectIds, RequestContextHolder.getRequestAttributes(), authority, orgIds);
        Future<Object> productionCount = threadPool.submit(productionCountCallable);
        QuoteCountCallable quoteCountCallable = new QuoteCountCallable(InvocationInfoProxy.getTenantid(), projectIds, RequestContextHolder.getRequestAttributes(), authority, orgIds);
        Future<Object> quoteCount = threadPool.submit(quoteCountCallable);
        ReceiveCountCallable receiveCountCallable = new ReceiveCountCallable(InvocationInfoProxy.getTenantid(), projectIds, RequestContextHolder.getRequestAttributes(), authority, orgIds);
        Future<Object> receiveCount = threadPool.submit(receiveCountCallable);
        InvoiceOpenCountCallable invoiceOpenCountCallable = new InvoiceOpenCountCallable(InvocationInfoProxy.getTenantid(), projectIds, RequestContextHolder.getRequestAttributes(), authority, orgIds);
        Future<Object> invoiceOpenCount = threadPool.submit(invoiceOpenCountCallable);
        try {
            data.put("incomeContractAmtCount", (Object)countIncomeAmt.get());
            data.put("claimAmtCount", claimAmtCount.get());
            data.put("productionCount", productionCount.get());
            data.put("quoteCount", quoteCount.get());
            data.put("receiveCount", receiveCount.get());
            data.put("invoiceOpenCount", invoiceOpenCount.get());
            CommonResponse commonResponse = CommonResponse.success((Object)data);
            return commonResponse;
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u8ba1\u5408\u540c\u6536\u5165\u60c5\u51b5\u5f02\u5e38, ", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        return CommonResponse.error((String)"\u7edf\u8ba1\u6536\u5165\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
    }

    @PostMapping(value={"getListByQueryParam"})
    public CommonResponse<JSONObject> getListByQueryParam(@RequestBody QueryParam queryParam) {
        List list = this.contractService.queryList(queryParam, false);
        JSONObject back = new JSONObject();
        back.put("records", (Object)list);
        return CommonResponse.success((Object)back);
    }

    class InvoiceOpenCountCallable
    implements Callable<Object> {
        private Long tenantId;
        private List<Long> proIds;
        private RequestAttributes context;
        private String authority;
        private List<Long> orgIds;

        public InvoiceOpenCountCallable(Long tenantId, List<Long> proIds, RequestAttributes context, String authority, List<Long> orgIds) {
            this.tenantId = tenantId;
            this.proIds = proIds;
            this.context = context;
            this.authority = authority;
            this.orgIds = orgIds;
        }

        @Override
        public Object call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantId", this.tenantId);
            param.put("projectIds", this.proIds);
            if (CollectionUtils.isNotEmpty(this.orgIds)) {
                param.put("orgIds", this.orgIds);
            }
            String resp = HttpTookit.postByJson((String)(ContractApi.this.BASE_HOST + "ejc-tax-web/api/tax/countInvoiceOpenByProperties"), (String)JSONObject.toJSONString(param));
            ContractApi.this.logger.info("\u67e5\u8be2\u79df\u6237-{}\u4e0b[\u9879\u76ee\u5217\u8868-{}]\u5df2\u751f\u6548\u7684\u6709\u5408\u540c\u5f00\u7968\u767b\u8bb0\u91d1\u989d\uff08\u542b\u7a0e\uff09\u7ed3\u679c\uff1a{}", new Object[]{this.tenantId, this.proIds, resp});
            try {
                CommonResponse res = (CommonResponse)JSONObject.parseObject((String)resp, CommonResponse.class);
                if (!res.isSuccess()) {
                    ContractApi.this.logger.error("\u67e5\u8be2\u5df2\u751f\u6548\u7684\u6709\u5408\u540c\u5f00\u7968\u767b\u8bb0\u91d1\u989d\uff08\u542b\u7a0e\uff09\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}, ", (Object)res.getMsg());
                    return 0;
                }
                return res.getData();
            }
            catch (Exception e) {
                ContractApi.this.logger.error("\u67e5\u8be2\u5df2\u751f\u6548\u7684\u6709\u5408\u540c\u5f00\u7968\u767b\u8bb0\u91d1\u989d\uff08\u542b\u7a0e\uff09\u5f02\u5e38, ", (Throwable)e);
                return 0;
            }
        }
    }

    class ReceiveCountCallable
    implements Callable<Object> {
        private Long tenantId;
        private List<Long> proIds;
        private RequestAttributes context;
        private String authority;
        private List<Long> orgIds;

        public ReceiveCountCallable(Long tenantId, List<Long> proIds, RequestAttributes context, String authority, List<Long> orgIds) {
            this.tenantId = tenantId;
            this.proIds = proIds;
            this.context = context;
            this.authority = authority;
            this.orgIds = orgIds;
        }

        @Override
        public Object call() throws Exception {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantId", this.tenantId);
            param.put("projectIds", this.proIds);
            if (CollectionUtils.isNotEmpty(this.orgIds)) {
                param.put("orgIds", this.orgIds);
            }
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            String resp = HttpTookit.postByJson((String)(ContractApi.this.BASE_HOST + "ejc-finance-web/api/receive/countByProperties"), (String)JSONObject.toJSONString(param));
            ContractApi.this.logger.info("\u67e5\u8be2\u79df\u6237-{}\u4e0b[\u9879\u76ee\u5217\u8868-{}]\u5df2\u751f\u6548\u7684\u6709\u5408\u540c\u6536\u6b3e\u767b\u8bb0\u91d1\u989d\uff08\u542b\u7a0e\uff09\u7ed3\u679c\uff1a{}", new Object[]{this.tenantId, this.proIds, resp});
            try {
                CommonResponse res = (CommonResponse)JSONObject.parseObject((String)resp, CommonResponse.class);
                if (!res.isSuccess()) {
                    ContractApi.this.logger.error("\u67e5\u8be2\u5df2\u751f\u6548\u7684\u6709\u5408\u540c\u6536\u6b3e\u767b\u8bb0\u91d1\u989d\uff08\u542b\u7a0e\uff09\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}, ", (Object)res.getMsg());
                    return 0;
                }
                return res.getData();
            }
            catch (Exception e) {
                ContractApi.this.logger.error("\u67e5\u8be2\u5df2\u751f\u6548\u7684\u6709\u5408\u540c\u6536\u6b3e\u767b\u8bb0\u91d1\u989d\uff08\u542b\u7a0e\uff09\u5f02\u5e38, ", (Throwable)e);
                return 0;
            }
        }
    }

    class QuoteCountCallable
    implements Callable<Object> {
        private Long tenantId;
        private List<Long> proIds;
        private RequestAttributes context;
        private String authority;
        private List<Long> orgIds;

        public QuoteCountCallable(Long tenantId, List<Long> proIds, RequestAttributes context, String authority, List<Long> orgIds) {
            this.tenantId = tenantId;
            this.proIds = proIds;
            this.context = context;
            this.authority = authority;
            this.orgIds = orgIds;
        }

        @Override
        public Object call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"tenant_id", (Object)this.tenantId);
            if (CollectionUtils.isNotEmpty(this.orgIds)) {
                queryWrapper.in((Object)"org_id", this.orgIds);
            }
            queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            if (CollectionUtils.isNotEmpty(this.proIds)) {
                queryWrapper.in((Object)"project_id", this.proIds);
            }
            queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper.select(new String[]{" round(ifnull(sum(quote_tax_mny),0) / 10000, 2) as amt"});
            Map result = ContractApi.this.quoteService.getMap((Wrapper)queryWrapper);
            return result.get("amt");
        }
    }

    class ProductionCountCallable
    implements Callable<Object> {
        private Long tenantId;
        private List<Long> proIds;
        private RequestAttributes context;
        private String authority;
        private List<Long> orgIds;

        public ProductionCountCallable(Long tenantId, List<Long> proIds, RequestAttributes context, String authority, List<Long> orgIds) {
            this.tenantId = tenantId;
            this.proIds = proIds;
            this.context = context;
            this.authority = authority;
            this.orgIds = orgIds;
        }

        @Override
        public Object call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"tenant_id", (Object)this.tenantId);
            if (CollectionUtils.isNotEmpty(this.orgIds)) {
                queryWrapper.in((Object)"org_id", this.orgIds);
            }
            if (CollectionUtils.isNotEmpty(this.proIds)) {
                queryWrapper.in((Object)"project_id", this.proIds);
            }
            queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper.select(new String[]{" round(ifnull(sum(finish_tax_mny),0) / 10000, 2) as amt"});
            Map result = ContractApi.this.productionService.getMap((Wrapper)queryWrapper);
            return result.get("amt");
        }
    }

    class ClaimAmtCountCallable
    implements Callable<Object> {
        private Long tenantId;
        private List<Long> proIds;
        private RequestAttributes context;
        private String authority;
        private List<Long> orgIds;

        public ClaimAmtCountCallable(Long tenantId, List<Long> proIds, RequestAttributes context, String authority, List<Long> orgIds) {
            this.tenantId = tenantId;
            this.proIds = proIds;
            this.context = context;
            this.authority = authority;
            this.orgIds = orgIds;
        }

        @Override
        public Object call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"tenant_id", (Object)this.tenantId);
            if (CollectionUtils.isNotEmpty(this.orgIds)) {
                queryWrapper.in((Object)"org_id", this.orgIds);
            }
            if (CollectionUtils.isNotEmpty(this.proIds)) {
                queryWrapper.in((Object)"project_id", this.proIds);
            }
            queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper.select(new String[]{" round(ifnull(sum(reply_mny),0) / 10000, 2) as amt"});
            Map result = ContractApi.this.claimServicel.getMap((Wrapper)queryWrapper);
            return result.get("amt");
        }
    }

    class IncomeCountCallable
    implements Callable<BigDecimal> {
        private Long tenantId;
        private List<Long> proIds;
        private RequestAttributes context;
        private String authority;
        private List<Long> orgIds;

        public IncomeCountCallable(Long tenantId, List<Long> proIds, RequestAttributes context, String authority, List<Long> orgIds) {
            this.tenantId = tenantId;
            this.proIds = proIds;
            this.context = context;
            this.authority = authority;
            this.orgIds = orgIds;
        }

        @Override
        public BigDecimal call() throws Exception {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.tenantId));
            if (CollectionUtils.isNotEmpty(this.orgIds)) {
                queryParam.getParams().put("org_id", new Parameter("in", this.orgIds));
            }
            if (CollectionUtils.isNotEmpty(this.proIds)) {
                queryParam.getParams().put("project_id", new Parameter("in", this.proIds));
            }
            queryParam.getParams().put("supplementFlag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
            Map<String, Object> result = ContractApi.this.contractService.countContractAmount(queryParam);
            String num = null != result && null != result.get("curAmount") ? result.get("curAmount").toString() : "0";
            BigDecimal amt = new BigDecimal(num);
            amt.setScale(8, 4);
            return amt.divide(new BigDecimal(10000), 2, 4);
        }
    }
}

