/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller.api;

import com.ejianc.business.income.service.IProductionPlanService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.vo.BlocKanBanVo;
import com.ejianc.business.income.vo.ProductionPlanVO;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/blocKanBan/"})
public class IncomeBlocKanBanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProductionPlanService planService;
    @Autowired
    private IProductionService productionService;

    @RequestMapping(value={"queryProduction"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BlocKanBanVo>> queryProduction(@RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="productionFlag") Integer productionFlag, @RequestParam(value="yearFlag") Integer yearFlag) {
        if (orgId == null) {
            Long tenantid = InvocationInfoProxy.getTenantid();
            CommonResponse orgByTenantId = this.orgApi.findOrgByTenantId(tenantid);
            orgId = ((OrgVO)orgByTenantId.getData()).getId();
        }
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        List<OrgVO> data = this.getOrgVoList();
        Map<String, OrgVO> innerCodeMap = data.stream().filter(vo -> vo.getOrgType() == 2).collect(Collectors.toMap(OrgVO::getInnerCode, Function.identity()));
        Map<Long, OrgVO> idMap = data.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        Map<String, BigDecimal> planTaxMnyMap = this.queryTotalPlanTaxMny(orgIds, idMap, innerCodeMap, yearFlag);
        Map<String, BigDecimal> finishTaxMnyMap = this.queryTotalFinishTaxMny(orgIds, idMap, innerCodeMap, yearFlag);
        HashSet<String> orgNameSet = new HashSet<String>(planTaxMnyMap.keySet());
        orgNameSet.addAll(finishTaxMnyMap.keySet());
        List<Object> voList = new ArrayList();
        for (String orgName : orgNameSet) {
            BlocKanBanVo vo2 = new BlocKanBanVo();
            vo2.setOrgName(orgName);
            vo2.setTotalPlanTaxMny(planTaxMnyMap.getOrDefault(orgName, BigDecimal.ZERO));
            vo2.setTotalFinishTaxMny(finishTaxMnyMap.getOrDefault(orgName, BigDecimal.ZERO));
            vo2.setProductionCompleteRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo2.getTotalFinishTaxMny(), vo2.getTotalPlanTaxMny()), new BigDecimal("100")));
            if (vo2.getProductionCompleteRate().compareTo(new BigDecimal("0E-8")) == 0) {
                vo2.setProductionCompleteRate(BigDecimal.ZERO);
            }
            voList.add(vo2);
        }
        voList = productionFlag == 0 ? voList.stream().filter(vo -> vo.getTotalFinishTaxMny() != null).sorted(Comparator.comparing(BlocKanBanVo::getTotalFinishTaxMny).reversed().thenComparing(BlocKanBanVo::getTotalPlanTaxMny, Comparator.reverseOrder())).limit(5L).collect(Collectors.toList()) : voList.stream().sorted(Comparator.comparing(BlocKanBanVo::getProductionCompleteRate).reversed().thenComparing(BlocKanBanVo::getTotalFinishTaxMny, Comparator.reverseOrder()).thenComparing(BlocKanBanVo::getTotalPlanTaxMny, Comparator.reverseOrder())).limit(5L).collect(Collectors.toList());
        return CommonResponse.success((String)"\u67e5\u8be2\u4ea7\u503ctop5\u6210\u529f", voList);
    }

    public List<OrgVO> getOrgVoList() {
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(1);
        typeList.add(2);
        typeList.add(3);
        typeList.add(4);
        typeList.add(5);
        CommonResponse orgByType = this.orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), typeList, null);
        return (List)orgByType.getData();
    }

    public Map<String, BigDecimal> queryTotalPlanTaxMny(List<Long> orgIds, Map<Long, OrgVO> idMap, Map<String, OrgVO> innerCodeMap, Integer yearFlag) {
        List<ProductionPlanVO> productionPlanVOS = this.planService.queryTotalPlanMny(orgIds, yearFlag);
        HashMap map = new HashMap();
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        for (ProductionPlanVO productionPlanVO : productionPlanVOS) {
            OrgVO orgVO = idMap.get(productionPlanVO.getOrgId());
            String innerCode = orgVO.getInnerCode();
            String orgName = null;
            for (Map.Entry<String, OrgVO> entry : innerCodeMap.entrySet()) {
                if (!innerCode.contains(entry.getKey())) continue;
                orgName = entry.getValue().getName();
                if (map.containsKey(orgName)) {
                    ((List)map.get(orgName)).add(productionPlanVO);
                    continue;
                }
                map.put(orgName, new ArrayList());
                ((List)map.get(orgName)).add(productionPlanVO);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            BigDecimal totalPlanTaxMny = ((List)entry.getValue()).stream().map(ProductionPlanVO::getPlanTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            resultMap.put((String)entry.getKey(), totalPlanTaxMny);
        }
        return resultMap;
    }

    public Map<String, BigDecimal> queryTotalFinishTaxMny(List<Long> orgIds, Map<Long, OrgVO> idMap, Map<String, OrgVO> innerCodeMap, Integer yearFlag) {
        List<ProductionVo> productionVos = this.productionService.queryTotalFinishTaxMny(orgIds, yearFlag);
        HashMap map = new HashMap();
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        for (ProductionVo productionVo : productionVos) {
            OrgVO orgVO = idMap.get(productionVo.getOrgId());
            String innerCode = orgVO.getInnerCode();
            String orgName = null;
            for (Map.Entry<String, OrgVO> entry : innerCodeMap.entrySet()) {
                if (!innerCode.contains(entry.getKey())) continue;
                orgName = entry.getValue().getName();
                if (map.containsKey(orgName)) {
                    ((List)map.get(orgName)).add(productionVo);
                    continue;
                }
                map.put(orgName, new ArrayList());
                ((List)map.get(orgName)).add(productionVo);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            BigDecimal totalFinishTaxMny = ((List)entry.getValue()).stream().map(ProductionVo::getFinishTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            resultMap.put((String)entry.getKey(), totalFinishTaxMny);
        }
        return resultMap;
    }
}

