/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteClaimEntity;
import com.ejianc.business.income.bean.QuoteDetailEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.bean.QuoteOtherEntity;
import com.ejianc.business.income.history.QuoteHistoryVo;
import com.ejianc.business.income.mapper.QuoteMapper;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteClaimService;
import com.ejianc.business.income.service.IQuoteDetailService;
import com.ejianc.business.income.service.IQuoteOtherService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.utils.DateUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.QuoteClaimVo;
import com.ejianc.business.income.vo.QuoteDetailVo;
import com.ejianc.business.income.vo.QuoteOtherVo;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.business.income.vo.comparator.QuoteDetailComparatorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="QuoteService")
public class QuoteServiceImpl
extends BaseServiceImpl<QuoteMapper, QuoteEntity>
implements IQuoteService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String QUOTE_BILL_CODE = "INCOME_QUOTE";
    @Autowired
    private QuoteMapper quoteMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IQuoteDetailService quoteDetailService;
    @Autowired
    private IQuoteClaimService quoteClaimService;
    @Autowired
    private IQuoteOtherService quoteOtherService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionService productionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<QuoteVo> saveOrUpdate(QuoteVo quoteVo) {
        List entities;
        LambdaQueryWrapper lambda;
        ContractEntity contractEntity;
        block54: {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(quoteVo.getContractId()));
            if (contractEntity != null && contractEntity.getIsFinish() == 1) {
                return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u505a\u7ae3\u5de5\u7ed3\u7b97\uff0c\u4e0d\u80fd\u505a\u7532\u65b9\u6279\u91cf\uff01");
            }
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            try {
                CommonResponse param;
                List claimVos;
                List checkVos;
                locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(quoteVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                if (quoteVo.getContractVersion() != null && quoteVo.getContractVersion() != 0) {
                    if (locked) {
                        Integer conVersion;
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (version != (conVersion = quoteVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u65bd\u5de5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                    } else {
                        CommonResponse version = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                        return version;
                    }
                }
                if ((checkVos = quoteVo.getCheckList()) != null && checkVos.size() > 0) {
                    HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
                    for (QuoteDetailVo detailVo : checkVos) {
                        if (detailVo.getProductionVersion() == null || detailVo.getProductionVersion() == 0) continue;
                        versionMap.put(detailVo.getProductionId(), detailVo.getProductionVersion());
                    }
                    if (versionMap != null && versionMap.size() > 0) {
                        CommonResponse param2;
                        if (locked) {
                            param2 = new QueryParam();
                            param2.getParams().put("id", new Parameter("in", new ArrayList(versionMap.keySet())));
                            List productionEntityList = this.productionService.queryList((QueryParam)param2, false);
                            Iterator iterator = productionEntityList.iterator();
                            while (iterator.hasNext()) {
                                Object productionEntity = (ProductionEntity)((Object)iterator.next());
                                if ((productionEntity.getVersion() == null ? 0 : productionEntity.getVersion()) == (Integer)versionMap.get(productionEntity.getId())) continue;
                                CommonResponse commonResponse = CommonResponse.error((String)"\u4ea7\u503c\u8fdb\u5ea6\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                                return commonResponse;
                            }
                        } else {
                            param2 = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                            return param2;
                        }
                    }
                }
                if ((claimVos = quoteVo.getClaimList()) == null || claimVos.size() <= 0) break block54;
                HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
                for (QuoteClaimVo claimVo : claimVos) {
                    if (claimVo.getClaimVersion() == null || claimVo.getClaimVersion() == 0) continue;
                    versionMap.put(claimVo.getClaimId(), claimVo.getClaimVersion());
                }
                if (versionMap == null || versionMap.size() <= 0) break block54;
                if (locked) {
                    param = new QueryParam();
                    param.getParams().put("id", new Parameter("in", new ArrayList(versionMap.keySet())));
                    List claimEntities = this.claimService.queryList((QueryParam)param, false);
                    for (ClaimEntity claimEntity : claimEntities) {
                        if ((claimEntity.getVersion() == null ? 0 : claimEntity.getVersion()) == (Integer)versionMap.get(claimEntity.getId())) continue;
                        CommonResponse commonResponse = CommonResponse.error((String)"\u53d8\u66f4\u7b7e\u8bc1\u6d3d\u5546\u7d22\u8d54\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        return commonResponse;
                    }
                    break block54;
                }
                param = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return param;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(quoteVo.getContractId()), (String)"saveOrUpdate");
                }
                jedis.close();
            }
        }
        LambdaQueryWrapper lamb = new LambdaQueryWrapper();
        lamb.eq(QuoteEntity::getContractId, (Object)quoteVo.getContractId());
        lamb.ne(quoteVo.getId() != null && quoteVo.getId() > 0L, BaseEntity::getId, (Object)quoteVo.getId());
        lamb.last("and date_format(quote_date,'%Y-%m')='" + DateUtil.getYearAndMonth((Date)quoteVo.getQuoteDate()) + "'");
        List list = super.list((Wrapper)lamb);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u8be5\u6708\u4efd\u5df2\u5236\u5b9a\u7532\u65b9\u6279\u91cf\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        Date signDate = contractEntity.getSignDate();
        if (null != signDate && quoteVo.getQuoteDate().getTime() < signDate.getTime()) {
            throw new BusinessException("\u6279\u91cf\u65e5\u671f\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e\u65bd\u5de5\u5408\u540c\u7684\u7b7e\u7ea6\u65e5\u671f");
        }
        Date lastDate = this.quoteMapper.getLastDate(quoteVo.getContractId());
        if (null != lastDate && quoteVo.getQuoteDate().getTime() < lastDate.getTime()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u6bd4\u5f53\u524d\u6708\u4efd\u66f4\u665a\u7684\u4ea7\u503c\u7edf\u8ba1\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        QuoteEntity entity = null;
        String operateType = null;
        if (quoteVo.getId() != null && quoteVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)quoteVo.getBillCode())) {
                quoteVo.setBillCode(null);
            }
            entity = (QuoteEntity)((Object)BeanMapper.map((Object)quoteVo, QuoteEntity.class));
            operateType = "edit";
        } else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)quoteVo.getContractId()));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(0);
            billStatus.add(2);
            billStatus.add(5);
            queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
            List entities2 = super.queryList(queryParam, false);
            if (null != entities2 && entities2.size() > 0) {
                throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u7532\u65b9\u6279\u91cf\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(QUOTE_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            quoteVo.setBillCode((String)billCode.getData());
            entity = (QuoteEntity)((Object)BeanMapper.map((Object)quoteVo, QuoteEntity.class));
            operateType = "add";
        }
        if (quoteVo.getId() != null && quoteVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(QuoteEntity::getBillCode, (Object)quoteVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)quoteVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(QuoteEntity::getBillCode, (Object)quoteVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity);
        List detailsVos = quoteVo.getCheckList();
        ArrayList<QuoteDetailEntity> saveOrUpldates = new ArrayList<QuoteDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (Object detailsVo : detailsVos) {
            QuoteDetailEntity detailslist;
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (QuoteDetailEntity)((Object)BeanMapper.map((Object)detailsVo, QuoteDetailEntity.class));
                detailslist.setQuoteId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (QuoteDetailEntity)((Object)BeanMapper.map((Object)detailsVo, QuoteDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.quoteDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (QuoteDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (QuoteDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.quoteDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.quoteDetailService.removeByIds(deleteIds, false);
        }
        List clauseVos = quoteVo.getClaimList();
        ArrayList<QuoteClaimEntity> clauseList = new ArrayList<QuoteClaimEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (QuoteClaimVo clauseVo : clauseVos) {
            QuoteClaimEntity detailslist;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist = (QuoteClaimEntity)((Object)BeanMapper.map((Object)clauseVo, QuoteClaimEntity.class));
                detailslist.setQuoteId(entity.getId());
                detailslist.setId(null);
                clauseList.add(detailslist);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist = (QuoteClaimEntity)((Object)BeanMapper.map((Object)clauseVo, QuoteClaimEntity.class));
                clauseList.add(detailslist);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (clauseList.size() > 0) {
            this.quoteClaimService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.quoteClaimService.removeByIds(deleteClauseIds, false);
        }
        List otherVos = quoteVo.getOtherList();
        ArrayList<QuoteOtherEntity> otherList = new ArrayList<QuoteOtherEntity>();
        ArrayList<Long> deleteOtherIds = new ArrayList<Long>();
        for (QuoteOtherVo otherVo : otherVos) {
            QuoteOtherEntity detailslist;
            if ("add".equals(otherVo.getRowState())) {
                detailslist = (QuoteOtherEntity)((Object)BeanMapper.map((Object)otherVo, QuoteOtherEntity.class));
                detailslist.setQuoteId(entity.getId());
                detailslist.setId(null);
                otherList.add(detailslist);
                continue;
            }
            if ("edit".equals(otherVo.getRowState())) {
                detailslist = (QuoteOtherEntity)((Object)BeanMapper.map((Object)otherVo, QuoteOtherEntity.class));
                otherList.add(detailslist);
                continue;
            }
            if (!"del".equals(otherVo.getRowState())) continue;
            deleteOtherIds.add(otherVo.getId());
        }
        if (otherList.size() > 0) {
            this.quoteOtherService.saveOrUpdateBatch(otherList, otherList.size(), false);
        }
        if (deleteOtherIds.size() > 0) {
            this.quoteOtherService.removeByIds(deleteOtherIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public QuoteVo queryDetail(Long id) {
        QuoteEntity entity = (QuoteEntity)((Object)this.quoteMapper.selectById(id));
        if (entity != null) {
            QuoteVo vo = (QuoteVo)BeanMapper.map((Object)((Object)entity), QuoteVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("quoteId", new Parameter("eq", (Object)vo.getId()));
            List details = this.quoteDetailService.queryList(queryParam, false);
            if (details != null && details.size() > 0) {
                for (QuoteDetailEntity cdEntity : details) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)details, QuoteDetailVo.class);
                Collections.sort(resultMapList, new QuoteDetailComparatorVo());
                vo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            QueryParam parm = new QueryParam();
            parm.getParams().put("quoteId", new Parameter("eq", (Object)vo.getId()));
            List claimEntities = this.quoteClaimService.queryList(parm, false);
            vo.setClaimList(BeanMapper.mapList((Iterable)claimEntities, QuoteClaimVo.class));
            List otherEntities = this.quoteOtherService.queryList(parm, false);
            vo.setOtherList(BeanMapper.mapList((Iterable)otherEntities, QuoteOtherVo.class));
            return vo;
        }
        return null;
    }

    @Override
    public void deleteQuote(List<QuoteVo> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public QuoteHistoryVo queryQuoteHistory(Long id) {
        BigDecimal sumQuoteTaxMny;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List quoteEntities = this.quoteMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object[])new String[]{"quote_date", "create_time"}));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        QuoteHistoryVo vo = new QuoteHistoryVo();
        vo.setContractId(id);
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setSumQuoteTaxMny(contractEntity.getSumQuoteTaxMny());
        BigDecimal bigDecimal = sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        if (contractEntity.getContractTaxMny() == null || contractEntity.getContractTaxMny().compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumQuoteRate(BigDecimal.ZERO);
        } else {
            vo.setSumQuoteRate(sumQuoteTaxMny.divide(contractEntity.getContractTaxMny(), 8, 4).multiply(new BigDecimal(100)));
        }
        vo.setQuoteRecord(BeanMapper.mapList((Iterable)quoteEntities, QuoteVo.class));
        return vo;
    }
}

