package com.ejianc.business.income.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.history.QuoteHistoryVo;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.utils.DateUtil;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 甲方报量 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@RestController
@RequestMapping("/quote")
public class QuoteController {
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IOrgApi orgApi;

    /**
     * 新增或编辑
     * @param
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuoteVo> saveOrUpdate(@RequestBody QuoteVo vo) {
        CommonResponse<QuoteVo> response = quoteService.saveOrUpdate(vo);
        return response;
    }
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteVo>  queryDetail(@RequestParam Long id) {
        QuoteVo vo= quoteService.queryDetail(id);
        return CommonResponse.success(vo);
    }
    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuoteEntity>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        return CommonResponse.success("查询列表数据成功！",quoteService.queryPage(param,false));
    }
    /**
     * 删除
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuoteVo> vos) {
        quoteService.deleteQuote(vos);
        return CommonResponse.success("删除成功");
    }
    /**
     * 历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryQuoteHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteHistoryVo> queryQuoteHistory(@RequestParam Long id) {
        QuoteHistoryVo vo = quoteService.queryQuoteHistory(id);
        return CommonResponse.success(vo);
    }
    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<QuoteEntity> pageData = quoteService.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<QuoteVo> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), QuoteVo.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });

        }
        beans.put("records", list);
        ExcelExport.getInstance().export("quote-export.xlsx", beans, response);
    }

    /**
     * 查询默认统计日期
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryDefaultDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteVo> queryDefaultDate(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        //已生效状态的单据
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 已生效
        queryParam.getOrderMap().put("quoteDate", QueryParam.DESC);
        List<QuoteEntity> list = quoteService.queryList(queryParam,false);
        Date nextMonth = CollectionUtils.isNotEmpty(list) ? DateUtil.nextMonth(list.get(0).getQuoteDate()) : new Date();
        QuoteVo vo = new QuoteVo();
        vo.setQuoteDate(nextMonth);
        return CommonResponse.success("查询数据成功！", vo);
    }

    /**
     * 根据合同主键，查询是否有非生效单据、所有月份及最大月份
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getValidate")
    @ResponseBody
    public CommonResponse<JSONObject> getValidate(@RequestParam(value = "id", required = false) Long id, @RequestParam(value = "contractId") Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getOrderMap().put("quoteDate", QueryParam.DESC);
        if(id != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));//  编辑过滤自身
        }
        // 所有月份
        List<QuoteEntity> list = quoteService.queryList(queryParam);
        List<String> allMonth = list.stream().map(x->DateUtil.getYearAndMonth(x.getQuoteDate())).distinct().collect(Collectors.toList());
        JSONObject json = new JSONObject();
        json.put("allMonth", allMonth);
        // 最大月份
        json.put("maxDate", CollectionUtils.isNotEmpty(list) ? DateUtil.getYearAndMonth(list.get(0).getQuoteDate()) : null);

        // 是否有非生效单据
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));// 非生效态
        List<QuoteEntity> list2 = quoteService.queryList(queryParam);
        json.put("unEffective", CollectionUtils.isNotEmpty(list2) ? true : false);

        return CommonResponse.success("查询数据成功！", json);
    }

}
