package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.income.bean.IncomeCostCarryoverEntity;
import com.ejianc.business.income.service.IIncomeCostCarryoverService;
import com.ejianc.business.income.utils.NCUtil;;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ArBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ArBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.*;

@Service("incomeCostCarryover") 
public class IncomeCostCarryoverBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IIncomeCostCarryoverService service;

	@Autowired
	private NCUtil ncUtil;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 推送NC传应收单凭证
		IncomeCostCarryoverEntity costCarryoverEntity = service.selectById(billId);
		this.pushToNC(costCarryoverEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 删除NC传应收单凭证
		IncomeCostCarryoverEntity costCarryoverEntity = service.selectById(billId);
		if(StringUtils.isNotEmpty(costCarryoverEntity.getSourceId())){
			String[] split = costCarryoverEntity.getSourceId().split(",");
			for (String sourceId : split){
				JSONObject json = new JSONObject();
				json.put("busitype", "deletearbill");
				json.put("pk_bill", sourceId);
				ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
			}
			LambdaUpdateWrapper<IncomeCostCarryoverEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(IncomeCostCarryoverEntity::getSourceId, null);// 保存来源主键
			wrapper.eq(IncomeCostCarryoverEntity::getId, billId);
			service.update(wrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 推送NC传应收单凭证
	 * @param entity
	 */
	private void pushToNC(IncomeCostCarryoverEntity entity) {
		ArBillVO vo = this.transferToNCVO(entity);// 转换成NCVO
		String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
		LambdaUpdateWrapper<IncomeCostCarryoverEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(IncomeCostCarryoverEntity::getSourceId, sourceId);// 保存来源主键
		wrapper.eq(IncomeCostCarryoverEntity::getId, entity.getId());
		service.update(wrapper);
	}

	/**
	 * 转换成NCVO
	 * @param entity
	 * @return
	 */
	private ArBillVO transferToNCVO(IncomeCostCarryoverEntity entity){
		logger.info("----应收单传凭证开始:");
		ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
		OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
		CustomerVO customerVO = ncUtil.queryCustomerById(entity.getCustomerId());
		ArBillVO vo = new ArBillVO();
		vo.setBusitype("arbill");// 业务标识
		vo.setTradetype("F0-Cxx-003");// 交易类型
		vo.setDef1(false);
		vo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
		vo.setPk_dept(String.valueOf(entity.getDeptId()));// 部门主键
		vo.setDef12(String.valueOf(entity.getId()));// PM单据主键
		vo.setPk_org(orgVO.getCode());// 财务组织编码
		vo.setPk_customer(String.valueOf(entity.getCustomerId()));// 客户主键
		vo.setDef6(customerVO.getInsideOrgId() != null);// 是否内部单位 true/false
		List<ArBillDetailVO> detailVOS = new ArrayList<>();
		ArBillDetailVO detailVO = new ArBillDetailVO();
		detailVO.setPk_project(String.valueOf(entity.getProjectId()));
		detailVO.setNotaxmny(entity.getTheCostMny());
		detailVO.setTotalmny(entity.getTheIncomeMny());
		detailVOS.add(detailVO);
		vo.setDetail(detailVOS);
		return  vo;
	}
}
