package com.ejianc.business.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
/**
 * 补充协议实体
 *
 * @author generator
 *
 */
 @TableName("ejc_income_contract")
public class SupplementEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_status")
    private Integer contractStatus; // 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    @TableField(value="customer_id")
    private Long customerId; // 发包单位
    @TableField(value="contractor_unit")
    private Long contractorUnit; // 承包单位,
    @TableField(value="type")
    private Integer type; // 经营方式：1-自营，2-联营
    @TableField(value="manage_charge_rate")
    private BigDecimal manageChargeRate; // 管理费比例,联营时展示，自营时不展示
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="contract_valuation_type")
    private Long contractValuationType; // 合同计价形式，档案
    @TableField(value="sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    @TableField(value="start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 开工日期
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 竣工日期
    @TableField(value="term")
    private Integer term; // 总工期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="base_tax_money")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @TableField(value="base_money")
    private BigDecimal baseMoney; // 初始版本金额
    @TableField(value="before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="changing_tax_mny")
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="customer_name")
    private String customerName; // 发包单位名称
    @TableField(value="contractor_unit_name")
    private String contractorUnitName; // 承包单位名称
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值报量
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值报量
    @TableField(value="sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny; // 累计甲方报量（含税）
    @TableField(value="sum_quote_mny")
    private BigDecimal sumQuoteMny; // 累计甲方报量
    @TableField(value="sum_collect_mny")
    private BigDecimal sumCollectMny; // 累计收款
    @TableField(value="sum_invoicing_tax_mny")
    private BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    @TableField(value="sum_invoicing_mny")
    private BigDecimal sumInvoicingMny; // 累计开票
    @TableField(value="sum_claim_mny")
    private BigDecimal sumClaimMny; // 累计变更洽商
    /**
     * 累计变更洽商
     */
    @TableField("sum_claim_tax_mny")
    private BigDecimal sumClaimTaxMny;
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)


    @TableField(exist=false)
    @SubEntity(serviceName="supplementDetailService",pidName = "contractId")
    private List<SupplementDetailEntity> checkList = new ArrayList<>(); // 补充协议清单
    @TableField(exist=false)
    @SubEntity(serviceName="supplementClauseService",pidName = "contractId")
    private List<SupplementClauseEntity> clauseList = new ArrayList<>(); // 补充协议条款


    public BigDecimal getSumClaimTaxMny() {
        return sumClaimTaxMny;
    }

    public void setSumClaimTaxMny(BigDecimal sumClaimTaxMny) {
        this.sumClaimTaxMny = sumClaimTaxMny;
    }

    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public Integer getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 发包单位
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 发包单位
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 承包单位,
     */
    public Long getContractorUnit() {
        return contractorUnit;
    }

    /**
     * 承包单位,
     */
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    /**
     * 经营方式：1-自营，2-联营
     */
    public Integer getType() {
        return type;
    }

    /**
     * 经营方式：1-自营，2-联营
     */
    public void setType(Integer type) {
        this.type = type;
    }
    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同计价形式，档案
     */
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 总工期
     */
    public Integer getTerm() {
        return term;
    }

    /**
     * 总工期
     */
    public void setTerm(Integer term) {
        this.term = term;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 税金
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 初始版本金额（含税）
     */
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更中金额（含税）
     */
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    /**
     * 变更中金额
     */
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 发包单位名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 发包单位名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 承包单位名称
     */
    public String getContractorUnitName() {
        return contractorUnitName;
    }

    /**
     * 承包单位名称
     */
    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 累计产值报量
     */
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    /**
     * 累计产值报量
     */
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    /**
     * 累计甲方报量（含税）
     */
    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    /**
     * 累计甲方报量（含税）
     */
    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }
    /**
     * 累计甲方报量
     */
    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    /**
     * 累计甲方报量
     */
    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }
    /**
     * 累计收款
     */
    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    /**
     * 累计收款
     */
    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }
    /**
     * 累计开票（含税）
     */
    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    /**
     * 累计开票（含税）
     */
    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }
    /**
     * 累计开票
     */
    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    /**
     * 累计开票
     */
    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }
    /**
     * 累计变更洽商
     */
    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    /**
     * 累计变更洽商
     */
    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    /**
     * 补充协议清单
     */
    public List<SupplementDetailEntity> getCheckList() {
        return checkList;
    }

    /**
     * 补充协议清单
     */
    public void setCheckList(List<SupplementDetailEntity> checkList) {
        this.checkList = checkList;
    }
    /**
     * 补充协议条款
     */
    public List<SupplementClauseEntity> getClauseList() {
        return clauseList;
    }

    /**
     * 补充协议条款
     */
    public void setClauseList(List<SupplementClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }
}
